/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.icon;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeIconUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;

public class TreeIcon
implements Icon,
UIResource {
    private int size;
    private JTree tree;
    private boolean isCollapsed;

    public TreeIcon(JTree tree, int size, boolean isCollapsed) {
        this.tree = tree;
        this.size = size;
        this.isCollapsed = isCollapsed;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        ComponentState state = this.tree == null || this.tree.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
        RadianceColorScheme fillScheme = RadianceColorSchemeUtilities.getColorScheme(this.tree, state);
        RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(this.tree, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, state);
        RadianceColorScheme markScheme = RadianceColorSchemeUtilities.getColorScheme(this.tree, RadianceThemingSlices.ColorSchemeAssociationKind.MARK, state);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(x, y);
        BladeIconUtils.drawTreeIcon(graphics, this.tree, this.size, fillScheme, borderScheme, markScheme, this.isCollapsed);
        graphics.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }
}

