/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.icon;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JSlider;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.blade.BladeColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeIconUtils;
import org.pushingpixels.radiance.theming.internal.blade.BladeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

public class SliderVerticalIcon
implements Icon,
UIResource {
    private int size;
    private JSlider slider;
    private BladeColorScheme mutableFillColorScheme = new BladeColorScheme();
    private BladeColorScheme mutableBorderColorScheme = new BladeColorScheme();

    public SliderVerticalIcon(JSlider slider, int size) {
        this.slider = slider;
        this.size = size;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)this.slider.getUI());
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        RadianceFillPainter fillPainter = RadianceCoreUtilities.getFillPainter(this.slider);
        RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(this.slider);
        ComponentState currState = modelStateInfo.getCurrModelState();
        float alpha = RadianceColorSchemeUtilities.getAlpha(this.slider, currState);
        BladeUtils.populateColorScheme(this.mutableFillColorScheme, this.slider, modelStateInfo, currState, RadianceThemingSlices.ColorSchemeAssociationKind.FILL, false);
        BladeUtils.populateColorScheme(this.mutableBorderColorScheme, this.slider, modelStateInfo, currState, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, false);
        float activeStrength = stateTransitionTracker.getActiveStrength();
        int height = (int)((float)this.size * (2.0f + activeStrength) / 3.0f);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate((double)x, (double)y - (double)(this.size - height) / 2.0);
        BladeIconUtils.drawSliderThumbVertical(graphics, this.slider, fillPainter, borderPainter, this.size, height, this.mutableFillColorScheme, this.mutableBorderColorScheme, alpha);
        graphics.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }
}

