/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.combo;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.Map;
import javax.swing.JComboBox;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.blade.BladeColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceOutlineUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;

public class ComboBoxBackgroundDelegate {
    private BladeColorScheme mutableFillColorScheme = new BladeColorScheme();
    private BladeColorScheme mutableBorderColorScheme = new BladeColorScheme();

    public void drawBackground(Graphics2D graphics, JComboBox combo, RadianceFillPainter fillPainter, RadianceBorderPainter borderPainter, int width, int height) {
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)combo.getUI());
        StateTransitionTracker.ModelStateInfo modelStateInfo = transitionAwareUI.getTransitionTracker().getModelStateInfo();
        ComponentState currState = modelStateInfo.getCurrModelState();
        BladeUtils.populateColorScheme(this.mutableFillColorScheme, combo, modelStateInfo, currState, RadianceThemingSlices.ColorSchemeAssociationKind.FILL, false);
        BladeUtils.populateColorScheme(this.mutableBorderColorScheme, combo, modelStateInfo, currState, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, false);
        this.drawBackground(graphics, combo, fillPainter, borderPainter, width, height, this.mutableFillColorScheme, this.mutableBorderColorScheme);
    }

    private void drawBackground(Graphics2D g, JComboBox combo, RadianceFillPainter fillPainter, RadianceBorderPainter borderPainter, int width, int height, RadianceColorScheme fillScheme, RadianceColorScheme borderScheme) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height, (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            int comboFontSize = RadianceSizeUtils.getComponentFontSize(combo);
            float radius = (float)scaleFactor * RadianceSizeUtils.getClassicButtonCornerRadius(comboFontSize);
            Shape contourOuter = RadianceOutlineUtilities.getBaseOutline(combo.getComponentOrientation(), scaledWidth - 1, scaledHeight - 1, radius, null, 0.0f);
            Shape contourFill = RadianceOutlineUtilities.getBaseOutline(combo.getComponentOrientation(), scaledWidth, scaledHeight, radius, null, 0.5f);
            fillPainter.paintContourBackground(graphics1X, combo, scaledWidth, scaledHeight, contourFill, fillScheme);
            Shape contourInner = borderPainter.isPaintingInnerContour() ? RadianceOutlineUtilities.getBaseOutline(combo.getComponentOrientation(), scaledWidth - 1, scaledHeight - 1, radius - 1.0f, null, 1.0f) : null;
            borderPainter.paintBorder(graphics1X, combo, scaledWidth, scaledHeight, contourOuter, contourInner, borderScheme);
        });
    }

    public void updateBackground(Graphics g, JComboBox combo) {
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        int width = combo.getWidth();
        int height = combo.getHeight();
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)combo.getUI());
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        boolean isFlat = RadianceCoreUtilities.hasFlatAppearance(combo, false);
        float extraAlpha = 1.0f;
        if (isFlat) {
            extraAlpha = 0.0f;
            for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                ComponentState activeState = activeEntry.getKey();
                if (activeState.isDisabled() || activeState == ComponentState.ENABLED) continue;
                extraAlpha += activeEntry.getValue().getContribution();
            }
        } else if (!combo.isEnabled()) {
            extraAlpha = RadianceColorSchemeUtilities.getAlpha(combo, modelStateInfo.getCurrModelState());
        }
        if (extraAlpha > 0.0f) {
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setComposite(WidgetUtilities.getAlphaComposite(combo, extraAlpha, g));
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            RadianceFillPainter fillPainter = RadianceCoreUtilities.getFillPainter(combo);
            RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(combo);
            this.drawBackground(graphics, combo, fillPainter, borderPainter, width, height);
            graphics.dispose();
        }
    }
}

