/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JToolBar;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;

public class RadianceToolBarBorder
extends AbstractBorder
implements UIResource {
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(x, y);
        if (((JToolBar)c).isFloatable()) {
            RadianceColorScheme scheme = RadianceColorSchemeUtilities.getColorScheme(c, RadianceThemingSlices.ColorSchemeAssociationKind.SEPARATOR, ComponentState.ENABLED);
            int dragBumpsWidth = (int)(0.75 * (double)RadianceSizeUtils.getToolBarDragInset(RadianceSizeUtils.getComponentFontSize(c)));
            if (((JToolBar)c).getOrientation() == 0) {
                int height = c.getHeight() - 4;
                if (height > 0) {
                    if (c.getComponentOrientation().isLeftToRight()) {
                        this.drawDragImage(graphics, c, scheme, 2, 1, dragBumpsWidth, height, 2);
                    } else {
                        this.drawDragImage(graphics, c, scheme, c.getBounds().width - dragBumpsWidth - 2, 1, dragBumpsWidth, height, 2);
                    }
                }
            } else {
                int width = c.getWidth() - 4;
                if (width > 0) {
                    this.drawDragImage(graphics, c, scheme, 2, 2, width, dragBumpsWidth, 2);
                }
            }
        }
        graphics.dispose();
    }

    private void drawDragImage(Graphics2D g, Component c, RadianceColorScheme colorScheme, int x, int y, int width, int height, int maxNumberOfStripes) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(x, y);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color primary = colorScheme.getSeparatorPrimaryColor();
        Color secondary = colorScheme.getSeparatorSecondaryColor();
        int componentFontSize = RadianceSizeUtils.getComponentFontSize(c);
        int bumpDotDiameter = RadianceSizeUtils.getDragBumpDiameter(componentFontSize);
        int bumpCellSize = (int)(1.5 * (double)bumpDotDiameter + 1.0);
        int bumpRows = Math.max(1, height / bumpCellSize - 1);
        int bumpColumns = Math.max(1, (width - 2) / bumpCellSize);
        if (maxNumberOfStripes > 0) {
            if (height > width) {
                bumpColumns = Math.min(bumpColumns, maxNumberOfStripes);
            } else {
                bumpRows = Math.min(bumpRows, maxNumberOfStripes);
            }
        }
        int bumpRowOffset = (height - bumpCellSize * bumpRows) / 2;
        int bumpColOffset = 1 + (width - bumpCellSize * bumpColumns) / 2;
        for (int col = 0; col < bumpColumns; ++col) {
            int cx = bumpColOffset + col * bumpCellSize;
            boolean isEvenCol = col % 2 == 0;
            int offsetY = isEvenCol ? 0 : bumpDotDiameter;
            for (int row = 0; row < bumpRows; ++row) {
                int cy = offsetY + bumpRowOffset + row * bumpCellSize;
                graphics.setColor(secondary);
                graphics.fillOval(cx + 1, cy + 1, bumpDotDiameter, bumpDotDiameter);
                graphics.setColor(primary);
                graphics.fillOval(cx, cy, bumpDotDiameter, bumpDotDiameter);
            }
        }
        graphics.dispose();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets newInsets) {
        Insets margin;
        Insets defaultInsets = RadianceSizeUtils.getToolBarInsets(RadianceSizeUtils.getComponentFontSize(c));
        newInsets.set(defaultInsets.top, defaultInsets.left, defaultInsets.bottom, defaultInsets.right);
        JToolBar toolbar = (JToolBar)c;
        if (toolbar.isFloatable()) {
            int dragInset = RadianceSizeUtils.getToolBarDragInset(RadianceSizeUtils.getComponentFontSize(c));
            if (toolbar.getOrientation() == 0) {
                if (toolbar.getComponentOrientation().isLeftToRight()) {
                    newInsets.left = dragInset;
                } else {
                    newInsets.right = dragInset;
                }
            } else {
                newInsets.top = dragInset;
            }
        }
        if ((margin = toolbar.getMargin()) != null) {
            newInsets.left += margin.left;
            newInsets.top += margin.top;
            newInsets.right += margin.right;
            newInsets.bottom += margin.bottom;
        }
        return newInsets;
    }
}

