/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.blade.BladeColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeDrawingUtils;
import org.pushingpixels.radiance.theming.internal.blade.BladeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

public class RadianceTextComponentBorder
implements Border,
UIResource {
    protected Insets myInsets;
    private BladeColorScheme mutableBorderColorScheme = new BladeColorScheme();

    public RadianceTextComponentBorder(Insets insets) {
        this.myInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    private void paintBorderImpl(JComponent c, Graphics g, int x, int y, int width, int height, boolean isEnabled) {
        TextUI ui;
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        JTextComponent componentForTransitions = RadianceCoreUtilities.getTextComponentForTransitions(c);
        if (componentForTransitions != null && (ui = componentForTransitions.getUI()) instanceof TransitionAwareUI) {
            TransitionAwareUI trackable = (TransitionAwareUI)((Object)ui);
            StateTransitionTracker stateTransitionTracker = trackable.getTransitionTracker();
            StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
            ComponentState currState = modelStateInfo.getCurrModelState();
            if (currState.isDisabled()) {
                currState = ComponentState.DISABLED_SELECTED;
            }
            graphics.translate(x, y);
            BladeUtils.populateColorScheme(this.mutableBorderColorScheme, c, modelStateInfo, currState, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, false);
            BladeDrawingUtils.paintBladeSimpleBorder(c, graphics, width, height, 0.0f, this.mutableBorderColorScheme);
            graphics.dispose();
            return;
        }
        ComponentState currState = isEnabled ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
        RadianceColorScheme borderColorScheme = RadianceColorSchemeUtilities.getColorScheme(c, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, currState);
        graphics.translate(x, y);
        BladeDrawingUtils.paintBladeSimpleBorder(c, graphics, width, height, 0.0f, borderColorScheme);
        graphics.dispose();
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.paintBorderImpl((JComponent)c, g, x, y, width, height, c.isEnabled());
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.myInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

