/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeDrawingUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;

public class RadiancePopupMenuBorder
implements Border,
UIResource {
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(c, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(x, y);
        BladeDrawingUtils.paintBladeSimpleBorder(c, graphics, width, height, 0.0f, borderScheme);
        graphics.dispose();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(1, 1, 1, 1);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

