/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeDrawingUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;

public class RadianceBorder
implements Border,
UIResource {
    protected Insets myInsets;
    protected float alpha = 1.0f;
    protected float radiusScaleFactor = 0.5f;

    public RadianceBorder() {
    }

    public RadianceBorder(Insets insets) {
        this();
        this.myInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    public RadianceBorder(float radiusScaleFactor, Insets insets) {
        this();
        this.radiusScaleFactor = radiusScaleFactor;
        this.myInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    private void paintBorder(Component c, Graphics g, int x, int y, int width, int height, boolean isEnabled, float alpha) {
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        if (alpha == 0.0f) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        ComponentState state = isEnabled ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
        RadianceColorScheme borderColorScheme = RadianceColorSchemeUtilities.getColorScheme(c, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, state);
        float finalAlpha = alpha * RadianceColorSchemeUtilities.getAlpha(c, state);
        graphics.setComposite(WidgetUtilities.getAlphaComposite(c, finalAlpha, g));
        float baseRadius = this.radiusScaleFactor * RadianceSizeUtils.getClassicButtonCornerRadius(RadianceSizeUtils.getComponentFontSize(c));
        BladeDrawingUtils.paintBladeBorder(c, graphics, x, y, width, height, baseRadius, borderColorScheme);
        graphics.dispose();
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.paintBorder(c, g, x, y, width, height, c.isEnabled(), this.alpha);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (this.myInsets == null) {
            return RadianceSizeUtils.getDefaultBorderInsets(RadianceSizeUtils.getComponentFontSize(c));
        }
        return this.myInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public float getRadiusScaleFactor() {
        return this.radiusScaleFactor;
    }
}

