/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.painter.preview.PreviewPainter;
import org.pushingpixels.radiance.theming.api.password.PasswordStrengthChecker;
import org.pushingpixels.radiance.theming.internal.AnimationConfigurationManager;

public class WidgetUtilities {
    public static final String PREVIEW_MODE = "radiance.theming.internal.widget.previewMode";

    private WidgetUtilities() {
    }

    public static void makePreviewable(Component comp, Map<Component, Boolean> dbSnapshot) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            dbSnapshot.put(jcomp, jcomp.isDoubleBuffered());
            jcomp.setDoubleBuffered(false);
            jcomp.putClientProperty(PREVIEW_MODE, Boolean.TRUE);
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                WidgetUtilities.makePreviewable(cont.getComponent(i), dbSnapshot);
            }
        }
    }

    public static void restorePreviewable(Component comp, Map<Component, Boolean> dbSnapshot) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            if (dbSnapshot.containsKey(comp)) {
                jcomp.setDoubleBuffered(dbSnapshot.get(comp));
                jcomp.putClientProperty(PREVIEW_MODE, null);
            } else {
                Container parent = comp.getParent();
                if (parent instanceof JComponent) {
                    jcomp.setDoubleBuffered(dbSnapshot.get(parent));
                    jcomp.putClientProperty(PREVIEW_MODE, null);
                }
            }
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                WidgetUtilities.restorePreviewable(cont.getComponent(i), dbSnapshot);
            }
        }
    }

    public static boolean hasTextFocusSelectAllProperty(JTextComponent textComp) {
        for (Container comp = textComp; comp != null; comp = comp.getParent()) {
            if (!(comp instanceof JComponent)) continue;
            Object textFocusSelectAllProperty = ((JComponent)comp).getClientProperty("radiance.theming.internal.widget.textSelectAllOnFocus");
            if (Boolean.TRUE.equals(textFocusSelectAllProperty)) {
                return true;
            }
            if (!Boolean.FALSE.equals(textFocusSelectAllProperty)) continue;
            return false;
        }
        return Boolean.TRUE.equals(UIManager.get("radiance.theming.internal.widget.textSelectAllOnFocus"));
    }

    public static boolean hasTextFlipSelectOnEscapeProperty(JTextComponent textComp) {
        Object textFocusSelectAllProperty = textComp.getClientProperty("radiance.theming.internal.widget.textFlipSelectOnEscape");
        return Boolean.TRUE.equals(textFocusSelectAllProperty);
    }

    public static boolean hasTextEditContextMenu(JTextComponent textComp) {
        Object textEditContextMenuProperty = textComp.getClientProperty("radiance.theming.internal.widget.textEditContextMenu");
        if (Boolean.TRUE.equals(textEditContextMenuProperty)) {
            return true;
        }
        if (Boolean.FALSE.equals(textEditContextMenuProperty)) {
            return false;
        }
        return Boolean.TRUE.equals(UIManager.get("radiance.theming.internal.widget.textEditContextMenu"));
    }

    public static boolean hasAutoScroll(JScrollPane scrollPane) {
        Object compProperty = scrollPane.getClientProperty("radiance.theming.internal.widget.autoScroll");
        if (Boolean.TRUE.equals(compProperty)) {
            return true;
        }
        if (Boolean.FALSE.equals(compProperty)) {
            return false;
        }
        return Boolean.TRUE.equals(UIManager.get("radiance.theming.internal.widget.autoScroll"));
    }

    public static boolean hasAutomaticDnDSupport(JTree tree) {
        Object dndProperty = tree.getClientProperty("radiance.theming.internal.widget.treeAutoDnDSupport");
        if (Boolean.TRUE.equals(dndProperty)) {
            return true;
        }
        if (Boolean.FALSE.equals(dndProperty)) {
            return false;
        }
        return Boolean.TRUE.equals(UIManager.get("radiance.theming.internal.widget.treeAutoDnDSupport"));
    }

    public static boolean hasNoAnimations(Component comp, RadianceThemingSlices.AnimationFacet animationFacet) {
        return !AnimationConfigurationManager.getInstance().isAnimationAllowed(animationFacet, comp);
    }

    public static Icon getIcon(AbstractButton b) {
        Icon icon = b.getIcon();
        if (icon == null) {
            return null;
        }
        ButtonModel model = b.getModel();
        Icon tmpIcon = null;
        if (icon != null) {
            if (!model.isEnabled()) {
                tmpIcon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                tmpIcon = b.getPressedIcon();
            } else if (b.isRolloverEnabled() && model.isRollover()) {
                tmpIcon = model.isSelected() ? b.getRolloverSelectedIcon() : b.getRolloverIcon();
            } else if (model.isSelected()) {
                tmpIcon = b.getSelectedIcon();
            }
            if (tmpIcon != null) {
                icon = tmpIcon;
            }
        }
        return icon;
    }

    public static boolean toIgnoreAnimations(Component comp) {
        if (comp instanceof JMenuItem) {
            return false;
        }
        return SwingUtilities.getAncestorOfClass(CellRendererPane.class, comp) != null;
    }

    public static void firePropertyChangeEvent(JComponent component, String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent pce = new PropertyChangeEvent(component, propertyName, oldValue, newValue);
        for (PropertyChangeListener general : component.getPropertyChangeListeners()) {
            general.propertyChange(pce);
        }
        for (PropertyChangeListener specific : component.getPropertyChangeListeners(propertyName)) {
            specific.propertyChange(pce);
        }
    }

    public static Composite getAlphaComposite(Component c, float translucency, Graphics g) {
        float finalAlpha;
        AlphaComposite ac;
        Graphics2D g2d;
        Composite existingComposite;
        float xFactor = 1.0f;
        if (g instanceof Graphics2D && (existingComposite = (g2d = (Graphics2D)g).getComposite()) instanceof AlphaComposite && (ac = (AlphaComposite)existingComposite).getRule() == 3) {
            xFactor = ac.getAlpha();
        }
        if ((finalAlpha = translucency * xFactor) < 0.0f) {
            finalAlpha = 0.0f;
        }
        if (finalAlpha > 1.0f) {
            finalAlpha = 1.0f;
        }
        if (finalAlpha == 1.0f) {
            return AlphaComposite.SrcOver;
        }
        return AlphaComposite.SrcOver.derive(finalAlpha);
    }

    public static Composite getAlphaComposite(Component c, float translucency) {
        return WidgetUtilities.getAlphaComposite(c, translucency, null);
    }

    public static Composite getAlphaComposite(Component c, Graphics g) {
        return WidgetUtilities.getAlphaComposite(c, 1.0f, g);
    }

    public static Composite getAlphaComposite(Component c) {
        return WidgetUtilities.getAlphaComposite(c, 1.0f, null);
    }

    public static PreviewPainter getComponentPreviewPainter(Component comp) {
        Object parentProp;
        Object compProp;
        if (comp == null) {
            return null;
        }
        if (comp instanceof JComponent && (compProp = ((JComponent)comp).getClientProperty("radiance.theming.internal.widget.componentPreviewPainter")) instanceof PreviewPainter) {
            return (PreviewPainter)compProp;
        }
        Container parent = comp.getParent();
        if (parent instanceof JComponent && (parentProp = ((JComponent)parent).getClientProperty("radiance.theming.internal.widget.componentPreviewPainter")) instanceof PreviewPainter) {
            return (PreviewPainter)parentProp;
        }
        Object globProp = UIManager.get("radiance.theming.internal.widget.componentPreviewPainter");
        if (globProp instanceof PreviewPainter) {
            return (PreviewPainter)globProp;
        }
        return null;
    }

    public static PasswordStrengthChecker getPasswordStrengthChecker(JPasswordField jpf) {
        Object obj = jpf.getClientProperty("radiance.theming.internal.widget.passwordStrengthChecker");
        if (obj instanceof PasswordStrengthChecker) {
            return (PasswordStrengthChecker)obj;
        }
        return null;
    }
}

