/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.pushingpixels.radiance.animation.api.swing.SwingRepaintCallback;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.common.api.UiThreadingViolationException;
import org.pushingpixels.radiance.common.internal.contrib.jgoodies.looks.LookUtils;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.combo.ComboPopupPrototypeCallback;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.api.shaper.RadianceButtonShaper;
import org.pushingpixels.radiance.theming.api.tabbed.TabCloseCallback;
import org.pushingpixels.radiance.theming.api.titlepane.DefaultTitlePaneButtonsProvider;
import org.pushingpixels.radiance.theming.api.titlepane.TitlePaneButtonsProvider;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.blade.BladeArrowButtonTransitionAwareIcon;
import org.pushingpixels.radiance.theming.internal.blade.BladeArrowIconUtils;
import org.pushingpixels.radiance.theming.internal.blade.BladeTransitionAwareIcon;
import org.pushingpixels.radiance.theming.internal.painter.DecorationPainterUtils;
import org.pushingpixels.radiance.theming.internal.ui.RadianceRootPaneUI;
import org.pushingpixels.radiance.theming.internal.utils.HashMapKey;
import org.pushingpixels.radiance.theming.internal.utils.MemoryAnalyzer;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorResource;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceImageCreator;
import org.pushingpixels.radiance.theming.internal.utils.RadianceInternalButton;
import org.pushingpixels.radiance.theming.internal.utils.RadianceInternalFrameTitlePane;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.ScaleAwareImageWrapperIcon;
import org.pushingpixels.radiance.theming.internal.utils.TrackableThread;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;
import org.pushingpixels.radiance.theming.internal.utils.combo.RadianceComboPopup;
import org.pushingpixels.radiance.theming.internal.utils.icon.TransitionAware;
import org.pushingpixels.radiance.theming.internal.utils.menu.RadianceMenu;

public class RadianceCoreUtilities {
    public static final String IS_COVERED_BY_LIGHTWEIGHT_POPUPS = "radiance.theming.internal.paint.isCoveredByLightweightPopups";
    public static final String TEXT_COMPONENT_AWARE = "radiance.theming.internal.textComponentAware";
    private static List<AWTEventListener> awtEventListeners = new ArrayList<AWTEventListener>();

    private RadianceCoreUtilities() {
    }

    public static String clipString(FontMetrics metrics, int availableWidth, String fullText) {
        if (metrics.stringWidth(fullText) <= availableWidth) {
            return fullText;
        }
        String ellipses = "...";
        int ellipsesWidth = metrics.stringWidth(ellipses);
        if (ellipsesWidth > availableWidth) {
            return "";
        }
        Object starter = "";
        Object ender = "";
        int w = fullText.length();
        int w2 = w / 2 + w % 2;
        Object prevTitle = "";
        for (int i = 0; i < w2; ++i) {
            String newTitle;
            String newStarter = (String)starter + fullText.charAt(i);
            Object newEnder = ender;
            if (w - i > w2) {
                newEnder = fullText.charAt(w - i - 1) + (String)newEnder;
            }
            if (metrics.stringWidth(newTitle = newStarter + ellipses + (String)newEnder) > availableWidth) {
                return prevTitle;
            }
            starter = newStarter;
            ender = newEnder;
            prevTitle = newTitle;
        }
        return fullText;
    }

    public static boolean hasIcon(AbstractButton button) {
        return button.getIcon() != null;
    }

    public static boolean hasText(AbstractButton button) {
        String text = button.getText();
        return text != null && text.length() > 0;
    }

    public static boolean isComboBoxButton(AbstractButton button) {
        return SwingUtilities.getAncestorOfClass(JComboBox.class, button) != null;
    }

    public static boolean isScrollBarButton(AbstractButton button) {
        return SwingUtilities.getAncestorOfClass(JScrollBar.class, button) != null;
    }

    public static boolean isToolBarButton(JComponent component) {
        if (component.getClass().isAnnotationPresent(RadianceInternalButton.class)) {
            return false;
        }
        return SwingUtilities.getAncestorOfClass(JToolBar.class, component) != null;
    }

    public static boolean isComponentNeverPainted(Component component) {
        JComponent jparent;
        Object backgroundAppearanceStrategy;
        JComponent jcomp;
        Object backgroundAppearanceStrategy2;
        if (component instanceof JCheckBox) {
            return false;
        }
        if (component instanceof JRadioButton) {
            return false;
        }
        if (component instanceof JComponent && (backgroundAppearanceStrategy2 = (jcomp = (JComponent)component).getClientProperty("radiance.theming.internal.backgroundAppearanceStrategy")) != null && RadianceThemingSlices.BackgroundAppearanceStrategy.NEVER.equals(backgroundAppearanceStrategy2)) {
            return true;
        }
        Container parent = component.getParent();
        if (parent instanceof JComponent && (backgroundAppearanceStrategy = (jparent = (JComponent)parent).getClientProperty("radiance.theming.internal.backgroundAppearanceStrategy")) != null && RadianceThemingSlices.BackgroundAppearanceStrategy.NEVER.equals(backgroundAppearanceStrategy)) {
            return true;
        }
        return RadianceThemingSlices.BackgroundAppearanceStrategy.NEVER.equals(UIManager.get("radiance.theming.internal.backgroundAppearanceStrategy"));
    }

    public static RadianceThemingSlices.FocusKind getFocusKind(Component component) {
        while (component != null) {
            JComponent jcomp;
            Object jcompFocusKind;
            if (component instanceof JComponent && (jcompFocusKind = (jcomp = (JComponent)component).getClientProperty("radiance.theming.internal.focusKind")) instanceof RadianceThemingSlices.FocusKind) {
                return (RadianceThemingSlices.FocusKind)((Object)jcompFocusKind);
            }
            component = component.getParent();
        }
        Object globalFocusKind = UIManager.get("radiance.theming.internal.focusKind");
        if (globalFocusKind instanceof RadianceThemingSlices.FocusKind) {
            return (RadianceThemingSlices.FocusKind)((Object)globalFocusKind);
        }
        return RadianceThemingSlices.FocusKind.ALL_INNER;
    }

    public static RadianceButtonShaper getButtonShaper(Component comp) {
        Object prop;
        if (comp instanceof JComponent && (prop = ((JComponent)comp).getClientProperty("radiance.theming.internal.buttonShaper")) instanceof RadianceButtonShaper) {
            return (RadianceButtonShaper)prop;
        }
        RadianceSkin skin = RadianceCoreUtilities.getSkin(comp);
        if (skin == null) {
            return null;
        }
        return skin.getButtonShaper();
    }

    public static RadianceFillPainter getFillPainter(Component comp) {
        return RadianceCoreUtilities.getSkin(comp).getFillPainter();
    }

    public static boolean isTabModified(Component tabComponent) {
        if (tabComponent instanceof JComponent) {
            JComponent jc = (JComponent)tabComponent;
            return Boolean.TRUE.equals(jc.getClientProperty("radiance.theming.internal.contentsModified"));
        }
        return false;
    }

    public static boolean isRootPaneModified(JRootPane rootPane) {
        return Boolean.TRUE.equals(rootPane.getClientProperty("radiance.theming.internal.contentsModified"));
    }

    public static TitlePaneButtonsProvider getTitlePaneButtonsProvider(JRootPane rootPane) {
        Object attached;
        if (rootPane != null && (attached = rootPane.getClientProperty("radiance.theming.internal.titlePaneButtonsProvider")) instanceof TitlePaneButtonsProvider) {
            return (TitlePaneButtonsProvider)attached;
        }
        return new DefaultTitlePaneButtonsProvider();
    }

    public static boolean hasCloseButton(JTabbedPane tabbedPane, int tabIndex) {
        Object tabProp;
        int tabCount = tabbedPane.getTabCount();
        if (tabIndex < 0 || tabIndex >= tabCount) {
            return false;
        }
        if (!tabbedPane.isEnabledAt(tabIndex)) {
            return false;
        }
        Component tabComponent = tabbedPane.getComponentAt(tabIndex);
        if (tabComponent instanceof JComponent) {
            Object compProp = ((JComponent)tabComponent).getClientProperty("radiance.theming.internal.tabbedPaneHasCloseButtons");
            if (Boolean.TRUE.equals(compProp)) {
                return true;
            }
            if (Boolean.FALSE.equals(compProp)) {
                return false;
            }
        }
        if (Boolean.TRUE.equals(tabProp = tabbedPane.getClientProperty("radiance.theming.internal.tabbedPaneHasCloseButtons"))) {
            return true;
        }
        if (Boolean.FALSE.equals(tabProp)) {
            return false;
        }
        return UIManager.getBoolean("radiance.theming.internal.tabbedPaneHasCloseButtons");
    }

    public static int getCloseButtonSize(JTabbedPane tabbedPane, int tabIndex) {
        if (!RadianceCoreUtilities.hasCloseButton(tabbedPane, tabIndex)) {
            return 0;
        }
        return RadianceSizeUtils.getTabCloseIconSize(RadianceSizeUtils.getComponentFontSize(tabbedPane));
    }

    public static RadianceThemingSlices.TabContentPaneBorderKind getContentBorderKind(JTabbedPane tabbedPane) {
        Object tabProp = tabbedPane.getClientProperty("radiance.theming.internal.tabbedPaneContentBorderKind");
        if (tabProp instanceof RadianceThemingSlices.TabContentPaneBorderKind) {
            return (RadianceThemingSlices.TabContentPaneBorderKind)((Object)tabProp);
        }
        Object globalProp = UIManager.get("radiance.theming.internal.tabbedPaneContentBorderKind");
        if (globalProp instanceof RadianceThemingSlices.TabContentPaneBorderKind) {
            return (RadianceThemingSlices.TabContentPaneBorderKind)((Object)globalProp);
        }
        return RadianceThemingSlices.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
    }

    public static boolean toAnimateCloseIconOfModifiedTab(JTabbedPane tabbedPane, int tabIndex) {
        Object tabProp;
        int tabCount = tabbedPane.getTabCount();
        if (tabIndex < 0 || tabIndex >= tabCount) {
            return false;
        }
        if (!RadianceCoreUtilities.hasCloseButton(tabbedPane, tabIndex)) {
            return false;
        }
        Component tabComponent = tabbedPane.getComponentAt(tabIndex);
        if (tabComponent instanceof JComponent) {
            Object compProp = ((JComponent)tabComponent).getClientProperty("radiance.theming.internal.tabbedPaneCloseButtonsModifiedAnimation");
            if (Boolean.TRUE.equals(compProp)) {
                return true;
            }
            if (Boolean.FALSE.equals(compProp)) {
                return false;
            }
        }
        if (Boolean.TRUE.equals(tabProp = tabbedPane.getClientProperty("radiance.theming.internal.tabbedPaneCloseButtonsModifiedAnimation"))) {
            return true;
        }
        if (Boolean.FALSE.equals(tabProp)) {
            return false;
        }
        return UIManager.getBoolean("radiance.theming.internal.tabbedPaneCloseButtonsModifiedAnimation");
    }

    public static BufferedImage getBlankImage(double scale, int width, int height) {
        if (MemoryAnalyzer.isRunning() && (width >= 100 || height >= 100)) {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            StringBuffer sb = new StringBuffer();
            int count = 0;
            for (StackTraceElement stackEntry : stack) {
                if (count++ > 8) break;
                sb.append(stackEntry.getClassName() + ".");
                sb.append(stackEntry.getMethodName() + " [");
                sb.append(stackEntry.getLineNumber() + "]");
                sb.append("\n");
            }
            MemoryAnalyzer.enqueueUsage("Blank " + width + "*" + height + "\n" + sb.toString());
        }
        return RadianceCommonCortex.getBlankScaledImage((double)scale, (int)width, (int)height);
    }

    public static boolean hasNoMinSizeProperty(AbstractButton button) {
        Object noMinSizeProperty = button.getClientProperty("radiance.theming.internal.buttonNoMinSize");
        if (Boolean.TRUE.equals(noMinSizeProperty)) {
            return true;
        }
        if (Boolean.FALSE.equals(noMinSizeProperty)) {
            return false;
        }
        Container parent = button.getParent();
        if (parent instanceof JComponent) {
            noMinSizeProperty = ((JComponent)parent).getClientProperty("radiance.theming.internal.buttonNoMinSize");
            if (Boolean.TRUE.equals(noMinSizeProperty)) {
                return true;
            }
            if (Boolean.FALSE.equals(noMinSizeProperty)) {
                return false;
            }
        }
        return Boolean.TRUE.equals(UIManager.get("radiance.theming.internal.buttonNoMinSize"));
    }

    public static void markButtonAsFlat(AbstractButton button) {
        RadianceThemingCortex.ComponentOrParentScope.setBackgroundAppearanceStrategy(button, RadianceThemingSlices.BackgroundAppearanceStrategy.FLAT);
        button.setOpaque(false);
    }

    public static boolean hasFlatAppearance(Component comp, boolean defaultValue) {
        JComponent jparent;
        Object backgroundAppearanceStrategyProperty;
        Container parent;
        JComponent jcomp;
        Object backgroundAppearanceStrategyProperty2;
        if (comp instanceof JCheckBox) {
            return defaultValue;
        }
        if (comp instanceof JRadioButton) {
            return defaultValue;
        }
        Component c = comp;
        if (c instanceof JComponent && (backgroundAppearanceStrategyProperty2 = (jcomp = (JComponent)c).getClientProperty("radiance.theming.internal.backgroundAppearanceStrategy")) != null && RadianceThemingSlices.BackgroundAppearanceStrategy.FLAT.equals(backgroundAppearanceStrategyProperty2)) {
            return true;
        }
        if (c != null && (parent = c.getParent()) instanceof JComponent && (backgroundAppearanceStrategyProperty = (jparent = (JComponent)parent).getClientProperty("radiance.theming.internal.backgroundAppearanceStrategy")) != null && RadianceThemingSlices.BackgroundAppearanceStrategy.FLAT.equals(backgroundAppearanceStrategyProperty)) {
            return true;
        }
        Object backgroundAppearanceStrategyProperty3 = UIManager.get("radiance.theming.internal.backgroundAppearanceStrategy");
        if (backgroundAppearanceStrategyProperty3 != null && RadianceThemingSlices.BackgroundAppearanceStrategy.FLAT.equals(backgroundAppearanceStrategyProperty3)) {
            return true;
        }
        return defaultValue;
    }

    public static boolean hasFlatAppearance(AbstractButton button) {
        if (button instanceof JCheckBox) {
            return false;
        }
        if (button instanceof JRadioButton) {
            return false;
        }
        return RadianceCoreUtilities.isToolBarButton(button) && RadianceCoreUtilities.hasFlatAppearance(button, true) || RadianceCoreUtilities.hasFlatAppearance(button, false);
    }

    public static RadianceThemingSlices.PopupPlacementStrategy getPopupPlacementStrategy(JComboBox combobox) {
        Object comboProperty = combobox.getClientProperty("radiance.theming.internal.comboBoxPopupPlacementStrategy");
        if (comboProperty instanceof RadianceThemingSlices.PopupPlacementStrategy) {
            return (RadianceThemingSlices.PopupPlacementStrategy)comboProperty;
        }
        Object globalProperty = UIManager.get("radiance.theming.internal.comboBoxPopupPlacementStrategy");
        if (globalProperty instanceof RadianceThemingSlices.PopupPlacementStrategy) {
            return (RadianceThemingSlices.PopupPlacementStrategy)globalProperty;
        }
        return RadianceThemingSlices.PopupPlacementStrategy.Downward.HALIGN_START;
    }

    public static void makeNonOpaque(Component comp, Map<Component, Boolean> opacitySnapshot) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            opacitySnapshot.put(comp, jcomp.isOpaque());
            jcomp.setOpaque(false);
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                RadianceCoreUtilities.makeNonOpaque(cont.getComponent(i), opacitySnapshot);
            }
        }
    }

    public static void restoreOpaque(Component comp, Map<Component, Boolean> opacitySnapshot) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            if (opacitySnapshot.containsKey(comp)) {
                jcomp.setOpaque(opacitySnapshot.get(comp));
            } else {
                jcomp.setOpaque(true);
            }
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                RadianceCoreUtilities.restoreOpaque(cont.getComponent(i), opacitySnapshot);
            }
        }
    }

    public static RadianceThemingSlices.IconFilterStrategy getActiveIconFilterStrategy(JComponent comp) {
        if (comp == null || comp.getClass().isAnnotationPresent(RadianceInternalButton.class)) {
            return RadianceThemingSlices.IconFilterStrategy.ORIGINAL;
        }
        Object compProperty = comp.getClientProperty("radiance.theming.internal.iconFilterStrategyActive");
        if (compProperty instanceof RadianceThemingSlices.IconFilterStrategy) {
            return (RadianceThemingSlices.IconFilterStrategy)((Object)compProperty);
        }
        Object globalProperty = UIManager.get("radiance.theming.internal.iconFilterStrategyActive");
        if (globalProperty instanceof RadianceThemingSlices.IconFilterStrategy) {
            return (RadianceThemingSlices.IconFilterStrategy)((Object)globalProperty);
        }
        return RadianceThemingSlices.IconFilterStrategy.ORIGINAL;
    }

    public static RadianceThemingSlices.IconFilterStrategy getEnabledIconFilterStrategy(JComponent comp) {
        if (comp == null || comp.getClass().isAnnotationPresent(RadianceInternalButton.class)) {
            return RadianceThemingSlices.IconFilterStrategy.ORIGINAL;
        }
        Object compProperty = comp.getClientProperty("radiance.theming.internal.iconFilterStrategyEnabled");
        if (compProperty instanceof RadianceThemingSlices.IconFilterStrategy) {
            return (RadianceThemingSlices.IconFilterStrategy)((Object)compProperty);
        }
        Object globalProperty = UIManager.get("radiance.theming.internal.iconFilterStrategyEnabled");
        if (globalProperty instanceof RadianceThemingSlices.IconFilterStrategy) {
            return (RadianceThemingSlices.IconFilterStrategy)((Object)globalProperty);
        }
        return RadianceThemingSlices.IconFilterStrategy.ORIGINAL;
    }

    public static RadianceThemingSlices.IconFilterStrategy getDisabledIconFilterStrategy(JComponent comp) {
        if (comp == null || comp.getClass().isAnnotationPresent(RadianceInternalButton.class)) {
            return RadianceThemingSlices.IconFilterStrategy.THEMED_FOLLOW_COLOR_SCHEME;
        }
        Object compProperty = comp.getClientProperty("radiance.theming.internal.iconFilterStrategyDisabled");
        if (compProperty instanceof RadianceThemingSlices.IconFilterStrategy) {
            return (RadianceThemingSlices.IconFilterStrategy)((Object)compProperty);
        }
        Object globalProperty = UIManager.get("radiance.theming.internal.iconFilterStrategyDisabled");
        if (globalProperty instanceof RadianceThemingSlices.IconFilterStrategy) {
            return (RadianceThemingSlices.IconFilterStrategy)((Object)globalProperty);
        }
        return RadianceThemingSlices.IconFilterStrategy.THEMED_FOLLOW_COLOR_SCHEME;
    }

    public static TabCloseCallback getTabCloseCallback(JTabbedPane tabbedPane, int tabIndex) {
        Object compProp;
        int tabCount = tabbedPane.getTabCount();
        if (tabIndex < 0 || tabIndex >= tabCount) {
            return null;
        }
        Component tabComponent = tabbedPane.getComponentAt(tabIndex);
        if (tabComponent instanceof JComponent && (compProp = ((JComponent)tabComponent).getClientProperty("radiance.theming.internal.tabbedPaneCloseCallback")) instanceof TabCloseCallback) {
            return (TabCloseCallback)compProp;
        }
        Object tabProp = tabbedPane.getClientProperty("radiance.theming.internal.tabbedPaneCloseCallback");
        if (tabProp instanceof TabCloseCallback) {
            return (TabCloseCallback)tabProp;
        }
        Object globProp = UIManager.get("radiance.theming.internal.tabbedPaneCloseCallback");
        if (globProp instanceof TabCloseCallback) {
            return (TabCloseCallback)globProp;
        }
        return null;
    }

    public static <T> T getComboPopupPrototypeDisplayValue(JComboBox<T> combo) {
        Object callback = combo.getClientProperty("radiance.theming.internal.comboPopupPrototype");
        if (callback == null) {
            callback = UIManager.get("radiance.theming.internal.comboPopupPrototype");
        }
        if (callback instanceof ComboPopupPrototypeCallback) {
            return ((ComboPopupPrototypeCallback)callback).getPopupPrototypeDisplayValue(combo);
        }
        Object displayValue = combo.getClientProperty("radiance.theming.internal.comboPopupPrototype");
        if (displayValue == null) {
            displayValue = UIManager.get("radiance.theming.internal.comboPopupPrototype");
        }
        return (T)displayValue;
    }

    public static Set<RadianceThemingSlices.Side> getSides(JComponent component, String propertyName) {
        if (component == null) {
            return null;
        }
        Object prop = component.getClientProperty(propertyName);
        if (prop == null) {
            return null;
        }
        if (prop instanceof Set) {
            return (Set)prop;
        }
        if (prop instanceof RadianceThemingSlices.Side) {
            EnumSet<RadianceThemingSlices.Side> result = EnumSet.noneOf(RadianceThemingSlices.Side.class);
            result.add((RadianceThemingSlices.Side)((Object)prop));
            return result;
        }
        return null;
    }

    public static float getToolbarButtonCornerRadius(JComponent button, float insets) {
        float height;
        JToolBar toolbar = null;
        for (Container c = button.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof JToolBar)) continue;
            toolbar = (JToolBar)c;
            break;
        }
        if (toolbar == null) {
            return 2.0f;
        }
        float width = (float)button.getWidth() - 2.0f * insets;
        float maxRadius = width > (height = (float)button.getHeight() - 2.0f * insets) ? height / 2.0f : width / 2.0f;
        Object buttonProp = button.getClientProperty("radiance.theming.internal.toolbarButtonCornerRadius");
        if (buttonProp instanceof Float) {
            return Math.min(maxRadius, ((Float)buttonProp).floatValue());
        }
        Object toolbarProp = toolbar.getClientProperty("radiance.theming.internal.toolbarButtonCornerRadius");
        if (toolbarProp instanceof Float) {
            return Math.min(maxRadius, ((Float)toolbarProp).floatValue());
        }
        Object globalProp = UIManager.get("radiance.theming.internal.toolbarButtonCornerRadius");
        if (globalProp instanceof Float) {
            return Math.min(maxRadius, ((Float)globalProp).floatValue());
        }
        return 2.0f;
    }

    public static int getEchoPerChar(JPasswordField jpf) {
        int result;
        Object obj = jpf.getClientProperty("radiance.theming.internal.passwordEchoPerChar");
        if (obj instanceof Integer && (result = ((Integer)obj).intValue()) >= 1) {
            return result;
        }
        obj = UIManager.get("radiance.theming.internal.passwordEchoPerChar");
        if (obj instanceof Integer && (result = ((Integer)obj).intValue()) >= 1) {
            return result;
        }
        return 1;
    }

    public static boolean toShowExtraWidgets(Component component) {
        for (Component c = component; c != null; c = c.getParent()) {
            JComponent jcomp;
            Object componentProp;
            if (!(c instanceof JComponent) || (componentProp = (jcomp = (JComponent)c).getClientProperty("radiance.theming.internal.showExtraWidgets")) == null) continue;
            if (Boolean.TRUE.equals(componentProp)) {
                return true;
            }
            if (!Boolean.FALSE.equals(componentProp)) continue;
            return false;
        }
        return Boolean.TRUE.equals(UIManager.get("radiance.theming.internal.showExtraWidgets"));
    }

    public static RadianceThemingSlices.IconFilterStrategy getIconFilterStrategy(JComponent component, ComponentState componentState) {
        if (componentState.isDisabled()) {
            return RadianceCoreUtilities.getDisabledIconFilterStrategy(component);
        }
        if (componentState == ComponentState.ENABLED) {
            return RadianceCoreUtilities.getEnabledIconFilterStrategy(component);
        }
        return RadianceCoreUtilities.getActiveIconFilterStrategy(component);
    }

    public static Icon getFilteredIcon(JComponent comp, Icon orig, ComponentState componentState, Color textColor) {
        double scale = RadianceCommonCortex.getScaleFactor((Component)comp);
        RadianceThemingSlices.IconFilterStrategy iconFilterStrategy = RadianceCoreUtilities.getIconFilterStrategy(comp, componentState);
        RadianceColorScheme colorScheme = RadianceColorSchemeUtilities.getColorScheme(comp, componentState);
        switch (iconFilterStrategy) {
            case ORIGINAL: {
                return orig;
            }
            case THEMED_FOLLOW_TEXT: {
                Color foreground = textColor != null ? textColor : colorScheme.getForegroundColor();
                return new ScaleAwareImageWrapperIcon(RadianceImageCreator.getColorImage(comp, orig, foreground, 1.0f), scale);
            }
            case THEMED_FOLLOW_COLOR_SCHEME: {
                float brightnessFactor = colorScheme.isDark() ? 0.2f : 0.8f;
                return new ScaleAwareImageWrapperIcon(RadianceImageCreator.getColorSchemeImage(comp, orig, colorScheme, brightnessFactor), scale);
            }
        }
        return null;
    }

    public static Icon getFilteredIcon(JTabbedPane tab, Icon orig, ComponentState componentState, Color textColor) {
        double scale = RadianceCommonCortex.getScaleFactor((Component)tab);
        RadianceThemingSlices.IconFilterStrategy iconFilterStrategy = RadianceCoreUtilities.getIconFilterStrategy(tab, componentState);
        RadianceColorScheme colorScheme = RadianceColorSchemeUtilities.getColorScheme(tab, componentState);
        switch (iconFilterStrategy) {
            case ORIGINAL: {
                return orig;
            }
            case THEMED_FOLLOW_TEXT: {
                Color foreground = textColor != null ? textColor : colorScheme.getForegroundColor();
                return new ScaleAwareImageWrapperIcon(RadianceImageCreator.getColorImage(tab, orig, foreground, 1.0f), scale);
            }
            case THEMED_FOLLOW_COLOR_SCHEME: {
                float brightnessFactor = colorScheme.isDark() ? 0.2f : 0.8f;
                return new ScaleAwareImageWrapperIcon(RadianceImageCreator.getColorSchemeImage(tab, orig, colorScheme, brightnessFactor), scale);
            }
        }
        return null;
    }

    public static Icon getOriginalIcon(AbstractButton b, Icon defaultIcon) {
        ButtonModel model = b.getModel();
        Icon icon = b.getIcon();
        if (icon == null) {
            icon = defaultIcon;
        }
        if (icon.getClass().isAnnotationPresent(TransitionAware.class)) {
            return icon;
        }
        Icon tmpIcon = null;
        if (icon != null) {
            if (!model.isEnabled()) {
                tmpIcon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                tmpIcon = b.getPressedIcon();
            } else if (b.isRolloverEnabled() && model.isRollover()) {
                if (model.isSelected()) {
                    tmpIcon = b.getRolloverSelectedIcon();
                    if (tmpIcon == null) {
                        tmpIcon = b.getSelectedIcon();
                    }
                } else {
                    tmpIcon = b.getRolloverIcon();
                }
            } else if (model.isSelected()) {
                tmpIcon = b.getSelectedIcon();
            }
            if (tmpIcon != null) {
                icon = tmpIcon;
            }
        }
        return icon;
    }

    public static float getMenuGutterFillAlpha() {
        Object globalSetting = UIManager.get("radiance.theming.internal.menuGutterFillAlpha");
        if (globalSetting instanceof Float) {
            return ((Float)globalSetting).floatValue();
        }
        return 0.75f;
    }

    public static RadianceThemingSlices.SeparatorAppearance getSeparatorAppearance(JSeparator separator) {
        Object separatorProperty = separator.getClientProperty("radiance.theming.internal.separatorAppearance");
        if (separatorProperty instanceof RadianceThemingSlices.SeparatorAppearance) {
            return (RadianceThemingSlices.SeparatorAppearance)((Object)separatorProperty);
        }
        return RadianceThemingSlices.SeparatorAppearance.SOFT;
    }

    public static Container getHeaderParent(Component c) {
        Container result = null;
        for (Container comp = c.getParent(); comp != null; comp = comp.getParent()) {
            if (comp instanceof JLayeredPane && result == null) {
                result = comp;
            }
            if (result != null || !(comp instanceof Window)) continue;
            result = comp;
        }
        return result;
    }

    public static void paintFocus(Graphics g, Component mainComp, Component focusedComp, TransitionAwareUI transitionAwareUI, double scaleFactor, Shape focusShape, Rectangle textRect, float maxAlphaCoef, float extraPadding) {
        Color color = RadianceColorUtilities.getFocusColor(mainComp, transitionAwareUI);
        RadianceCoreUtilities.paintFocus(g, mainComp, focusedComp, transitionAwareUI, scaleFactor, focusShape, textRect, color, maxAlphaCoef, extraPadding);
    }

    public static void paintFocus(Graphics g, Component mainComp, Component focusedComp, TransitionAwareUI transitionAwareUI, double scaleFactor, Shape focusShape, Rectangle textRect, Color focusColor, float maxAlphaCoef, float extraPadding) {
        float focusStrength = transitionAwareUI.getTransitionTracker().getFocusStrength(focusedComp.hasFocus());
        if (focusStrength == 0.0f) {
            return;
        }
        RadianceThemingSlices.FocusKind focusKind = RadianceCoreUtilities.getFocusKind(mainComp);
        if (focusKind == RadianceThemingSlices.FocusKind.NONE) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float alpha = maxAlphaCoef * focusStrength;
        graphics.setComposite(WidgetUtilities.getAlphaComposite(mainComp, alpha, g));
        graphics.setColor(focusColor);
        focusKind.paintFocus(mainComp, focusedComp, transitionAwareUI, graphics, scaleFactor, focusShape, textRect, extraPadding);
        graphics.dispose();
    }

    public static void uninstallMenu(JMenuItem menuItem) {
        RadianceMenu sMenu;
        ButtonUI menuItemUI;
        if (menuItem instanceof JMenu) {
            JMenu menu = (JMenu)menuItem;
            for (Component comp : menu.getMenuComponents()) {
                if (!(comp instanceof JMenuItem)) continue;
                RadianceCoreUtilities.uninstallMenu((JMenuItem)comp);
            }
        }
        if ((menuItemUI = menuItem.getUI()) instanceof RadianceMenu && (sMenu = (RadianceMenu)((Object)menuItemUI)).getAssociatedMenuItem() != null) {
            menuItemUI.uninstallUI(menuItem);
        }
        for (ActionListener actionListener : menuItem.getActionListeners()) {
            menuItem.removeActionListener(actionListener);
        }
        menuItem.removeAll();
    }

    public static ClassLoader getClassLoaderForResources() {
        ClassLoader cl = (ClassLoader)UIManager.get("ClassLoader");
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        return cl;
    }

    public static boolean isCoveredByLightweightPopups(Component comp) {
        int popupIndexToStartWith;
        JRootPane rootPane = SwingUtilities.getRootPane(comp);
        if (rootPane == null) {
            return false;
        }
        Component[] popups = rootPane.getLayeredPane().getComponentsInLayer(JLayeredPane.POPUP_LAYER);
        if (popups == null) {
            return false;
        }
        Rectangle compBoundsConverted = SwingUtilities.convertRectangle(comp.getParent(), comp.getBounds(), rootPane.getLayeredPane());
        for (int i = popupIndexToStartWith = RadianceCoreUtilities.getPopupParentIndexOf(comp, popups) - 1; i >= 0; --i) {
            Component popup = popups[i];
            if (!compBoundsConverted.intersects(popup.getBounds())) continue;
            return true;
        }
        return false;
    }

    public static int getPopupParentIndexOf(Component comp, Component[] popups) {
        for (int i = 0; i < popups.length; ++i) {
            Component popup = popups[i];
            for (Component currComp = comp; currComp != null; currComp = currComp.getParent()) {
                if (currComp != popup) continue;
                return i;
            }
        }
        return popups.length;
    }

    public static RadianceBorderPainter getBorderPainter(Component comp) {
        return RadianceCoreUtilities.getSkin(comp).getBorderPainter();
    }

    public static RadianceBorderPainter getHighlightBorderPainter(Component comp) {
        RadianceBorderPainter result = RadianceCoreUtilities.getSkin(comp).getHighlightBorderPainter();
        if (result != null) {
            return result;
        }
        return RadianceCoreUtilities.getBorderPainter(comp);
    }

    public static String getHierarchy(Component comp) {
        StringBuffer buffer = new StringBuffer();
        RadianceCoreUtilities.getHierarchy(comp, buffer, 0);
        while (comp instanceof Window) {
            Window w = (Window)comp;
            if ((comp = w.getOwner()) == null) continue;
            buffer.append("Owner --->\n");
            RadianceCoreUtilities.getHierarchy(comp, buffer, 0);
        }
        return buffer.toString();
    }

    public static void getHierarchy(Component comp, StringBuffer buffer, int level) {
        for (int i = 0; i < level; ++i) {
            buffer.append("   ");
        }
        String name = comp.getName();
        if (comp instanceof Dialog) {
            name = ((Dialog)comp).getTitle();
        }
        if (comp instanceof Frame) {
            name = ((Frame)comp).getTitle();
        }
        buffer.append(comp.getClass().getName() + "[" + name + "]\n");
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                RadianceCoreUtilities.getHierarchy(cont.getComponent(i), buffer, level + 1);
            }
        }
    }

    public static Icon getArrowIcon(AbstractButton button, int orientation) {
        int fontSize = RadianceSizeUtils.getComponentFontSize(button);
        return new BladeArrowButtonTransitionAwareIcon(button, BladeArrowIconUtils.getArrowIconDimension(fontSize, orientation), orientation);
    }

    public static Icon getArrowIcon(JComponent comp, BladeTransitionAwareIcon.TransitionAwareUIDelegate transitionAwareUIDelegate, int orientation) {
        int fontSize = RadianceSizeUtils.getComponentFontSize(comp);
        return new BladeArrowButtonTransitionAwareIcon(comp, transitionAwareUIDelegate, BladeArrowIconUtils.getArrowIconDimension(fontSize, orientation), orientation);
    }

    public static int placementStrategyToOrientation(JComponent comp, RadianceThemingSlices.PopupPlacementStrategy popupPlacementStrategy) {
        boolean ltr = comp.getComponentOrientation().isLeftToRight();
        if (popupPlacementStrategy instanceof RadianceThemingSlices.PopupPlacementStrategy.Upward) {
            return 1;
        }
        if (popupPlacementStrategy instanceof RadianceThemingSlices.PopupPlacementStrategy.Downward) {
            return 5;
        }
        if (popupPlacementStrategy instanceof RadianceThemingSlices.PopupPlacementStrategy.CenteredVertically) {
            return 0;
        }
        if (popupPlacementStrategy instanceof RadianceThemingSlices.PopupPlacementStrategy.Startward) {
            return ltr ? 7 : 3;
        }
        if (popupPlacementStrategy instanceof RadianceThemingSlices.PopupPlacementStrategy.Endward) {
            return ltr ? 3 : 7;
        }
        return 5;
    }

    public static Dimension getPlacementAwarePopupShift(boolean ltr, Dimension anchorDimension, Dimension popupDimension, Insets popupInsets, RadianceThemingSlices.PopupPlacementStrategy popupPlacementStrategy) {
        int dx = 0;
        int dy = 0;
        int anchorWidth = anchorDimension.width;
        int anchorHeight = anchorDimension.height;
        int popupWidth = popupDimension.width;
        int popupHeight = popupDimension.height;
        if (popupPlacementStrategy == RadianceThemingSlices.PopupPlacementStrategy.Upward.HALIGN_START) {
            dy = -popupHeight - anchorHeight - popupInsets.top - popupInsets.bottom;
            if (!ltr) {
                dx = anchorWidth - popupWidth;
            }
        }
        if (popupPlacementStrategy == RadianceThemingSlices.PopupPlacementStrategy.Upward.HALIGN_END) {
            dy = -popupHeight - anchorHeight - popupInsets.top - popupInsets.bottom;
            if (ltr) {
                dx = -(popupWidth - anchorWidth);
            }
        }
        if (popupPlacementStrategy == RadianceThemingSlices.PopupPlacementStrategy.Downward.HALIGN_START && !ltr) {
            dx = anchorWidth - popupWidth;
        }
        if (popupPlacementStrategy == RadianceThemingSlices.PopupPlacementStrategy.Downward.HALIGN_END && ltr) {
            dx = -(popupWidth - anchorWidth);
        }
        if (popupPlacementStrategy == RadianceThemingSlices.PopupPlacementStrategy.CenteredVertically.HALIGN_START) {
            dy = -popupHeight / 2 - anchorHeight / 2 - popupInsets.top / 2 - popupInsets.bottom / 2;
            if (!ltr) {
                dx = anchorWidth - popupWidth;
            }
        }
        if (popupPlacementStrategy == RadianceThemingSlices.PopupPlacementStrategy.CenteredVertically.HALIGN_END) {
            dy = -popupHeight / 2 - anchorHeight / 2 - popupInsets.top / 2 - popupInsets.bottom / 2;
            if (ltr) {
                dx = -(popupWidth - anchorWidth);
            }
        }
        if (popupPlacementStrategy == RadianceThemingSlices.PopupPlacementStrategy.Startward.VALIGN_TOP) {
            dx = ltr ? -popupWidth - popupInsets.left - popupInsets.right : popupWidth + popupInsets.left + popupInsets.right;
            dy = -anchorHeight;
        }
        if (popupPlacementStrategy == RadianceThemingSlices.PopupPlacementStrategy.Startward.VALIGN_BOTTOM) {
            dx = ltr ? -popupWidth - popupInsets.left - popupInsets.right : popupWidth + popupInsets.left + popupInsets.right;
            dy = -popupHeight - popupInsets.bottom;
        }
        if (popupPlacementStrategy == RadianceThemingSlices.PopupPlacementStrategy.Endward.VALIGN_TOP) {
            dx = ltr ? anchorWidth : -popupWidth - popupInsets.left - popupInsets.right;
            dy = -anchorHeight;
        }
        if (popupPlacementStrategy == RadianceThemingSlices.PopupPlacementStrategy.Endward.VALIGN_BOTTOM) {
            dx = ltr ? anchorWidth : -popupWidth - popupInsets.left - popupInsets.right;
            dy = -popupHeight - popupInsets.bottom;
        }
        return new Dimension(dx, dy);
    }

    public static double getColorizationFactor(Component c) {
        Component invoker;
        JPopupMenu popupMenu = null;
        while (c != null) {
            JComponent jcomp;
            Object compProp;
            if (c instanceof JComponent && (compProp = (jcomp = (JComponent)c).getClientProperty("radiance.theming.internal.colorizationFactor")) instanceof Double) {
                return (Double)compProp;
            }
            if (c instanceof JPopupMenu) {
                popupMenu = (JPopupMenu)c;
            }
            c = c.getParent();
        }
        if (popupMenu != null && popupMenu != (invoker = popupMenu.getInvoker())) {
            return RadianceCoreUtilities.getColorizationFactor(popupMenu.getInvoker());
        }
        Object globalProp = UIManager.get("radiance.theming.internal.colorizationFactor");
        if (globalProp instanceof Double) {
            return (Double)globalProp;
        }
        return 0.5;
    }

    public static RadianceSkin getSkin(Component c) {
        Object skinProp;
        Container frame;
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return null;
        }
        if (!RadianceRootPaneUI.hasCustomSkinOnAtLeastOneRootPane()) {
            return RadianceThemingCortex.GlobalScope.getCurrentSkin();
        }
        RadianceComboPopup comboPopup = (RadianceComboPopup)SwingUtilities.getAncestorOfClass(RadianceComboPopup.class, c);
        if (comboPopup != null) {
            return RadianceCoreUtilities.getSkin(comboPopup.getCombobox());
        }
        JRootPane rootPane = SwingUtilities.getRootPane(c);
        if (c instanceof RadianceInternalFrameTitlePane && (frame = c.getParent()) instanceof JInternalFrame) {
            rootPane = ((JInternalFrame)frame).getRootPane();
        }
        if (c != null && c.getParent() instanceof RadianceInternalFrameTitlePane && (frame = c.getParent().getParent()) instanceof JInternalFrame) {
            rootPane = ((JInternalFrame)frame).getRootPane();
        }
        if (rootPane != null && (skinProp = rootPane.getClientProperty("radiance.theming.internal.rootPaneSkin")) instanceof RadianceSkin) {
            return (RadianceSkin)skinProp;
        }
        return RadianceThemingCortex.GlobalScope.getCurrentSkin();
    }

    public static HashMapKey getHashKey(Object ... objects) {
        return new HashMapKey(objects);
    }

    public static void stopThreads() {
        TrackableThread.requestStopAllThreads();
    }

    public static void testComponentCreationThreadingViolation(Component comp) {
        if (!SwingUtilities.isEventDispatchThread()) {
            UiThreadingViolationException uiThreadingViolationError = new UiThreadingViolationException("Component creation must be done on Event Dispatch Thread");
            uiThreadingViolationError.printStackTrace(System.err);
            throw uiThreadingViolationError;
        }
    }

    public static void testComponentStateChangeThreadingViolation(Component comp) {
        if (!SwingUtilities.isEventDispatchThread()) {
            UiThreadingViolationException uiThreadingViolationError = new UiThreadingViolationException("Component state change must be done on Event Dispatch Thread");
            uiThreadingViolationError.printStackTrace(System.err);
            throw uiThreadingViolationError;
        }
    }

    public static void testWindowCloseThreadingViolation(Window w) {
        if (!SwingUtilities.isEventDispatchThread()) {
            UiThreadingViolationException uiThreadingViolationError = new UiThreadingViolationException("Window close must be done on Event Dispatch Thread");
            uiThreadingViolationError.printStackTrace(System.err);
            throw uiThreadingViolationError;
        }
    }

    public static void traceRadianceApiUsage(Component comp, String message) {
        Window w = SwingUtilities.getWindowAncestor(comp);
        String wTitle = null;
        if (w instanceof Frame) {
            wTitle = ((Frame)w).getTitle();
        }
        if (w instanceof Dialog) {
            wTitle = ((Dialog)w).getTitle();
        }
        String wClassName = w != null ? w.getClass().getName() : null;
        throw new IllegalArgumentException(message + " [component " + comp.getClass().getSimpleName() + " in window " + wClassName + ":'" + wTitle + "' under " + UIManager.getLookAndFeel().getName() + "]");
    }

    public static BufferedImage getScaledIconImage(double scale, List<Image> imageList, int width, int height) {
        if (width == 0 || height == 0) {
            return null;
        }
        Image bestImage = null;
        int bestWidth = 0;
        int bestHeight = 0;
        double bestSimilarity = 3.0;
        for (Image im : imageList) {
            int ih;
            int iw;
            if (im == null) continue;
            try {
                iw = im.getWidth(null);
                ih = im.getHeight(null);
            }
            catch (Exception e) {
                continue;
            }
            if (iw <= 0 || ih <= 0) continue;
            double scaleFactor = Math.min((double)width / (double)iw, (double)height / (double)ih);
            int adjw = 0;
            int adjh = 0;
            double scaleMeasure = 1.0;
            if (scaleFactor >= 2.0) {
                scaleFactor = Math.floor(scaleFactor);
                adjw = iw * (int)scaleFactor;
                adjh = ih * (int)scaleFactor;
                scaleMeasure = 1.0 - 0.5 / scaleFactor;
            } else if (scaleFactor >= 1.0) {
                scaleFactor = 1.0;
                adjw = iw;
                adjh = ih;
                scaleMeasure = 0.0;
            } else if (scaleFactor >= 0.75) {
                scaleFactor = 0.75;
                adjw = iw * 3 / 4;
                adjh = ih * 3 / 4;
                scaleMeasure = 0.3;
            } else if (scaleFactor >= 0.6666) {
                scaleFactor = 0.6666;
                adjw = iw * 2 / 3;
                adjh = ih * 2 / 3;
                scaleMeasure = 0.33;
            } else {
                double scaleDivider = Math.ceil(1.0 / scaleFactor);
                scaleFactor = 1.0 / scaleDivider;
                adjw = (int)Math.round((double)iw / scaleDivider);
                adjh = (int)Math.round((double)ih / scaleDivider);
                scaleMeasure = 1.0 - 1.0 / scaleDivider;
            }
            double similarity = ((double)width - (double)adjw) / (double)width + ((double)height - (double)adjh) / (double)height + scaleMeasure;
            if (similarity < bestSimilarity) {
                bestSimilarity = similarity;
                bestImage = im;
                bestWidth = adjw;
                bestHeight = adjh;
            }
            if (similarity != 0.0) continue;
            break;
        }
        if (bestImage == null) {
            return null;
        }
        BufferedImage bimage = RadianceCoreUtilities.getBlankImage(scale, width, height);
        Graphics2D g = bimage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        int x = (width - bestWidth) / 2;
        int y = (height - bestHeight) / 2;
        g.drawImage(bestImage, x, y, bestWidth, bestHeight, null);
        g.dispose();
        return bimage;
    }

    public static boolean canReplaceChildBackgroundColor(Color background) {
        return background instanceof UIResource || background instanceof RadianceColorResource;
    }

    public static JTextComponent getTextComponentForTransitions(Component c) {
        if (!(c instanceof JComponent)) {
            return null;
        }
        JComponent jc = (JComponent)c;
        TextComponentAware tcaui = (TextComponentAware)jc.getClientProperty(TEXT_COMPONENT_AWARE);
        if (tcaui != null) {
            return tcaui.getTextComponent(jc);
        }
        if (c instanceof JTextComponent) {
            return (JTextComponent)c;
        }
        return null;
    }

    public static SwingRepaintCallback getTextComponentRepaintCallback(JTextComponent textComponent) {
        for (Container c = textComponent; c != null; c = c.getParent()) {
            TextComponentAware tcaui;
            if (!(c instanceof JComponent) || (tcaui = (TextComponentAware)((JComponent)c).getClientProperty(TEXT_COMPONENT_AWARE)) == null) continue;
            return new SwingRepaintCallback((Component)c);
        }
        return new SwingRepaintCallback((Component)textComponent);
    }

    public static boolean isOpaque(JComponent c) {
        return c.isOpaque();
    }

    public static boolean isCurrentLookAndFeel() {
        return RadianceThemingCortex.GlobalScope.getCurrentSkin() != null;
    }

    public static int getButtonBarGravity(Container c) {
        boolean isLeftToRight = c.getComponentOrientation().isLeftToRight();
        RadianceThemingSlices.HorizontalGravity buttonBarGravity = RadianceThemingCortex.GlobalScope.getButtonBarGravity();
        switch (buttonBarGravity) {
            case PLATFORM: {
                return LookUtils.IS_OS_MAC ? (isLeftToRight ? 4 : 2) : 0;
            }
            case LEADING: {
                return isLeftToRight ? 2 : 4;
            }
            case CENTERED: 
            case SWING_DEFAULT: {
                return 0;
            }
            case TRAILING: {
                return isLeftToRight ? 4 : 2;
            }
        }
        throw new IllegalStateException("Unknown button alignment " + buttonBarGravity);
    }

    public static JComponent getTitlePaneComponent(Window window) {
        JRootPane rootPane = SwingUtilities.getRootPane(window);
        if (rootPane != null) {
            RadianceRootPaneUI ui = (RadianceRootPaneUI)rootPane.getUI();
            return ui.getTitlePane();
        }
        return null;
    }

    public static void updateActiveUi() {
        for (Window window : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(window);
        }
        for (MenuElement menuElement : MenuSelectionManager.defaultManager().getSelectedPath()) {
            if (!(menuElement instanceof JPopupMenu)) continue;
            SwingUtilities.updateComponentTreeUI((JPopupMenu)menuElement);
        }
    }

    public static Point getOffsetInRootPaneCoords(Component comp) {
        JLayeredPane layeredPane;
        if (comp == null) {
            throw new IllegalArgumentException("Cannot pass null component");
        }
        JRootPane rootPane = SwingUtilities.getRootPane(comp);
        int dx = 0;
        int dy = 0;
        if (rootPane != null && (layeredPane = rootPane.getLayeredPane()) != null) {
            Insets layeredPaneInsets = layeredPane.getInsets();
            if (comp.isShowing() && layeredPane.isShowing()) {
                dx += comp.getLocationOnScreen().x - layeredPane.getLocationOnScreen().x + layeredPaneInsets.left;
                dy += comp.getLocationOnScreen().y - layeredPane.getLocationOnScreen().y + layeredPaneInsets.top;
            } else {
                Component c;
                dx = 0;
                dy = 0;
                for (c = comp; c != rootPane; c = c.getParent()) {
                    dx += c.getX();
                    dy += c.getY();
                }
                c = layeredPane;
                if (c != null && c.getParent() != null) {
                    while (c != rootPane) {
                        dx -= c.getX();
                        dy -= c.getY();
                        c = c.getParent();
                    }
                }
                dx += layeredPaneInsets.left;
                dy += layeredPaneInsets.right;
            }
        }
        return new Point(dx, dy);
    }

    public static Component getTopMostParentWithDecorationAreaType(Component comp, RadianceThemingSlices.DecorationAreaType type) {
        Component c;
        if (comp == null) {
            throw new IllegalArgumentException("Component scope APIs do not accept null components");
        }
        Component topMostWithSameDecorationAreaType = c = comp;
        while (c != null) {
            if (DecorationPainterUtils.getImmediateDecorationType(c) == type) {
                topMostWithSameDecorationAreaType = c;
            }
            c = c.getParent();
        }
        return topMostWithSameDecorationAreaType;
    }

    public static synchronized void registerAWTEventListener(AWTEventListener awtEventListener) {
        if (awtEventListeners.contains(awtEventListener)) {
            return;
        }
        awtEventListeners.add(awtEventListener);
    }

    public static synchronized void unregisterAWTEventListener(AWTEventListener awtEventListener) {
        awtEventListeners.remove(awtEventListener);
    }

    public static synchronized List<AWTEventListener> getAwtEventListeners() {
        return awtEventListeners;
    }

    public static Color getBackgroundFill(RadianceSkin skin, RadianceThemingSlices.DecorationAreaType decorationAreaType) {
        Color overlay = skin.getOverlayColor(RadianceThemingSlices.ColorOverlayType.BACKGROUND_FILL, decorationAreaType, ComponentState.ENABLED);
        if (overlay != null) {
            return overlay;
        }
        return skin.getBackgroundColorScheme(decorationAreaType).getBackgroundFillColor();
    }

    public static Color getTextBackgroundFill(Component component, ComponentState componentState) {
        RadianceThemingSlices.DecorationAreaType decorationAreaType;
        RadianceSkin skin = RadianceCoreUtilities.getSkin(component);
        Color overlay = skin.getOverlayColor(RadianceThemingSlices.ColorOverlayType.TEXT_BACKGROUND_FILL, decorationAreaType = DecorationPainterUtils.getDecorationType(component), componentState);
        if (overlay != null) {
            return overlay;
        }
        return RadianceColorSchemeUtilities.getColorScheme(component, componentState).getTextBackgroundFillColor();
    }

    public static Color getTextSelectionBackground(Component component, ComponentState componentState) {
        RadianceThemingSlices.DecorationAreaType decorationAreaType;
        RadianceSkin skin = RadianceCoreUtilities.getSkin(component);
        Color overlay = skin.getOverlayColor(RadianceThemingSlices.ColorOverlayType.SELECTION_BACKGROUND_FILL, decorationAreaType = DecorationPainterUtils.getDecorationType(component), componentState);
        if (overlay != null) {
            return overlay;
        }
        return RadianceColorSchemeUtilities.getColorScheme(component, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT_TEXT, componentState).getSelectionBackgroundColor();
    }

    public static Color getTextSelectionForeground(Component component, ComponentState componentState) {
        RadianceThemingSlices.DecorationAreaType decorationAreaType;
        RadianceSkin skin = RadianceCoreUtilities.getSkin(component);
        Color overlay = skin.getOverlayColor(RadianceThemingSlices.ColorOverlayType.SELECTION_FOREGROUND, decorationAreaType = DecorationPainterUtils.getDecorationType(component), componentState);
        if (overlay != null) {
            return overlay;
        }
        return RadianceColorSchemeUtilities.getColorScheme(component, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT_TEXT, componentState).getSelectionForegroundColor();
    }

    public static interface TextComponentAware<T extends JComponent> {
        public JTextComponent getTextComponent(T var1);
    }
}

