/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicViewportUI;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

public class RadianceViewportUI
extends BasicViewportUI {
    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadianceViewportUI();
    }

    protected RadianceViewportUI() {
    }

    @Override
    protected void installDefaults(JComponent c) {
        Color backgroundFillColor;
        super.installDefaults(c);
        Color backgr = c.getBackground();
        if ((backgr == null || backgr instanceof UIResource) && (backgroundFillColor = RadianceColorUtilities.getBackgroundFillColor(c)) != null) {
            c.setBackground(new ColorUIResource(backgroundFillColor));
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        if (this.toPaintBackground(c)) {
            BackgroundPaintingUtils.update(g, c, false);
        }
        super.paint(g, c);
    }

    private boolean toPaintBackground(JComponent c) {
        return RadianceCoreUtilities.isOpaque(c);
    }
}

