/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;
import org.pushingpixels.radiance.theming.internal.utils.menu.MenuUtilities;
import org.pushingpixels.radiance.theming.internal.utils.menu.RadianceMenuBackgroundDelegate;

public class RadianceSeparatorUI
extends BasicSeparatorUI {
    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadianceSeparatorUI();
    }

    protected RadianceSeparatorUI() {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int width;
        int startX;
        int fadeLength;
        JSeparator separator = (JSeparator)c;
        Container parent = separator.getParent();
        if (!(parent instanceof JPopupMenu)) {
            SeparatorPainterUtils.paintSeparator(separator, g, separator.getWidth(), separator.getHeight(), separator.getOrientation());
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        int xOffset = MenuUtilities.getTextOffset(c, parent);
        RadianceMenuBackgroundDelegate.paintBackground(graphics, c, xOffset);
        Dimension s = c.getSize();
        int n = fadeLength = RadianceCoreUtilities.getSeparatorAppearance(separator) == RadianceThemingSlices.SeparatorAppearance.SOFT ? 2 : 0;
        if (parent.getComponentOrientation().isLeftToRight()) {
            startX = xOffset - fadeLength;
            width = s.width - startX;
        } else {
            startX = 0;
            width = xOffset - 2 * fadeLength;
        }
        graphics.translate(startX, 0);
        graphics.setComposite(WidgetUtilities.getAlphaComposite(parent));
        SeparatorPainterUtils.paintSeparator(separator, graphics, width, s.height, separator.getOrientation(), true, fadeLength);
        graphics.dispose();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        float borderStrokeWidth = RadianceSizeUtils.getBorderStrokeWidth(c);
        int prefSize = (int)Math.ceil(2.0 * (double)borderStrokeWidth);
        if (((JSeparator)c).getOrientation() == 1) {
            return new Dimension(prefSize, 0);
        }
        return new Dimension(0, prefSize);
    }
}

