/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.text.View;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.blade.BladeColorScheme;
import org.pushingpixels.radiance.theming.internal.blade.BladeIconUtils;
import org.pushingpixels.radiance.theming.internal.blade.BladeUtils;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceMetricsUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTextUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RolloverButtonListener;

public class RadianceRadioButtonUI
extends BasicRadioButtonUI
implements TransitionAwareUI {
    private PropertyChangeListener radiancePropertyListener;
    JToggleButton button;
    StateTransitionTracker stateTransitionTracker;
    private Rectangle viewRect = new Rectangle();
    private Rectangle iconRect = new Rectangle();
    private Rectangle textRect = new Rectangle();
    protected Icon radianceIcon;
    protected BladeColorScheme mutableFillColorScheme = new BladeColorScheme();
    protected BladeColorScheme mutableBorderColorScheme = new BladeColorScheme();
    protected BladeColorScheme mutableMarkColorScheme = new BladeColorScheme();

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
        this.radiancePropertyListener = propertyChangeEvent -> {
            if ("model".equals(propertyChangeEvent.getPropertyName())) {
                this.stateTransitionTracker.setModel((ButtonModel)propertyChangeEvent.getNewValue());
            }
            if ("font".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(b::updateUI);
            }
        };
        b.addPropertyChangeListener(this.radiancePropertyListener);
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        Border border = b.getBorder();
        if (border == null || border instanceof UIResource) {
            b.setBorder(RadianceSizeUtils.getRadioButtonBorder(RadianceSizeUtils.getComponentFontSize(b), b.getComponentOrientation().isLeftToRight()));
        }
        this.button.setRolloverEnabled(true);
        LookAndFeel.installProperty(b, "iconTextGap", RadianceSizeUtils.getTextIconGap(RadianceSizeUtils.getComponentFontSize(b)));
        this.updateIcon();
    }

    protected void updateIcon() {
        int fontSize = RadianceSizeUtils.getComponentFontSize(this.button);
        final int checkMarkSize = RadianceSizeUtils.getRadioButtonMarkSize(fontSize);
        this.radianceIcon = new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                StateTransitionTracker.ModelStateInfo modelStateInfo = RadianceRadioButtonUI.this.stateTransitionTracker.getModelStateInfo();
                RadianceFillPainter fillPainter = RadianceCoreUtilities.getFillPainter(RadianceRadioButtonUI.this.button);
                RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(RadianceRadioButtonUI.this.button);
                ComponentState currState = modelStateInfo.getCurrModelState();
                float visibility = RadianceRadioButtonUI.this.stateTransitionTracker.getFacetStrength(RadianceThemingSlices.ComponentStateFacet.SELECTION);
                float alpha = RadianceColorSchemeUtilities.getAlpha(RadianceRadioButtonUI.this.button, currState);
                BladeUtils.populateColorScheme(RadianceRadioButtonUI.this.mutableFillColorScheme, RadianceRadioButtonUI.this.button, modelStateInfo, currState, RadianceThemingSlices.ColorSchemeAssociationKind.MARK_BOX, false);
                BladeUtils.populateColorScheme(RadianceRadioButtonUI.this.mutableBorderColorScheme, RadianceRadioButtonUI.this.button, modelStateInfo, currState, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, false);
                BladeUtils.populateColorScheme(RadianceRadioButtonUI.this.mutableMarkColorScheme, RadianceRadioButtonUI.this.button, modelStateInfo, currState, RadianceThemingSlices.ColorSchemeAssociationKind.MARK, false);
                Graphics2D graphics = (Graphics2D)g.create();
                graphics.translate(x, y);
                BladeIconUtils.drawRadioButton(graphics, RadianceRadioButtonUI.this.button, fillPainter, borderPainter, checkMarkSize, currState, RadianceRadioButtonUI.this.mutableFillColorScheme, RadianceRadioButtonUI.this.mutableMarkColorScheme, RadianceRadioButtonUI.this.mutableBorderColorScheme, visibility, alpha);
                graphics.dispose();
            }

            @Override
            public int getIconWidth() {
                return checkMarkSize;
            }

            @Override
            public int getIconHeight() {
                return checkMarkSize;
            }
        };
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        b.removePropertyChangeListener(this.radiancePropertyListener);
        this.radiancePropertyListener = null;
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
        super.uninstallListeners(b);
    }

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadianceRadioButtonUI((JToggleButton)comp);
    }

    RadianceRadioButtonUI(JToggleButton button) {
        this.button = button;
        button.setRolloverEnabled(true);
        this.stateTransitionTracker = new StateTransitionTracker((JComponent)this.button, this.button.getModel());
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new RolloverButtonListener(b, this.stateTransitionTracker);
    }

    @Override
    public Icon getDefaultIcon() {
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return null;
        }
        return this.radianceIcon;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        if (RadianceCoreUtilities.isOpaque(c)) {
            BackgroundPaintingUtils.update(g, c, false);
        }
        Insets i = b.getInsets();
        this.viewRect.x = i.left;
        this.viewRect.y = i.top;
        this.viewRect.width = b.getWidth() - (i.right + this.viewRect.x);
        this.viewRect.height = b.getHeight() - (i.bottom + this.viewRect.y);
        this.textRect.height = 0;
        this.textRect.width = 0;
        this.textRect.y = 0;
        this.textRect.x = 0;
        this.iconRect.height = 0;
        this.iconRect.width = 0;
        this.iconRect.y = 0;
        this.iconRect.x = 0;
        Font f = b.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        Icon icon = RadianceCoreUtilities.getOriginalIcon(b, this.getDefaultIcon());
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, b.getText() == null ? 0 : b.getIconTextGap());
        Graphics2D g2d = (Graphics2D)g.create();
        if (text != null && !text.equals("")) {
            View v = (View)b.getClientProperty("html");
            if (v != null) {
                v.paint(g2d, this.textRect);
            } else {
                this.paintButtonText(g2d, b, this.textRect, text);
            }
        }
        if (icon != null) {
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            icon.paintIcon(c, g2d, this.iconRect.x, this.iconRect.y);
        }
        if (b.isFocusPainted()) {
            float focusRingPadding = RadianceSizeUtils.getFocusRingPadding(this.button, RadianceSizeUtils.getComponentFontSize(this.button)) / 2.0f;
            Graphics2D graphicsFocus = (Graphics2D)g2d.create();
            graphicsFocus.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            RadianceCommonCortex.paintAtScale1x((Graphics2D)graphicsFocus, (int)0, (int)0, (int)this.button.getWidth(), (int)this.button.getHeight(), (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> RadianceCoreUtilities.paintFocus(graphics1X, this.button, this.button, this, scaleFactor, null, this.textRect, 1.0f, (float)scaleFactor * focusRingPadding));
            graphicsFocus.dispose();
        }
        g2d.dispose();
    }

    private void paintButtonText(Graphics g, AbstractButton button, Rectangle textRect, String text) {
        RadianceTextUtilities.paintText(g, button, textRect, text, button.getDisplayedMnemonicIndex());
    }

    @Override
    public boolean isInside(MouseEvent me) {
        return true;
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        JRadioButton radioButton = (JRadioButton)c;
        return RadianceMetricsUtilities.getPreferredCheckButtonSize(radioButton, ((RadianceRadioButtonUI)radioButton.getUI()).getDefaultIcon());
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        RadianceCommonCortex.installDesktopHints((Graphics2D)g2d, (Font)c.getFont());
        super.update(g2d, c);
        g2d.dispose();
    }
}

