/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.menu.MenuUtilities;

public class RadiancePopupMenuUI
extends BasicPopupMenuUI {
    private ContainerListener radianceContainerListener;
    private PopupMenuListener radiancePopupMenuListener;

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadiancePopupMenuUI();
    }

    protected RadiancePopupMenuUI() {
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.radianceContainerListener = new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                MenuUtilities.cleanPopupLayoutMetrics(RadiancePopupMenuUI.this.popupMenu);
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                MenuUtilities.cleanPopupLayoutMetrics(RadiancePopupMenuUI.this.popupMenu);
            }
        };
        this.popupMenu.addContainerListener(this.radianceContainerListener);
        this.radiancePopupMenuListener = new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                for (int i = 0; i < RadiancePopupMenuUI.this.popupMenu.getComponentCount(); ++i) {
                    JMenuItem menuItem;
                    Component comp = RadiancePopupMenuUI.this.popupMenu.getComponent(i);
                    if (!(comp instanceof JMenuItem) || !(menuItem = (JMenuItem)comp).isEnabled() || !menuItem.getModel().isArmed()) continue;
                    menuItem.getModel().setArmed(false);
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                for (int i = 0; i < RadiancePopupMenuUI.this.popupMenu.getComponentCount(); ++i) {
                    JMenuItem menuItem;
                    Component comp = RadiancePopupMenuUI.this.popupMenu.getComponent(i);
                    if (!(comp instanceof JMenuItem) || !(menuItem = (JMenuItem)comp).isEnabled() || !menuItem.getModel().isArmed()) continue;
                    menuItem.getModel().setArmed(false);
                }
            }
        };
        this.popupMenu.addPopupMenuListener(this.radiancePopupMenuListener);
    }

    @Override
    protected void uninstallListeners() {
        this.popupMenu.removeContainerListener(this.radianceContainerListener);
        this.radianceContainerListener = null;
        this.popupMenu.removePopupMenuListener(this.radiancePopupMenuListener);
        this.radiancePopupMenuListener = null;
        super.uninstallListeners();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        BackgroundPaintingUtils.update(g, c, false);
    }
}

