/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingWidget;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.text.RadiancePasswordField;
import org.pushingpixels.radiance.theming.internal.RadianceThemingWidgetRepository;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTextUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RolloverTextControlListener;
import org.pushingpixels.radiance.theming.internal.utils.border.RadianceTextComponentBorder;

public class RadiancePasswordFieldUI
extends BasicPasswordFieldUI
implements TransitionAwareUI {
    private StateTransitionTracker stateTransitionTracker;
    private JPasswordField passwordField;
    private PropertyChangeListener radiancePropertyChangeListener;
    private RolloverTextControlListener radianceRolloverListener;
    private ButtonModel transitionModel;
    private Set<RadianceThemingWidget<JComponent>> themingWidgets;

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadiancePasswordFieldUI(comp);
    }

    protected RadiancePasswordFieldUI(JComponent c) {
        this.passwordField = (JPasswordField)c;
        this.transitionModel = new DefaultButtonModel();
        this.transitionModel.setArmed(false);
        this.transitionModel.setSelected(false);
        this.transitionModel.setPressed(false);
        this.transitionModel.setRollover(false);
        this.transitionModel.setEnabled(this.passwordField.isEnabled());
        this.stateTransitionTracker = new StateTransitionTracker((JComponent)this.passwordField, this.transitionModel);
    }

    @Override
    public void installUI(JComponent c) {
        this.themingWidgets = RadianceThemingWidgetRepository.getRepository().getMatchingWidgets(c);
        super.installUI(c);
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installUI();
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallUI();
        }
        super.uninstallUI(c);
    }

    @Override
    public View create(Element elem) {
        return new RadiancePasswordView(this.passwordField, elem);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.radianceRolloverListener = new RolloverTextControlListener(this.passwordField, this, this.transitionModel);
        this.radianceRolloverListener.registerListeners();
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
        this.radiancePropertyChangeListener = propertyChangeEvent -> {
            if ("font".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    int caretPos = this.passwordField.getCaretPosition();
                    this.passwordField.updateUI();
                    this.passwordField.setCaretPosition(caretPos);
                    Container parent = this.passwordField.getParent();
                    if (parent != null) {
                        parent.invalidate();
                        parent.validate();
                    }
                });
            }
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                this.transitionModel.setEnabled(this.passwordField.isEnabled());
            }
        };
        this.passwordField.addPropertyChangeListener(this.radiancePropertyChangeListener);
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installListeners();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
        this.passwordField.removePropertyChangeListener(this.radiancePropertyChangeListener);
        this.radiancePropertyChangeListener = null;
        this.passwordField.removeMouseListener(this.radianceRolloverListener);
        this.passwordField.removeMouseMotionListener(this.radianceRolloverListener);
        this.radianceRolloverListener = null;
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallListeners();
        }
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        Border b = this.passwordField.getBorder();
        if (b == null || b instanceof UIResource) {
            BorderUIResource.CompoundBorderUIResource newB = new BorderUIResource.CompoundBorderUIResource(new RadianceTextComponentBorder(RadianceSizeUtils.getTextBorderInsets(RadianceSizeUtils.getComponentFontSize(this.passwordField))), new BasicBorders.MarginBorder());
            this.passwordField.setBorder(newB);
        }
        SwingUtilities.invokeLater(() -> {
            if (this.passwordField == null) {
                return;
            }
            Color foregr = this.passwordField.getForeground();
            if (foregr == null || foregr instanceof UIResource) {
                this.passwordField.setForeground(RadianceColorUtilities.getForegroundColor(RadianceThemingCortex.ComponentScope.getCurrentSkin(this.passwordField).getEnabledColorScheme(RadianceThemingCortex.ComponentOrParentChainScope.getDecorationType(this.passwordField))));
            }
        });
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallDefaults() {
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallDefaults();
        }
        super.uninstallDefaults();
    }

    @Override
    protected void paintBackground(Graphics g) {
        RadianceTextUtilities.paintTextCompBackground(g, this.passwordField);
    }

    @Override
    public boolean isInside(MouseEvent me) {
        return true;
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        RadianceCommonCortex.installDesktopHints((Graphics2D)g2d, (Font)c.getFont());
        super.update(g2d, c);
        g2d.dispose();
    }

    private static class RadiancePasswordView
    extends FieldView {
        private JPasswordField field;

        private RadiancePasswordView(JPasswordField field, Element element) {
            super(element);
            this.field = field;
        }

        private float drawEchoCharacter(Graphics g, float x, float y, boolean isSelected) {
            Container container = this.getContainer();
            Graphics2D graphics = (Graphics2D)g;
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            JPasswordField field = (JPasswordField)container;
            int fontSize = RadianceSizeUtils.getComponentFontSize(this.field);
            int dotDiameter = RadianceSizeUtils.getPasswordDotDiameter(fontSize);
            int dotGap = RadianceSizeUtils.getPasswordDotGap(fontSize);
            if (field instanceof RadiancePasswordField) {
                graphics.setColor(field.getSelectedTextColor());
            } else {
                ComponentState state = field.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
                RadianceColorScheme scheme = RadianceColorSchemeUtilities.getColorScheme(field, state);
                Color color = isSelected ? scheme.getSelectionForegroundColor() : RadianceColorUtilities.getForegroundColor(scheme);
                graphics.setColor(color);
            }
            int echoPerChar = RadianceCoreUtilities.getEchoPerChar(field);
            for (int i = 0; i < echoPerChar; ++i) {
                graphics.fillOval((int)(x + (float)(dotGap / 2)), (int)(y - (float)dotDiameter), dotDiameter, dotDiameter);
                x += (float)(dotDiameter + dotGap);
            }
            return x;
        }

        private int getEchoCharAdvance() {
            int fontSize = RadianceSizeUtils.getComponentFontSize(this.field);
            int dotDiameter = RadianceSizeUtils.getPasswordDotDiameter(fontSize);
            int dotGap = RadianceSizeUtils.getPasswordDotGap(fontSize);
            int echoPerChar = RadianceCoreUtilities.getEchoPerChar(this.field);
            return echoPerChar * (dotDiameter + dotGap);
        }

        @Override
        protected float drawSelectedText(Graphics2D g, float x, float y, int p0, int p1) throws BadLocationException {
            Container c = this.getContainer();
            if (c instanceof JPasswordField) {
                JPasswordField f = (JPasswordField)c;
                if (!f.echoCharIsSet()) {
                    return super.drawSelectedText(g, x, y, p0, p1);
                }
                int n = p1 - p0;
                char echoChar = f.getEchoChar();
                float currPos = x;
                for (int i = 0; i < n; ++i) {
                    currPos = this.drawEchoCharacter(g, currPos, y, true);
                }
                return x + (float)(n * this.getEchoCharAdvance());
            }
            return x;
        }

        @Override
        protected float drawUnselectedText(Graphics2D g, float x, float y, int p0, int p1) throws BadLocationException {
            Container c = this.getContainer();
            if (c instanceof JPasswordField) {
                JPasswordField f = (JPasswordField)c;
                if (!f.echoCharIsSet()) {
                    return super.drawUnselectedText(g, x, y, p0, p1);
                }
                int n = p1 - p0;
                char echoChar = f.getEchoChar();
                float currPos = x;
                for (int i = 0; i < n; ++i) {
                    currPos = this.drawEchoCharacter(g, currPos, y, false);
                }
                return x + (float)(n * this.getEchoCharAdvance());
            }
            return x;
        }

        @Override
        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            Container c = this.getContainer();
            if (c instanceof JPasswordField) {
                JPasswordField f = (JPasswordField)c;
                if (!f.echoCharIsSet()) {
                    return super.modelToView(pos, a, b);
                }
                Rectangle alloc = this.adjustAllocation(a).getBounds();
                int echoPerChar = RadianceCoreUtilities.getEchoPerChar(f);
                int fontSize = RadianceSizeUtils.getComponentFontSize(this.field);
                int dotWidth = RadianceSizeUtils.getPasswordDotDiameter(fontSize) + RadianceSizeUtils.getPasswordDotGap(fontSize);
                int dx = (pos - this.getStartOffset()) * echoPerChar * dotWidth;
                alloc.x += dx;
                alloc.width = 1;
                return alloc;
            }
            return null;
        }

        @Override
        public int viewToModel(float fx, float fy, Shape a, Position.Bias[] bias) {
            bias[0] = Position.Bias.Forward;
            int n = 0;
            Container c = this.getContainer();
            if (c instanceof JPasswordField) {
                int fontSize;
                int dotWidth;
                JPasswordField f = (JPasswordField)c;
                if (!f.echoCharIsSet()) {
                    return super.viewToModel(fx, fy, a, bias);
                }
                Rectangle alloc = (a = this.adjustAllocation(a)) instanceof Rectangle ? (Rectangle)a : a.getBounds();
                int echoPerChar = RadianceCoreUtilities.getEchoPerChar(f);
                n = ((int)fx - alloc.x) / (echoPerChar * (dotWidth = RadianceSizeUtils.getPasswordDotDiameter(fontSize = RadianceSizeUtils.getComponentFontSize(this.field)) + RadianceSizeUtils.getPasswordDotGap(fontSize)));
                if (n < 0) {
                    n = 0;
                } else if (n > this.getStartOffset() + this.getDocument().getLength()) {
                    n = this.getDocument().getLength() - this.getStartOffset();
                }
            }
            return this.getStartOffset() + n;
        }

        @Override
        public float getPreferredSpan(int axis) {
            switch (axis) {
                case 0: {
                    JPasswordField f;
                    Container c = this.getContainer();
                    if (!(c instanceof JPasswordField) || !(f = (JPasswordField)c).echoCharIsSet()) break;
                    int echoPerChar = RadianceCoreUtilities.getEchoPerChar(f);
                    int fontSize = RadianceSizeUtils.getComponentFontSize(this.field);
                    int dotWidth = RadianceSizeUtils.getPasswordDotDiameter(fontSize) + RadianceSizeUtils.getPasswordDotGap(fontSize);
                    return echoPerChar * dotWidth * this.getDocument().getLength();
                }
            }
            return super.getPreferredSpan(axis);
        }
    }
}

