/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.icon.MenuArrowIcon;
import org.pushingpixels.radiance.theming.internal.utils.menu.MenuUtilities;
import org.pushingpixels.radiance.theming.internal.utils.menu.RadianceMenu;
import org.pushingpixels.radiance.theming.internal.widget.animation.effects.GhostPaintingUtils;

public class RadianceMenuUI
extends BasicMenuUI
implements RadianceMenu,
TransitionAwareUI {
    private MouseListener radianceMouseListener;
    private StateTransitionTracker stateTransitionTracker;
    private MenuUtilities.MenuPropertyListener radianceMenuPropertyListener;
    private PropertyChangeListener radiancePropertyListener;
    private FocusListener radianceFocusListener;

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadianceMenuUI((JMenu)comp);
    }

    protected RadianceMenuUI(JMenu menuItem) {
        this.stateTransitionTracker = new StateTransitionTracker((JComponent)menuItem, menuItem.getModel());
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.menuItem.setRolloverEnabled(true);
        this.arrowIcon = new MenuArrowIcon((JMenu)this.menuItem);
        this.defaultTextIconGap = RadianceSizeUtils.getTextIconGap(RadianceSizeUtils.getComponentFontSize(this.menuItem));
        RadianceThemingCortex.ComponentOrParentScope.setBackgroundAppearanceStrategy(this.menuItem, RadianceThemingSlices.BackgroundAppearanceStrategy.FLAT);
        LookAndFeel.installProperty(this.menuItem, "opaque", Boolean.FALSE);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.radianceMenuPropertyListener = new MenuUtilities.MenuPropertyListener(this.menuItem);
        this.radianceMenuPropertyListener.install();
        this.stateTransitionTracker.registerModelListeners();
        this.radianceMouseListener = new MouseAdapter(){

            private boolean toRepaint() {
                MenuElement[] selectedMenuPath;
                for (MenuElement elem : selectedMenuPath = MenuSelectionManager.defaultManager().getSelectedPath()) {
                    if (elem != RadianceMenuUI.this.menuItem) continue;
                    return true;
                }
                return selectedMenuPath.length == 0;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (this.toRepaint()) {
                    RadianceMenuUI.this.stateTransitionTracker.turnOffModelChangeTracking();
                    RadianceMenuUI.this.menuItem.getModel().setRollover(true);
                    RadianceMenuUI.this.stateTransitionTracker.onModelStateChanged();
                    Rectangle bounds = RadianceMenuUI.this.menuItem.getBounds();
                    RadianceMenuUI.this.menuItem.getParent().repaint(bounds.x, bounds.y, bounds.width, bounds.height);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (this.toRepaint()) {
                    RadianceMenuUI.this.stateTransitionTracker.turnOffModelChangeTracking();
                    RadianceMenuUI.this.menuItem.getModel().setRollover(false);
                    RadianceMenuUI.this.stateTransitionTracker.onModelStateChanged();
                    Rectangle bounds = RadianceMenuUI.this.menuItem.getBounds();
                    RadianceMenuUI.this.menuItem.getParent().repaint(bounds.x, bounds.y, bounds.width, bounds.height);
                }
            }
        };
        this.menuItem.addMouseListener(this.radianceMouseListener);
        this.radianceFocusListener = new FocusAdapter(){

            private boolean toRepaint() {
                MenuElement[] selectedMenuPath;
                for (MenuElement elem : selectedMenuPath = MenuSelectionManager.defaultManager().getSelectedPath()) {
                    if (elem != RadianceMenuUI.this.menuItem) continue;
                    return true;
                }
                return selectedMenuPath.length == 0;
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (this.toRepaint()) {
                    RadianceMenuUI.this.stateTransitionTracker.turnOffModelChangeTracking();
                    RadianceMenuUI.this.menuItem.getModel().setRollover(false);
                    RadianceMenuUI.this.stateTransitionTracker.onModelStateChanged();
                    Rectangle bounds = RadianceMenuUI.this.menuItem.getBounds();
                    RadianceMenuUI.this.menuItem.getParent().repaint(bounds.x, bounds.y, bounds.width, bounds.height);
                }
            }
        };
        this.menuItem.addFocusListener(this.radianceFocusListener);
        this.radiancePropertyListener = propertyChangeEvent -> {
            if ("model".equals(propertyChangeEvent.getPropertyName())) {
                this.stateTransitionTracker.setModel((ButtonModel)propertyChangeEvent.getNewValue());
            }
            if ("font".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    if (this.menuItem != null) {
                        this.menuItem.updateUI();
                    }
                });
            }
        };
        this.menuItem.addPropertyChangeListener(this.radiancePropertyListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.radianceMenuPropertyListener.uninstall();
        this.radianceMenuPropertyListener = null;
        this.menuItem.removeMouseListener(this.radianceMouseListener);
        this.radianceMouseListener = null;
        this.menuItem.removeFocusListener(this.radianceFocusListener);
        this.radianceFocusListener = null;
        this.menuItem.removePropertyChangeListener(this.radiancePropertyListener);
        this.radiancePropertyListener = null;
        this.stateTransitionTracker.unregisterModelListeners();
    }

    @Override
    public JMenuItem getAssociatedMenuItem() {
        return this.menuItem;
    }

    @Override
    public Font getAcceleratorFont() {
        return this.acceleratorFont;
    }

    @Override
    public Icon getArrowIcon() {
        return this.arrowIcon;
    }

    @Override
    public Icon getCheckIcon() {
        return null;
    }

    @Override
    public int getDefaultTextIconGap() {
        return this.defaultTextIconGap;
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Dimension superDim = super.getPreferredMenuItemSize(c, checkIcon, arrowIcon, defaultTextIconGap);
        if (MenuUtilities.getPopupLayoutMetrics(this.menuItem, false) != null) {
            return new Dimension(MenuUtilities.getPreferredWidth(this.menuItem), superDim.height);
        }
        return superDim;
    }

    @Override
    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        MenuUtilities.paintMenuItem(g, this.menuItem, checkIcon, arrowIcon);
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    public boolean isInside(MouseEvent me) {
        return true;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        RadianceCommonCortex.installDesktopHints((Graphics2D)g2d, (Font)c.getFont());
        super.update(g2d, c);
        GhostPaintingUtils.paintGhostImages(c, g2d);
        g2d.dispose();
    }

    @Override
    public void updateCheckIconIfNeeded() {
    }
}

