/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RolloverMenuItemListener;
import org.pushingpixels.radiance.theming.internal.utils.menu.MenuUtilities;
import org.pushingpixels.radiance.theming.internal.utils.menu.RadianceMenu;

public class RadianceMenuItemUI
extends BasicMenuItemUI
implements RadianceMenu,
TransitionAwareUI {
    private StateTransitionTracker stateTransitionTracker;
    private MenuUtilities.MenuPropertyListener radianceMenuPropertyListener;
    private RolloverMenuItemListener radianceRolloverListener;
    private PropertyChangeListener radiancePropertyListener;

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadianceMenuItemUI((JMenuItem)comp);
    }

    protected RadianceMenuItemUI(JMenuItem menuItem) {
        this.stateTransitionTracker = new StateTransitionTracker((JComponent)menuItem, menuItem.getModel());
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.radianceMenuPropertyListener = new MenuUtilities.MenuPropertyListener(this.menuItem);
        this.radianceMenuPropertyListener.install();
        this.radianceRolloverListener = new RolloverMenuItemListener(this.menuItem, this.stateTransitionTracker);
        this.menuItem.addMouseListener(this.radianceRolloverListener);
        this.stateTransitionTracker.registerModelListeners();
        this.radiancePropertyListener = propertyChangeEvent -> {
            if ("model".equals(propertyChangeEvent.getPropertyName())) {
                this.stateTransitionTracker.setModel((ButtonModel)propertyChangeEvent.getNewValue());
            }
            if ("font".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    if (this.menuItem != null) {
                        this.menuItem.updateUI();
                    }
                });
            }
        };
        this.menuItem.addPropertyChangeListener(this.radiancePropertyListener);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.defaultTextIconGap = RadianceSizeUtils.getTextIconGap(RadianceSizeUtils.getComponentFontSize(this.menuItem));
    }

    @Override
    public void updateCheckIconIfNeeded() {
    }

    @Override
    protected void uninstallListeners() {
        this.radianceMenuPropertyListener.uninstall();
        this.radianceMenuPropertyListener = null;
        this.menuItem.removeMouseListener(this.radianceRolloverListener);
        this.radianceRolloverListener = null;
        this.stateTransitionTracker.unregisterModelListeners();
        this.menuItem.removePropertyChangeListener(this.radiancePropertyListener);
        this.radiancePropertyListener = null;
        super.uninstallListeners();
    }

    @Override
    public JMenuItem getAssociatedMenuItem() {
        return this.menuItem;
    }

    @Override
    public Font getAcceleratorFont() {
        return this.acceleratorFont;
    }

    @Override
    public Icon getArrowIcon() {
        return this.arrowIcon;
    }

    @Override
    public Icon getCheckIcon() {
        return null;
    }

    @Override
    public int getDefaultTextIconGap() {
        return this.defaultTextIconGap;
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Dimension superDim = super.getPreferredMenuItemSize(c, checkIcon, arrowIcon, defaultTextIconGap);
        return new Dimension(MenuUtilities.getPreferredWidth(this.menuItem), superDim.height);
    }

    @Override
    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        MenuUtilities.paintMenuItem(g, this.menuItem, checkIcon, arrowIcon);
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    public boolean isInside(MouseEvent me) {
        return this.menuItem.getBounds().contains(me.getX(), me.getY());
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        RadianceCommonCortex.installDesktopHints((Graphics2D)g2d, (Font)c.getFont());
        super.update(g2d, c);
        g2d.dispose();
    }
}

