/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.metal.MetalFileChooserUI;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.common.api.icon.RadianceIconUIResource;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.icon.RadianceIconPack;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTextUtilities;

public class RadianceFileChooserUI
extends MetalFileChooserUI {
    private final RadianceFileView fileView = new RadianceFileView();
    private static final int ICON_SIZE = 14;

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadianceFileChooserUI((JFileChooser)comp);
    }

    protected RadianceFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    @Override
    public FileView getFileView(JFileChooser fc) {
        return this.fileView;
    }

    @Override
    protected void installIcons(JFileChooser fc) {
        super.installIcons(fc);
        RadianceIconPack iconPack = RadianceThemingCortex.GlobalScope.getIconPack();
        RadianceColorScheme colorScheme = RadianceCoreUtilities.getSkin(fc).getEnabledColorScheme(RadianceThemingSlices.DecorationAreaType.NONE);
        this.directoryIcon = iconPack.getFileChooserDirectoryIcon(14, colorScheme);
        this.fileIcon = iconPack.getFileChooserFileIcon(14, colorScheme);
        this.computerIcon = iconPack.getFileChooserComputerIcon(14, colorScheme);
        this.hardDriveIcon = iconPack.getFileChooserHardDriveIcon(14, colorScheme);
        this.floppyDriveIcon = iconPack.getFileChooserFloppyDriveIcon(14, colorScheme);
        this.newFolderIcon = iconPack.getFileChooserNewFolderIcon(14, colorScheme);
        this.upFolderIcon = iconPack.getFileChooserUpFolderIcon(14, colorScheme);
        this.homeFolderIcon = iconPack.getFileChooserHomeFolderIcon(14, colorScheme);
        this.detailsViewIcon = iconPack.getFileChooserDetailsViewIcon(14, colorScheme);
        this.listViewIcon = iconPack.getFileChooserListViewIcon(14, colorScheme);
        this.viewMenuIcon = iconPack.getFileChooserViewMenuIcon(14, colorScheme);
    }

    @Override
    public void installComponents(JFileChooser fc) {
        super.installComponents(fc);
        JPanel buttonPanel = this.getButtonPanel();
        buttonPanel.setLayout(new RadianceFooterLayout(RadianceSizeUtils.getAdjustedSize(RadianceSizeUtils.getComponentFontSize(buttonPanel), 8, 4, 1, true), RadianceThemingCortex.GlobalScope.getButtonBarOrder().isDefaultButtonLeading()));
        buttonPanel.setBorder(new EmptyBorder(RadianceSizeUtils.getAdjustedSize(RadianceSizeUtils.getComponentFontSize(buttonPanel), 16, 4, 1, true), 0, 0, 0));
    }

    private static class RadianceFooterLayout
    implements LayoutManager {
        private int padding;
        private boolean isDefaultButtonLeading;

        public RadianceFooterLayout(int padding, boolean isDefaultButtonLeading) {
            this.padding = padding;
            this.isDefaultButtonLeading = isDefaultButtonLeading;
        }

        @Override
        public void addLayoutComponent(String string, Component comp) {
        }

        private Dimension getMaxButtonSize(Container container) {
            Component[] children = container.getComponents();
            Dimension result = new Dimension(0, 0);
            for (Component child : children) {
                Dimension pref = child.getPreferredSize();
                result.width = Math.max(result.width, pref.width);
                result.height = Math.max(result.height, pref.height);
            }
            return result;
        }

        @Override
        public void layoutContainer(Container container) {
            Component[] children = container.getComponents();
            if (children != null && children.length > 0) {
                int x;
                int numChildren = children.length;
                Insets insets = container.getInsets();
                Dimension maxDimension = this.getMaxButtonSize(container);
                int totalButtonWidth = maxDimension.width * numChildren + this.padding * (numChildren - 1);
                boolean isLeftToRight = container.getComponentOrientation().isLeftToRight();
                int buttonAlignment = RadianceCoreUtilities.getButtonBarGravity(container);
                switch (buttonAlignment) {
                    case 2: {
                        x = insets.left;
                        break;
                    }
                    case 0: {
                        x = (container.getWidth() - insets.left - insets.right - totalButtonWidth) / 2;
                        break;
                    }
                    default: {
                        x = container.getWidth() - insets.right - totalButtonWidth;
                    }
                }
                boolean iterateForward = isLeftToRight == this.isDefaultButtonLeading;
                for (int counter = 0; counter < numChildren; ++counter) {
                    int index = iterateForward ? counter : numChildren - counter - 1;
                    children[index].setBounds(x, insets.top, maxDimension.width, maxDimension.height);
                    x += children[index].getWidth() + this.padding;
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            if (container == null) {
                return new Dimension(0, 0);
            }
            Component[] children = container.getComponents();
            if (children == null || children.length == 0) {
                return new Dimension(0, 0);
            }
            int numChildren = children.length;
            Insets insets = container.getInsets();
            Dimension maxDimension = this.getMaxButtonSize(container);
            return new Dimension(insets.left + insets.right + maxDimension.width * numChildren + this.padding * (numChildren - 1), insets.top + insets.bottom + maxDimension.height);
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }
    }

    private class RadianceFileView
    extends BasicFileChooserUI.BasicFileView {
        private final Map<String, Icon> pathIconCache;

        private RadianceFileView() {
            super(RadianceFileChooserUI.this);
            this.pathIconCache = new HashMap<String, Icon>();
        }

        @Override
        public Icon getCachedIcon(File f) {
            return this.pathIconCache.get(f.getPath());
        }

        @Override
        public Icon getIcon(File f) {
            Icon icon = this.getCachedIcon(f);
            if (icon != null) {
                return icon;
            }
            icon = this.getDefaultIcon(f);
            if (icon == null && (icon = super.getIcon(f)) == null) {
                icon = new ImageIcon(RadianceCoreUtilities.getBlankImage(RadianceCommonCortex.getScaleFactor(null), 8, 8));
            }
            this.cacheIcon(f, icon);
            return icon;
        }

        @Override
        public void cacheIcon(File f, Icon icon) {
            this.pathIconCache.put(f.getPath(), icon);
        }

        @Override
        public void clearIconCache() {
            this.pathIconCache.clear();
        }

        public Icon getDefaultIcon(File f) {
            JFileChooser fileChooser = RadianceFileChooserUI.this.getFileChooser();
            Icon icon = fileChooser.getFileSystemView().getSystemIcon(f);
            if (icon instanceof RadianceIconUIResource) {
                RadianceIconPack iconPack = RadianceThemingCortex.GlobalScope.getIconPack();
                RadianceColorScheme colorScheme = RadianceCoreUtilities.getSkin(fileChooser).getEnabledColorScheme(RadianceThemingSlices.DecorationAreaType.NONE);
                icon = f.isDirectory() ? iconPack.getFileChooserDirectoryIcon(14, colorScheme) : iconPack.getFileChooserFileIcon(14, colorScheme);
            }
            float labelAlpha = RadianceColorSchemeUtilities.getAlpha(fileChooser, ComponentState.ENABLED);
            Color textColor = RadianceTextUtilities.getForegroundColor(fileChooser, ComponentState.ENABLED, labelAlpha);
            icon = RadianceCoreUtilities.getFilteredIcon(fileChooser, icon, ComponentState.ENABLED, textColor);
            return icon;
        }
    }
}

