/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDesktopIconUI;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.RadianceThemingWidget;
import org.pushingpixels.radiance.theming.internal.RadianceThemingWidgetRepository;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceInternalFrameTitlePane;

public class RadianceDesktopIconUI
extends BasicDesktopIconUI {
    private MouseInputListener radianceLabelMouseInputListener;
    private int width;
    private Set<RadianceThemingWidget<JComponent>> themingWidgets;

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadianceDesktopIconUI();
    }

    protected RadianceDesktopIconUI() {
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        Font f = this.desktopIcon.getFont();
        if (f == null || f instanceof UIResource) {
            this.desktopIcon.setFont(UIManager.getFont("DesktopIcon.font"));
        }
        this.width = UIManager.getInt("DesktopIcon.width");
        this.desktopIcon.setBackground(RadianceCoreUtilities.getBackgroundFill(RadianceCoreUtilities.getSkin(this.desktopIcon.getInternalFrame()), RadianceThemingSlices.DecorationAreaType.SECONDARY_TITLE_PANE));
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallDefaults() {
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallDefaults();
        }
        super.uninstallDefaults();
    }

    @Override
    protected void installComponents() {
        this.frame = this.desktopIcon.getInternalFrame();
        this.iconPane = new RadianceInternalFrameTitlePane(this.frame);
        this.iconPane.setOpaque(false);
        this.desktopIcon.setLayout(new BorderLayout());
        this.desktopIcon.add((Component)this.iconPane, "Center");
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installComponents();
        }
    }

    @Override
    protected void uninstallComponents() {
        ((RadianceInternalFrameTitlePane)this.iconPane).uninstall();
        this.desktopIcon.setLayout(null);
        this.desktopIcon.remove(this.iconPane);
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallComponents();
        }
        this.frame = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.radianceLabelMouseInputListener = this.createMouseInputListener();
        this.iconPane.addMouseMotionListener(this.radianceLabelMouseInputListener);
        this.iconPane.addMouseListener(this.radianceLabelMouseInputListener);
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installListeners();
        }
    }

    @Override
    protected void uninstallListeners() {
        ((RadianceInternalFrameTitlePane)this.iconPane).uninstallListeners();
        this.iconPane.removeMouseMotionListener(this.radianceLabelMouseInputListener);
        this.iconPane.removeMouseListener(this.radianceLabelMouseInputListener);
        this.radianceLabelMouseInputListener = null;
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallListeners();
        }
        super.uninstallListeners();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(this.width, this.desktopIcon.getLayout().minimumLayoutSize((Container)this.desktopIcon).height);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    @Override
    public void installUI(JComponent c) {
        this.themingWidgets = RadianceThemingWidgetRepository.getRepository().getMatchingWidgets(c);
        super.installUI(c);
        c.setOpaque(false);
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installUI();
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallUI();
        }
        RadianceInternalFrameTitlePane thePane = (RadianceInternalFrameTitlePane)this.iconPane;
        super.uninstallUI(c);
        thePane.uninstallListeners();
    }

    public JComponent getComponentForHover() {
        return this.iconPane;
    }

    void installIfNecessary(JInternalFrame.JDesktopIcon jdi) {
        if (this.desktopIcon == null) {
            this.installUI(jdi);
        }
    }

    void uninstallIfNecessary(JInternalFrame.JDesktopIcon jdi) {
        if (this.desktopIcon == jdi) {
            this.uninstallUI(jdi);
        }
    }

    void setWindowModified(boolean isWindowModified) {
        ((RadianceInternalFrameTitlePane)this.iconPane).getCloseButton().putClientProperty("radiance.theming.internal.contentsModified", isWindowModified);
    }
}

