/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.View;
import org.pushingpixels.radiance.animation.api.Timeline;
import org.pushingpixels.radiance.animation.api.callback.TimelineCallback;
import org.pushingpixels.radiance.animation.api.swing.SwingComponentTimeline;
import org.pushingpixels.radiance.animation.api.swing.SwingRepaintCallback;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.RadianceThemingWidget;
import org.pushingpixels.radiance.theming.api.shaper.RadianceButtonShaper;
import org.pushingpixels.radiance.theming.internal.AnimationConfigurationManager;
import org.pushingpixels.radiance.theming.internal.RadianceThemingWidgetRepository;
import org.pushingpixels.radiance.theming.internal.animation.ModificationAwareUI;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.utils.ButtonBackgroundDelegate;
import org.pushingpixels.radiance.theming.internal.utils.ButtonVisualStateTracker;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceMetricsUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTextUtilities;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;
import org.pushingpixels.radiance.theming.internal.utils.border.RadianceButtonBorder;
import org.pushingpixels.radiance.theming.internal.utils.icon.GlowingIcon;
import org.pushingpixels.radiance.theming.internal.widget.animation.effects.GhostPaintingUtils;
import org.pushingpixels.radiance.theming.internal.widget.animation.effects.GhostingListener;

public class RadianceButtonUI
extends BasicButtonUI
implements TransitionAwareUI,
ModificationAwareUI {
    public static final String BORDER_COMPUTED = "radiance.theming.internal.buttonbordercomputed";
    public static final String BORDER_COMPUTING = "radiance.theming.internal.buttonbordercomputing";
    static final String BORDER_ORIGINAL = "radiance.theming.internal.buttonborderoriginal";
    private static final String ICON_ORIGINAL = "radiance.theming.internal.buttoniconoriginal";
    static final String OPACITY_ORIGINAL = "radiance.theming.internal.controlopacityoriginal";
    static final String LOCK_OPACITY = "radiance.theming.internal.lockopacity";
    private ButtonBackgroundDelegate delegate;
    private GlowingIcon glowingIcon;
    private PropertyChangeListener radiancePropertyListener;
    private ButtonVisualStateTracker radianceVisualStateTracker;
    private GhostingListener ghostModelChangeListener;
    private Set<RadianceThemingWidget<JComponent>> themingWidgets;
    protected AbstractButton button;
    private Color textColor;
    private Timeline modifiedTimeline;
    private Rectangle viewRect = new Rectangle();
    private Rectangle iconRect = new Rectangle();
    private Rectangle textRect = new Rectangle();

    public static ComponentUI createUI(JComponent comp) {
        RadianceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new RadianceButtonUI((AbstractButton)comp);
    }

    protected RadianceButtonUI(AbstractButton button) {
        this.button = button;
        this.delegate = new ButtonBackgroundDelegate();
    }

    @Override
    public void installUI(JComponent c) {
        this.themingWidgets = RadianceThemingWidgetRepository.getRepository().getMatchingWidgets(c);
        super.installUI(c);
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installUI();
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallUI();
        }
        super.uninstallUI(c);
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (b.getClientProperty(BORDER_ORIGINAL) == null) {
            b.putClientProperty(BORDER_ORIGINAL, b.getBorder());
        }
        RadianceButtonShaper shaper = RadianceCoreUtilities.getButtonShaper(b);
        if (b.getClientProperty(BORDER_COMPUTED) == null) {
            b.setBorder(shaper.getButtonBorder(b));
        } else {
            Border currBorder = b.getBorder();
            if (!(currBorder instanceof RadianceButtonBorder)) {
                b.setBorder(shaper.getButtonBorder(b));
            } else {
                RadianceButtonBorder sbCurrBorder = (RadianceButtonBorder)currBorder;
                if (shaper.getClass() != sbCurrBorder.getButtonShaperClass()) {
                    b.setBorder(shaper.getButtonBorder(b));
                }
            }
        }
        b.putClientProperty(OPACITY_ORIGINAL, b.isOpaque());
        b.setOpaque(false);
        b.setRolloverEnabled(true);
        LookAndFeel.installProperty(b, "iconTextGap", RadianceSizeUtils.getTextIconGap(RadianceSizeUtils.getComponentFontSize(b)));
        if (Boolean.TRUE.equals(b.getClientProperty("radiance.theming.internal.contentsModified"))) {
            this.trackModificationFlag();
        }
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        b.setBorder((Border)b.getClientProperty(BORDER_ORIGINAL));
        b.setOpaque((Boolean)b.getClientProperty(OPACITY_ORIGINAL));
        Icon origIcon = (Icon)b.getClientProperty(ICON_ORIGINAL);
        if (origIcon != null) {
            b.setIcon(origIcon);
        }
        b.putClientProperty(OPACITY_ORIGINAL, null);
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallDefaults();
        }
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return null;
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        this.radianceVisualStateTracker = new ButtonVisualStateTracker();
        this.radianceVisualStateTracker.installListeners(b, true);
        this.trackGlowingIcon();
        this.radiancePropertyListener = propertyChangeEvent -> {
            if ("icon".equals(propertyChangeEvent.getPropertyName())) {
                this.trackGlowingIcon();
            }
            if ("radiance.theming.internal.contentsModified".equals(propertyChangeEvent.getPropertyName())) {
                boolean newValue = (Boolean)propertyChangeEvent.getNewValue();
                if (newValue) {
                    this.trackModificationFlag();
                } else if (this.modifiedTimeline != null) {
                    this.modifiedTimeline.cancel();
                }
            }
            if ("model".equals(propertyChangeEvent.getPropertyName())) {
                if (this.ghostModelChangeListener != null) {
                    this.ghostModelChangeListener.unregisterListeners();
                }
                this.ghostModelChangeListener = new GhostingListener(b, b.getModel());
                this.ghostModelChangeListener.registerListeners();
            }
        };
        b.addPropertyChangeListener(this.radiancePropertyListener);
        this.ghostModelChangeListener = new GhostingListener(b, b.getModel());
        this.ghostModelChangeListener.registerListeners();
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.installListeners();
        }
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        this.radianceVisualStateTracker.uninstallListeners(b);
        this.radianceVisualStateTracker = null;
        b.removePropertyChangeListener(this.radiancePropertyListener);
        this.radiancePropertyListener = null;
        this.ghostModelChangeListener.unregisterListeners();
        this.ghostModelChangeListener = null;
        for (RadianceThemingWidget<JComponent> themingWidget : this.themingWidgets) {
            themingWidget.uninstallListeners();
        }
        super.uninstallListeners(b);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        AbstractButton b = (AbstractButton)c;
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        this.viewRect.x = i.left;
        this.viewRect.y = i.top;
        this.viewRect.width = b.getWidth() - (i.right + this.viewRect.x);
        this.viewRect.height = b.getHeight() - (i.bottom + this.viewRect.y);
        this.textRect.height = 0;
        this.textRect.width = 0;
        this.textRect.y = 0;
        this.textRect.x = 0;
        this.iconRect.height = 0;
        this.iconRect.width = 0;
        this.iconRect.y = 0;
        this.iconRect.x = 0;
        Font f = c.getFont();
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, b.getText() == null ? 0 : b.getIconTextGap());
        Graphics2D g2d = (Graphics2D)g.create();
        View v = (View)c.getClientProperty("html");
        g2d.setFont(f);
        this.delegate.updateBackground(g2d, b);
        if (v != null) {
            v.paint(g2d, this.textRect);
        } else {
            this.textColor = this.paintButtonText(g2d, b, this.textRect, text);
        }
        if (b.getIcon() != null) {
            this.paintIcon(g2d, c, this.iconRect);
        }
        if (b.isFocusPainted()) {
            Graphics2D graphicsFocus = (Graphics2D)g2d.create();
            graphicsFocus.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            RadianceCommonCortex.paintAtScale1x((Graphics2D)graphicsFocus, (int)0, (int)0, (int)b.getWidth(), (int)b.getHeight(), (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> RadianceCoreUtilities.paintFocus(graphics1X, b, b, this, scaleFactor, null, this.textRect, 1.0f, (float)scaleFactor * RadianceSizeUtils.getFocusRingPadding(b, RadianceSizeUtils.getComponentFontSize(b))));
            graphicsFocus.dispose();
        }
        g2d.dispose();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractButton button = (AbstractButton)c;
        RadianceButtonShaper shaper = RadianceCoreUtilities.getButtonShaper(button);
        Dimension superPref = RadianceMetricsUtilities.getPreferredButtonSize(button);
        if (superPref == null) {
            return null;
        }
        if (shaper == null) {
            return superPref;
        }
        return shaper.getPreferredSize(button, superPref);
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        return ButtonBackgroundDelegate.contains((JButton)c, x, y);
    }

    @Override
    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        c.putClientProperty("icon.bounds", new Rectangle(iconRect));
        Graphics2D graphics = (Graphics2D)g.create();
        GhostPaintingUtils.paintGhostIcon(graphics, (AbstractButton)c, iconRect);
        AbstractButton b = (AbstractButton)c;
        Icon originalIcon = RadianceCoreUtilities.getOriginalIcon(b, b.getIcon());
        graphics.setComposite(WidgetUtilities.getAlphaComposite((Component)b, g));
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        StateTransitionTracker stateTracker = this.radianceVisualStateTracker.getStateTransitionTracker();
        graphics.translate(iconRect.x, iconRect.y);
        if (AnimationConfigurationManager.getInstance().isAnimationAllowed(RadianceThemingSlices.AnimationFacet.ICON_GLOW, b) && stateTracker.getIconGlowTracker().isPlaying()) {
            this.glowingIcon.paintIcon(b, graphics, 0, 0);
        } else {
            StateTransitionTracker.ModelStateInfo stateInfo = stateTracker.getModelStateInfo();
            ComponentState currentState = stateInfo.getCurrModelState();
            if (currentState.isDisabled()) {
                Icon disabledIcon = RadianceCoreUtilities.getFilteredIcon(b, originalIcon, currentState, this.textColor);
                disabledIcon.paintIcon(b, graphics, 0, 0);
            } else {
                Icon enabledIcon = RadianceCoreUtilities.getFilteredIcon(b, originalIcon, ComponentState.ENABLED, this.textColor);
                enabledIcon.paintIcon(b, graphics, 0, 0);
                if (stateTracker.getActiveStrength() > 0.0f) {
                    for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : stateInfo.getStateContributionMap().entrySet()) {
                        Icon activeIcon;
                        float contribution;
                        if (entry.getKey() == ComponentState.ENABLED || !((contribution = entry.getValue().getContribution()) > 0.0f) || (activeIcon = RadianceCoreUtilities.getFilteredIcon(b, originalIcon, entry.getKey(), this.textColor)) == enabledIcon) continue;
                        graphics.setComposite(WidgetUtilities.getAlphaComposite(b, contribution, g));
                        activeIcon.paintIcon(b, graphics, 0, 0);
                    }
                }
            }
        }
        graphics.dispose();
    }

    private Color paintButtonText(Graphics g, AbstractButton button, Rectangle textRect, String text) {
        return RadianceTextUtilities.paintText(g, button, textRect, text, button.getDisplayedMnemonicIndex());
    }

    private void trackGlowingIcon() {
        Icon currIcon = this.button.getIcon();
        if (currIcon instanceof GlowingIcon) {
            return;
        }
        if (currIcon == null) {
            return;
        }
        this.glowingIcon = new GlowingIcon(currIcon, this.radianceVisualStateTracker.getStateTransitionTracker().getIconGlowTracker());
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        RadianceCommonCortex.installDesktopHints((Graphics2D)g2d, (Font)c.getFont());
        this.paint(g2d, c);
        g2d.dispose();
    }

    @Override
    public boolean isInside(MouseEvent me) {
        return this.contains(this.button, me.getX(), me.getY());
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.radianceVisualStateTracker.getStateTransitionTracker();
    }

    private void trackModificationFlag() {
        this.modifiedTimeline = ((SwingComponentTimeline.Builder)AnimationConfigurationManager.getInstance().modifiedTimelineBuilder(this.button).addCallback((TimelineCallback)new SwingRepaintCallback((Component)this.button))).build();
        this.modifiedTimeline.playLoop(Timeline.RepeatBehavior.REVERSE);
    }

    @Override
    public Timeline getModificationTimeline() {
        return this.modifiedTimeline;
    }
}

