/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.plugin;

import java.awt.Font;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import org.pushingpixels.radiance.common.api.font.FontSet;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingComponentPlugin;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.ui.RadianceColorChooserUI;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceImageCreator;

public class ColorChooserPlugin
implements RadianceThemingComponentPlugin {
    @Override
    public Object[] getDefaults(RadianceSkin skin) {
        if (!Boolean.TRUE.equals(UIManager.getBoolean("radiance.theming.internal.useDefaultColorChooser"))) {
            Font fontPlainBaseM2;
            ResourceBundle bundle = ResourceBundle.getBundle("org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.Labels");
            LinkedList<Object> labelsList = new LinkedList<Object>();
            Enumeration<String> i = bundle.getKeys();
            while (i.hasMoreElements()) {
                String key = i.nextElement();
                labelsList.add(key);
                labelsList.add(bundle.getObject(key));
            }
            RadianceColorScheme colorScheme = skin.getEnabledColorScheme(RadianceThemingSlices.DecorationAreaType.NONE);
            InsetsUIResource visualMargin = new InsetsUIResource(0, 0, 0, 0);
            ColorUIResource foregroundColor = new ColorUIResource(colorScheme.getForegroundColor());
            Object[] mainDefaults = new Object[]{"Component.visualMargin", visualMargin, "ColorChooser.foreground", foregroundColor, "ColorChooser.defaultChoosers", new String[]{"org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.colorchooser.ColorWheelChooser", "org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.colorchooser.ColorSlidersChooser", "org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.colorchooser.ColorPalettesChooser", "org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.colorchooser.SwatchesChooser", "org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.colorchooser.CrayonsChooser", "org.pushingpixels.radiance.theming.internal.contrib.xoetrope.editor.color.ColorWheelPanel"}, "ColorChooser.swatchesSwatchSize", new DimensionUIResource(5, 5), "ColorChooser.resetMnemonic", -1, "ColorChooser.crayonsImage", table -> RadianceImageCreator.getCrayonsImage(RadianceCoreUtilities.getBackgroundFill(skin, RadianceThemingSlices.DecorationAreaType.NONE)), "ColorChooser.textSliderGap", 0};
            FontSet radianceFontSet = RadianceThemingCortex.GlobalScope.getFontPolicy().getFontSet();
            FontUIResource controlFont = radianceFontSet.getControlFont();
            Font fontBoldBaseP1 = controlFont.deriveFont(1, controlFont.getSize() + 1);
            if (!(fontBoldBaseP1 instanceof FontUIResource)) {
                fontBoldBaseP1 = new FontUIResource(fontBoldBaseP1);
            }
            if (!((fontPlainBaseM2 = controlFont.deriveFont((float)(controlFont.getSize() - 2))) instanceof FontUIResource)) {
                fontPlainBaseM2 = new FontUIResource(fontPlainBaseM2);
            }
            Object[] colorDefaults = new Object[]{"ColorChooserUI", RadianceColorChooserUI.class.getName(), "ColorChooser.font", controlFont, "ColorChooser.smallFont", fontPlainBaseM2, "ColorChooser.crayonsFont", fontBoldBaseP1};
            Object[] labelDefaults = new Object[mainDefaults.length + labelsList.size()];
            System.arraycopy(mainDefaults, 0, labelDefaults, 0, mainDefaults.length);
            int start = mainDefaults.length;
            for (int i2 = 0; i2 < labelsList.size(); ++i2) {
                labelDefaults[start + i2] = labelsList.get(i2);
            }
            mainDefaults = labelDefaults;
            Object[] defaults = new Object[mainDefaults.length + colorDefaults.length];
            System.arraycopy(mainDefaults, 0, defaults, 0, mainDefaults.length);
            start = mainDefaults.length;
            System.arraycopy(colorDefaults, 0, defaults, start + 0, colorDefaults.length);
            return defaults;
        }
        return new Object[0];
    }
}

