/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.painter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.internal.painter.DecorationPainterUtils;
import org.pushingpixels.radiance.theming.internal.painter.OverlayPainterUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadiancePopupContainer;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;

public class BackgroundPaintingUtils {
    public static void updateIfOpaque(Graphics g, JComponent c) {
        if (RadianceCoreUtilities.isOpaque(c)) {
            BackgroundPaintingUtils.update(g, c, false);
        }
    }

    public static void update(Graphics g, JComponent c, boolean force) {
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setComposite(WidgetUtilities.getAlphaComposite((Component)c, g));
        RadianceThemingSlices.DecorationAreaType decorationType = RadianceThemingCortex.ComponentOrParentChainScope.getDecorationType(c);
        RadianceSkin skin = RadianceCoreUtilities.getSkin(c);
        boolean isShowing = c.isShowing();
        boolean showOverlays = true;
        if (c.getParent() instanceof JPopupMenu || c.getClass().isAnnotationPresent(RadiancePopupContainer.class)) {
            showOverlays = false;
        } else if (c instanceof JMenuItem) {
            showOverlays = false;
            if (c instanceof JMenu) {
                showOverlays = ((JMenu)c).isTopLevelMenu();
            }
        } else if (c instanceof JMenuBar) {
            showOverlays = true;
        }
        if (isShowing && decorationType != RadianceThemingSlices.DecorationAreaType.NONE && skin.isRegisteredAsDecorationArea(decorationType)) {
            DecorationPainterUtils.paintDecorationBackground(graphics, c, force);
            if (showOverlays) {
                OverlayPainterUtils.paintOverlays(graphics, c, skin, decorationType);
            }
        } else {
            Color backgr = RadianceColorUtilities.getBackgroundFillColor(c instanceof JTextComponent || c instanceof JSpinner ? c.getParent() : c);
            graphics.setColor(backgr);
            graphics.fillRect(0, 0, c.getWidth(), c.getHeight());
            if (isShowing && showOverlays) {
                OverlayPainterUtils.paintOverlays(graphics, c, skin, decorationType);
            }
        }
        graphics.dispose();
    }

    public static void fillBackground(Graphics g, JComponent c, Color fillColor, Rectangle rect) {
        boolean isInCellRenderer;
        if (!RadianceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        boolean bl = isInCellRenderer = SwingUtilities.getAncestorOfClass(CellRendererPane.class, c) != null;
        if (!c.isShowing() && !isInCellRenderer) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setComposite(WidgetUtilities.getAlphaComposite((Component)c, g));
        graphics.setColor(fillColor);
        graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
        graphics.dispose();
    }
}

