/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

public class SwatchPanel
extends JPanel {
    protected Color[] colors;
    protected Dimension swatchSize = new Dimension();
    protected Dimension defaultSwatchSize;
    protected Dimension numSwatches;
    protected Dimension gap;

    public SwatchPanel() {
        this.initComponents();
        this.initValues();
        this.initColors();
        this.setToolTipText("");
        this.setOpaque(false);
        this.setRequestFocusEnabled(false);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    protected void initValues() {
        this.defaultSwatchSize = UIManager.getDimension("ColorChooser.swatchesSwatchSize");
        this.swatchSize.width = this.defaultSwatchSize.width;
        this.swatchSize.height = this.defaultSwatchSize.height;
        this.gap = new Dimension(1, 1);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.swatchSize.width = width > this.getPreferredSize().width ? (width - this.numSwatches.width * this.gap.width) / this.numSwatches.width : this.defaultSwatchSize.width;
        this.swatchSize.height = height > this.getPreferredSize().height ? (height - this.numSwatches.height * this.gap.height) / this.numSwatches.height : this.defaultSwatchSize.height;
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
    }

    public void setNumSwatches(int rows, int columns) {
        this.numSwatches = new Dimension(rows, columns);
    }

    @Override
    public void paintComponent(Graphics g) {
        Dimension preferredSize = this.getSwatchesSize();
        Color border = RadianceCoreUtilities.getBorderPainter(this).getRepresentativeColor(RadianceColorSchemeUtilities.getColorScheme(this, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED));
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (graphics1X, scaledX, scaledY, scaledWidth, scaledHeight, scaleFactor) -> {
            int xoffset = (int)((double)scaledWidth - scaleFactor * (double)preferredSize.width) / 2;
            int swatchWidth = (int)(scaleFactor * (double)this.swatchSize.width);
            int swatchHeight = (int)(scaleFactor * (double)this.swatchSize.height);
            int gapWidth = (int)(scaleFactor * (double)this.gap.width);
            int gapHeight = (int)(scaleFactor * (double)this.gap.height);
            for (int row = 0; row < this.numSwatches.height; ++row) {
                for (int column = 0; column < this.numSwatches.width; ++column) {
                    int x = xoffset + column * (swatchWidth + gapWidth) + 1;
                    int y = row * (swatchHeight + gapHeight) + 1;
                    Color cellColor = this.getColorForCell(column, row);
                    graphics1X.setColor(cellColor);
                    graphics1X.fillRect(x, y, swatchWidth + 1, swatchHeight + 1);
                    graphics1X.setColor(border);
                    graphics1X.drawLine(x - 1, y - 1, x + swatchWidth, y - 1);
                    graphics1X.drawLine(x - 1, y, x - 1, y + swatchHeight);
                }
            }
            int lastVerticalX = xoffset + (this.numSwatches.width - 1) * (swatchWidth + gapWidth) + swatchWidth + 1;
            int lastHorizontalY = (this.numSwatches.height - 1) * (swatchHeight + gapHeight) + swatchHeight + 1;
            graphics1X.setColor(border);
            graphics1X.drawLine(xoffset, lastHorizontalY, lastVerticalX, lastHorizontalY);
            graphics1X.drawLine(lastVerticalX, 0, lastVerticalX, lastHorizontalY);
        });
        graphics.dispose();
    }

    public Dimension getSwatchesSize() {
        int x = this.numSwatches.width * (this.swatchSize.width + this.gap.width);
        int y = this.numSwatches.height * (this.swatchSize.height + this.gap.height);
        return new Dimension(x, y);
    }

    @Override
    public Dimension getPreferredSize() {
        int x = this.numSwatches.width * (this.defaultSwatchSize.width + this.gap.width);
        int y = this.numSwatches.height * (this.defaultSwatchSize.height + this.gap.height);
        return new Dimension(x, y);
    }

    protected void initColors() {
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Color color = this.getColorForLocation(e.getX(), e.getY());
        return color == null ? null : color.getRed() + ", " + color.getGreen() + ", " + color.getBlue();
    }

    public Color getColorForLocation(int x, int y) {
        Dimension preferredSize = this.getSwatchesSize();
        int column = !this.getComponentOrientation().isLeftToRight() ? this.numSwatches.width - x / (this.swatchSize.width + this.gap.width) - 1 : (x -= (this.getWidth() - preferredSize.width) / 2) / (this.swatchSize.width + this.gap.width);
        int row = y / (this.swatchSize.height + this.gap.height);
        return this.getColorForCell(column, row);
    }

    private Color getColorForCell(int column, int row) {
        int index = row * this.numSwatches.width + column;
        return index < this.colors.length ? this.colors[index] : null;
    }
}

