/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.colorchooser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JList;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.renderer.RadianceDefaultListCellRenderer;
import org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.colorchooser.PaletteEntry;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceStripingUtils;

public class PaletteEntryCellRenderer
extends RadianceDefaultListCellRenderer {
    private ColorIcon icon = new ColorIcon();

    public PaletteEntryCellRenderer() {
        this.setIcon(this.icon);
        this.setOpaque(false);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setComponentOrientation(list.getComponentOrientation());
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        RadianceStripingUtils.applyStripedBackground(list, index, this);
        PaletteEntry entry = (PaletteEntry)value;
        this.icon.setColor(entry.getColor());
        this.setText(entry.getName());
        return this;
    }

    static class ColorIcon
    implements Icon {
        private Color color = Color.black;

        ColorIcon() {
        }

        public void setColor(Color c) {
            this.color = c;
        }

        public Color getColor() {
            return this.color;
        }

        @Override
        public int getIconHeight() {
            return 15;
        }

        @Override
        public int getIconWidth() {
            return 25;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color border = RadianceCoreUtilities.getBorderPainter(c).getRepresentativeColor(RadianceColorSchemeUtilities.getColorScheme(c, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED));
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.translate(x, y);
            RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)this.getIconWidth(), (int)this.getIconHeight(), (graphics1X, scaledX, scaledY, scaledWidth, scaledHeight, scaleFactor) -> {
                graphics1X.setColor(this.getColor());
                graphics1X.fillRect(x, y, scaledWidth - 1, scaledHeight - 1);
                graphics1X.setColor(border);
                graphics1X.drawRect(x, y, scaledWidth - 1, scaledHeight - 1);
            });
            graphics.dispose();
        }
    }
}

