/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.colorchooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.VisualMargin;
import org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.colorchooser.ColorSliderModel;
import org.pushingpixels.radiance.theming.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.radiance.theming.internal.ui.RadianceSliderUI;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RolloverControlListener;

public class ColorSliderUI
extends RadianceSliderUI
implements TransitionAwareUI {
    protected Integer componentIndex;
    protected ColorSliderModel colorSliderModel;
    private ButtonModel thumbModel = new DefaultButtonModel();
    private RolloverControlListener radianceRolloverListener;
    private PropertyChangeListener radiancePropertyChangeListener;
    protected StateTransitionTracker stateTransitionTracker;
    private static final Dimension PREFERRED_HORIZONTAL_SIZE = new Dimension(36, 20);
    private static final Dimension PREFERRED_VERTICAL_SIZE = new Dimension(26, 100);
    private static final Dimension MINIMUM_HORIZONTAL_SIZE = new Dimension(36, 20);
    private static final Dimension MINIMUM_VERTICAL_SIZE = new Dimension(26, 36);

    public ColorSliderUI(JSlider b) {
        super(b);
        this.thumbModel.setArmed(false);
        this.thumbModel.setSelected(false);
        this.thumbModel.setPressed(false);
        this.thumbModel.setRollover(false);
        this.thumbModel.setEnabled(b.isEnabled());
        this.stateTransitionTracker = new StateTransitionTracker((JComponent)b, this.thumbModel);
    }

    public static ComponentUI createUI(JComponent b) {
        return new ColorSliderUI((JSlider)b);
    }

    @Override
    protected void installDefaults(JSlider slider) {
        super.installDefaults(slider);
        this.focusInsets = new Insets(0, 0, 0, 0);
        slider.setOpaque(false);
        if (slider.getOrientation() == 0) {
            slider.setBorder(new VisualMargin(0, 1, -1, 1));
        } else {
            slider.setBorder(new VisualMargin(0, 0, 0, 1));
        }
        slider.setRequestFocusEnabled(true);
    }

    @Override
    protected void installListeners(JSlider slider) {
        super.installListeners(slider);
        this.radianceRolloverListener = new RolloverControlListener(this, this.thumbModel);
        slider.addMouseListener(this.radianceRolloverListener);
        slider.addMouseMotionListener(this.radianceRolloverListener);
        this.radiancePropertyChangeListener = propertyChangeEvent -> {
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                this.thumbModel.setEnabled(slider.isEnabled());
            }
            if ("font".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(slider::updateUI);
            }
        };
        this.slider.addPropertyChangeListener(this.radiancePropertyChangeListener);
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
    }

    @Override
    protected void uninstallListeners(JSlider slider) {
        super.uninstallListeners(slider);
        slider.removeMouseListener(this.radianceRolloverListener);
        slider.removeMouseMotionListener(this.radianceRolloverListener);
        this.radianceRolloverListener = null;
        slider.removePropertyChangeListener(this.radiancePropertyChangeListener);
        this.radiancePropertyChangeListener = null;
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
    }

    @Override
    public Dimension getPreferredHorizontalSize() {
        return PREFERRED_HORIZONTAL_SIZE;
    }

    @Override
    public Dimension getPreferredVerticalSize() {
        return PREFERRED_VERTICAL_SIZE;
    }

    @Override
    public Dimension getMinimumHorizontalSize() {
        return MINIMUM_HORIZONTAL_SIZE;
    }

    @Override
    public Dimension getMinimumVerticalSize() {
        return MINIMUM_VERTICAL_SIZE;
    }

    @Override
    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        if (this.slider.getOrientation() == 0) {
            this.thumbRect.y += 3;
        } else {
            boolean ltr = this.slider.getComponentOrientation().isLeftToRight();
            this.thumbRect.x = ltr ? this.contentRect.x + 1 : this.tickRect.x + this.tickRect.width - this.thumbRect.width;
        }
    }

    @Override
    public void paintTrack(Graphics g) {
        int ch;
        int cw;
        int cy;
        int cx;
        Rectangle trackBounds = this.trackRect;
        if (this.slider.getOrientation() == 0) {
            int pad = this.trackBuffer;
            cx = trackBounds.x - pad + 1;
            cy = trackBounds.y;
            cw = trackBounds.width + pad * 2 - 2;
            ch = trackBounds.height;
        } else {
            int pad = this.trackBuffer;
            cx = trackBounds.x;
            cy = this.contentRect.y + 2;
            cw = trackBounds.width - 1;
            ch = trackBounds.height + pad * 2 - 5;
        }
        Color backgroundFill = RadianceColorSchemeUtilities.getColorScheme(this.slider, RadianceThemingSlices.ColorSchemeAssociationKind.FILL, ComponentState.ENABLED).getTextBackgroundFillColor();
        g.setColor(backgroundFill);
        g.fillRect(cx, cy, cw, ch);
        Color border = RadianceCoreUtilities.getBorderPainter(this.slider).getRepresentativeColor(RadianceColorSchemeUtilities.getColorScheme(this.slider, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED));
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.translate(cx, cy);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)cw, (int)ch, (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            graphics1X.setColor(border);
            graphics1X.drawRect(0, 0, scaledWidth - 1, scaledHeight - 1);
        });
        graphics.dispose();
        this.paintColorTrack(g, cx + 2, cy + 2, cw - 4, ch - 4, this.trackBuffer);
    }

    @Override
    public void paintTicks(Graphics g) {
        RadianceColorScheme tickScheme = RadianceColorSchemeUtilities.getColorScheme(this.slider, RadianceThemingSlices.ColorSchemeAssociationKind.SEPARATOR, ComponentState.ENABLED);
        Rectangle tickBounds = this.tickRect;
        if (this.slider.getOrientation() == 0) {
            int xPos;
            int value;
            if (this.slider.getMinorTickSpacing() > 0) {
                ArrayList<Integer> minorXs = new ArrayList<Integer>();
                for (value = this.slider.getMinimum(); value <= this.slider.getMaximum(); value += this.slider.getMinorTickSpacing()) {
                    xPos = this.xPositionForValue(value);
                    minorXs.add(xPos);
                }
                SeparatorPainterUtils.paintVerticalLines(g, this.slider, tickScheme, tickBounds.y, minorXs, tickBounds.height / 2, 0.75f);
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                ArrayList<Integer> majorXs = new ArrayList<Integer>();
                for (value = this.slider.getMinimum(); value <= this.slider.getMaximum(); value += this.slider.getMajorTickSpacing()) {
                    xPos = this.xPositionForValue(value);
                    majorXs.add(xPos);
                }
                SeparatorPainterUtils.paintVerticalLines(g, this.slider, tickScheme, tickBounds.y, majorXs, tickBounds.height, 0.75f);
            }
        } else {
            int yPos;
            boolean ltr = this.slider.getComponentOrientation().isLeftToRight();
            g.translate(tickBounds.x, 0);
            int value = this.slider.getMinimum();
            if (this.slider.getMinorTickSpacing() > 0) {
                int offset = 0;
                if (!ltr) {
                    offset = tickBounds.width - tickBounds.width / 2;
                }
                ArrayList<Integer> minorYs = new ArrayList<Integer>();
                while (value <= this.slider.getMaximum()) {
                    yPos = this.yPositionForValue(value);
                    minorYs.add(yPos);
                    value += this.slider.getMinorTickSpacing();
                }
                SeparatorPainterUtils.paintHorizontalLines(g, this.slider, tickScheme, offset, minorYs, tickBounds.width / 2, ltr ? 0.75f : 0.25f, ltr);
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                ArrayList<Integer> majorYs = new ArrayList<Integer>();
                for (value = this.slider.getMinimum(); value <= this.slider.getMaximum(); value += this.slider.getMajorTickSpacing()) {
                    yPos = this.yPositionForValue(value);
                    majorYs.add(yPos);
                }
                SeparatorPainterUtils.paintHorizontalLines(g, this.slider, tickScheme, 0, majorYs, tickBounds.width, ltr ? 0.75f : 0.25f, ltr);
            }
            g.translate(-tickBounds.x, 0);
        }
    }

    @Override
    public void paintFocus(Graphics g) {
    }

    private void paintColorTrack(Graphics g, int x, int y, int width, int height, int buffer) {
        if (this.componentIndex == null) {
            this.componentIndex = (Integer)this.slider.getClientProperty("ColorComponentIndex");
        }
        if (this.colorSliderModel == null) {
            this.colorSliderModel = (ColorSliderModel)this.slider.getClientProperty("ColorSliderModel");
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.translate(x, y);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height, (graphics1X, scaledX, scaledY, scaledWidth, scaledHeight, scaleFactor) -> {
            Color[] colorArray;
            int gradientEndX = scaledX;
            int gradientEndY = scaledY;
            if (this.slider.getOrientation() == 0) {
                gradientEndX += scaledWidth;
            } else {
                gradientEndY += scaledHeight;
            }
            Color c1 = new Color(this.colorSliderModel.getInterpolatedRGB(this.componentIndex, 0.0f), true);
            Color c2 = new Color(this.colorSliderModel.getInterpolatedRGB(this.componentIndex, 1.0f));
            float f = scaledX;
            float f2 = scaledY;
            float f3 = gradientEndX;
            float f4 = gradientEndY;
            float[] fArray = new float[]{0.0f, 1.0f};
            if (this.slider.getOrientation() == 0) {
                Color[] colorArray2 = new Color[2];
                colorArray2[0] = c1;
                colorArray = colorArray2;
                colorArray2[1] = c2;
            } else {
                Color[] colorArray3 = new Color[2];
                colorArray3[0] = c2;
                colorArray = colorArray3;
                colorArray3[1] = c1;
            }
            graphics1X.setPaint(new LinearGradientPaint(f, f2, f3, f4, fArray, colorArray));
            graphics1X.fillRect(scaledX, scaledY, scaledWidth, scaledHeight);
        });
        graphics.dispose();
    }

    @Override
    protected void calculateTrackRect() {
        if (this.slider.getOrientation() == 0) {
            this.trackRect.x = this.contentRect.x + this.trackBuffer + 1;
            this.trackRect.height = 13;
            this.trackRect.y = this.contentRect.y + this.contentRect.height - this.trackRect.height;
            this.trackRect.width = this.contentRect.width - this.trackBuffer * 2 - 1;
        } else {
            this.trackRect.width = 14;
            boolean ltr = this.slider.getComponentOrientation().isLeftToRight();
            this.trackRect.x = ltr ? this.contentRect.x + this.contentRect.width - this.trackRect.width : this.contentRect.x;
            this.trackRect.y = this.contentRect.y + this.trackBuffer;
            this.trackRect.height = this.contentRect.height - this.trackBuffer * 2 + 1;
        }
    }

    @Override
    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y - this.getTickLength();
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.getTickLength();
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.y;
                this.tickRect.height = 0;
            }
        } else {
            boolean ltr = this.slider.getComponentOrientation().isLeftToRight();
            if (ltr) {
                this.tickRect.width = this.getTickLength();
                this.tickRect.x = this.trackRect.x - this.tickRect.width;
            } else {
                this.tickRect.x = this.trackRect.x + this.trackRect.width;
                this.tickRect.width = this.getTickLength();
            }
            this.tickRect.y = this.trackRect.y;
            this.tickRect.height = this.trackRect.height;
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.x;
                this.tickRect.width = 0;
            }
        }
    }

    @Override
    protected int getTickLength() {
        return 4;
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener(JSlider slider) {
        return new CSUIPropertyChangeHandler();
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new QuaquaTrackListener();
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    public boolean isInside(MouseEvent me) {
        Rectangle thumbB = this.thumbRect;
        return thumbB != null && thumbB.contains(me.getX(), me.getY());
    }

    public class QuaquaTrackListener
    extends BasicSliderUI.TrackListener {
        public QuaquaTrackListener() {
            super(ColorSliderUI.this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!ColorSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (ColorSliderUI.this.slider.isRequestFocusEnabled()) {
                ColorSliderUI.this.slider.requestFocus();
            }
            if (ColorSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                super.mousePressed(e);
            } else {
                switch (ColorSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        ColorSliderUI.this.slider.setValue(ColorSliderUI.this.valueForYPosition(this.currentMouseY));
                        break;
                    }
                    case 0: {
                        ColorSliderUI.this.slider.setValue(ColorSliderUI.this.valueForXPosition(this.currentMouseX));
                    }
                }
            }
        }
    }

    public class CSUIPropertyChangeHandler
    extends BasicSliderUI.PropertyChangeHandler {
        public CSUIPropertyChangeHandler() {
            super(ColorSliderUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName;
            switch (propertyName = e.getPropertyName()) {
                case "Frame.active": {
                    ColorSliderUI.this.slider.repaint();
                    break;
                }
                case "ColorSliderModel": {
                    ColorSliderUI.this.colorSliderModel = (ColorSliderModel)e.getNewValue();
                    ColorSliderUI.this.slider.repaint();
                    break;
                }
                case "snapToTicks": {
                    ColorSliderUI.this.slider.repaint();
                    break;
                }
                case "ColorComponentIndex": {
                    ColorSliderUI.this.componentIndex = (Integer)e.getNewValue();
                    ColorSliderUI.this.slider.repaint();
                    break;
                }
                case "ColorComponentChange": {
                    ColorSliderUI.this.slider.repaint();
                    break;
                }
                case "ColorComponentValue": {
                    ColorSliderUI.this.slider.repaint();
                    break;
                }
                case "Orientation": {
                    if (ColorSliderUI.this.slider.getOrientation() == 0) {
                        ColorSliderUI.this.slider.setBorder(new VisualMargin(0, 1, -1, 1));
                        break;
                    }
                    ColorSliderUI.this.slider.setBorder(new VisualMargin(0, 0, 0, 1));
                }
            }
            super.propertyChange(e);
        }
    }
}

