/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.blade;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.CellRendererPane;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceOutlineUtilities;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;

public class BladeDrawingUtils {
    public static void paintBladeBorder(Component c, Graphics2D g, int x, int y, int width, int height, float baseRadius, RadianceColorScheme borderScheme) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(x, y);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height, (graphics1X, scaledX, scaledY, scaledWidth, scaledHeight, scaleFactor) -> {
            RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(c);
            float scaledRadius = (float)scaleFactor * baseRadius;
            Shape contour = RadianceOutlineUtilities.getBaseOutline(c.getComponentOrientation(), (float)scaledWidth - 1.0f, (float)scaledHeight - 1.0f, scaledRadius, null, 0.0f);
            boolean skipInnerBorder = c instanceof JTextComponent || SwingUtilities.getAncestorOfClass(CellRendererPane.class, c) != null && SwingUtilities.getAncestorOfClass(JFileChooser.class, c) != null;
            Shape contourInner = skipInnerBorder ? null : RadianceOutlineUtilities.getBaseOutline(c.getComponentOrientation(), (float)scaledWidth - 1.0f, (float)scaledHeight - 1.0f, Math.max(scaledRadius - 1.0f, 0.0f), null, 1.0f);
            borderPainter.paintBorder(graphics1X, c, scaledWidth, scaledHeight, contour, contourInner, borderScheme);
        });
        graphics.dispose();
    }

    public static void paintBladeSimpleBorder(Component c, Graphics2D g, int width, int height, float baseRadius, RadianceColorScheme colorScheme) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height, (graphics1X, x, y, scaledWidth, scaledHeight, scaleFactor) -> {
            RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(c);
            Color borderColor = borderPainter.getRepresentativeColor(colorScheme);
            graphics1X.setColor(borderColor);
            if (baseRadius == 0.0f) {
                graphics1X.setStroke(new BasicStroke(1.0f, 2, 0));
                graphics1X.draw(new Rectangle2D.Float(0.0f, 0.0f, (float)scaledWidth - 1.0f, (float)scaledHeight - 1.0f));
            } else {
                float scaledRadius = (float)scaleFactor * baseRadius;
                graphics1X.setStroke(new BasicStroke(1.0f, 1, 0));
                graphics1X.draw(new RoundRectangle2D.Float(0.0f, 0.0f, (float)scaledWidth - 1.0f, (float)scaledHeight - 1.0f, scaledRadius, scaledRadius));
            }
        });
        graphics.dispose();
    }

    public static void paintRectangularBackground(Component c, Graphics g, int startX, int startY, int width, int height, RadianceColorScheme colorScheme, float borderAlpha, boolean isVertical) {
        LinearGradientPaint paint;
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(startX, startY);
        if (!isVertical) {
            paint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, new float[]{0.0f, 0.4f, 0.5f, 1.0f}, new Color[]{colorScheme.getUltraLightColor(), colorScheme.getLightColor(), colorScheme.getMidColor(), colorScheme.getUltraLightColor()}, MultipleGradientPaint.CycleMethod.REPEAT);
            graphics.setPaint(paint);
            graphics.fillRect(0, 0, width, height);
        } else {
            paint = new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, new float[]{0.0f, 0.4f, 0.5f, 1.0f}, new Color[]{colorScheme.getUltraLightColor(), colorScheme.getLightColor(), colorScheme.getMidColor(), colorScheme.getUltraLightColor()}, MultipleGradientPaint.CycleMethod.REPEAT);
            graphics.setPaint(paint);
            graphics.fillRect(0, 0, width, height);
        }
        if (borderAlpha > 0.0f) {
            Graphics2D g2d = (Graphics2D)graphics.create();
            g2d.setComposite(WidgetUtilities.getAlphaComposite(null, borderAlpha, graphics));
            BladeDrawingUtils.paintBladeSimpleBorder(c, g2d, width, height, 0.0f, colorScheme);
            g2d.dispose();
        }
        graphics.dispose();
    }
}

