/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal;

import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.pushingpixels.radiance.animation.api.ease.Spline;
import org.pushingpixels.radiance.animation.api.ease.TimelineEase;
import org.pushingpixels.radiance.animation.api.swing.SwingComponentTimeline;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;

public class AnimationConfigurationManager {
    private static final Spline DEFAULT_EASE = new Spline(0.5f);
    private static AnimationConfigurationManager instance;
    private long timelineDuration = 200L;
    private Set<RadianceThemingSlices.AnimationFacet> globalAllowed = new HashSet<RadianceThemingSlices.AnimationFacet>();
    private Map<RadianceThemingSlices.AnimationFacet, Set<Class<?>>> classAllowed = new HashMap();
    private Map<RadianceThemingSlices.AnimationFacet, Set<Class<?>>> classDisallowed = new HashMap();
    private Map<RadianceThemingSlices.AnimationFacet, Set<Component>> instanceAllowed = new HashMap<RadianceThemingSlices.AnimationFacet, Set<Component>>();
    private Map<RadianceThemingSlices.AnimationFacet, Set<Component>> instanceDisallowed = new HashMap<RadianceThemingSlices.AnimationFacet, Set<Component>>();

    public static synchronized AnimationConfigurationManager getInstance() {
        if (instance == null) {
            instance = new AnimationConfigurationManager();
        }
        return instance;
    }

    private AnimationConfigurationManager() {
    }

    public synchronized void allowAnimations(RadianceThemingSlices.AnimationFacet animationFacet) {
        this.globalAllowed.add(animationFacet);
    }

    public synchronized void allowAnimations(RadianceThemingSlices.AnimationFacet animationFacet, Class<?> clazz) {
        Set<Class<?>> existingAllowed = this.classAllowed.get(animationFacet);
        if (existingAllowed == null) {
            existingAllowed = new HashSet();
            this.classAllowed.put(animationFacet, existingAllowed);
        }
        existingAllowed.add(clazz);
        Set<Class<?>> existingDisallowed = this.classDisallowed.get(animationFacet);
        if (existingDisallowed != null) {
            existingDisallowed.remove(clazz);
        }
    }

    public synchronized void allowAnimations(RadianceThemingSlices.AnimationFacet animationFacet, Class<?>[] clazz) {
        for (int i = 0; i < clazz.length; ++i) {
            this.allowAnimations(animationFacet, clazz[i]);
        }
    }

    public synchronized void allowAnimations(RadianceThemingSlices.AnimationFacet animationFacet, Component comp) {
        Set<Component> existingAllowed = this.instanceAllowed.get(animationFacet);
        if (existingAllowed == null) {
            existingAllowed = new HashSet<Component>();
            this.instanceAllowed.put(animationFacet, existingAllowed);
        }
        existingAllowed.add(comp);
        Set<Component> existingDisallowed = this.instanceDisallowed.get(animationFacet);
        if (existingDisallowed != null) {
            existingDisallowed.remove(comp);
        }
    }

    public synchronized void disallowAnimations(RadianceThemingSlices.AnimationFacet animationFacet) {
        this.globalAllowed.remove(animationFacet);
    }

    public synchronized void disallowAnimations(RadianceThemingSlices.AnimationFacet animationFacet, Class<?> clazz) {
        Set<Class<?>> existingDisallowed;
        Set<Class<?>> existingAllowed = this.classAllowed.get(animationFacet);
        if (existingAllowed != null) {
            existingAllowed.remove(clazz);
            if (existingAllowed.isEmpty()) {
                this.classAllowed.remove(animationFacet);
            }
        }
        if ((existingDisallowed = this.classDisallowed.get(animationFacet)) == null) {
            existingDisallowed = new HashSet();
            this.classDisallowed.put(animationFacet, existingDisallowed);
        }
        existingDisallowed.add(clazz);
    }

    public synchronized void disallowAnimations(RadianceThemingSlices.AnimationFacet animationFacet, Class<?>[] clazz) {
        for (int i = 0; i < clazz.length; ++i) {
            this.disallowAnimations(animationFacet, clazz[i]);
        }
    }

    public synchronized void disallowAnimations(RadianceThemingSlices.AnimationFacet animationFacet, Component comp) {
        Set<Component> existingDisallowed;
        Set<Component> existingAllowed = this.instanceAllowed.get(animationFacet);
        if (existingAllowed != null) {
            existingAllowed.remove(comp);
            if (existingAllowed.isEmpty()) {
                this.instanceAllowed.remove(animationFacet);
            }
        }
        if ((existingDisallowed = this.instanceDisallowed.get(animationFacet)) == null) {
            existingDisallowed = new HashSet<Component>();
            this.instanceDisallowed.put(animationFacet, existingDisallowed);
        }
        existingDisallowed.add(comp);
    }

    public synchronized boolean isAnimationAllowed(RadianceThemingSlices.AnimationFacet animationFacet, Component comp) {
        Set<Component> instanceDisallowed = this.instanceDisallowed.get(animationFacet);
        if (instanceDisallowed != null && instanceDisallowed.contains(comp)) {
            return false;
        }
        Set<Component> instanceAllowed = this.instanceAllowed.get(animationFacet);
        if (instanceAllowed != null && instanceAllowed.contains(comp)) {
            return true;
        }
        if (comp != null) {
            Class<?> clazz = comp.getClass();
            Set<Class<?>> classAllowed = this.classAllowed.get(animationFacet);
            Set<Class<?>> classDisallowed = this.classDisallowed.get(animationFacet);
            if (classDisallowed != null) {
                for (Class<?> disallowed : classDisallowed) {
                    if (!disallowed.isAssignableFrom(clazz)) continue;
                    return false;
                }
            }
            if (classAllowed != null) {
                for (Class<?> allowed : classAllowed) {
                    if (!allowed.isAssignableFrom(clazz)) continue;
                    return true;
                }
            }
        }
        return this.globalAllowed.contains(animationFacet);
    }

    public void setTimelineDuration(long timelineDuration) {
        this.timelineDuration = timelineDuration;
    }

    public long getTimelineDuration() {
        return this.timelineDuration;
    }

    public SwingComponentTimeline.Builder timelineBuilder(Component component) {
        return (SwingComponentTimeline.Builder)((SwingComponentTimeline.Builder)SwingComponentTimeline.componentBuilder((Component)component).setDuration(this.timelineDuration)).setEase((TimelineEase)DEFAULT_EASE);
    }

    public SwingComponentTimeline.Builder modifiedTimelineBuilder(Component component) {
        return (SwingComponentTimeline.Builder)((SwingComponentTimeline.Builder)SwingComponentTimeline.componentBuilder((Component)component).setDuration(this.timelineDuration)).setEase(durationFraction -> {
            if (durationFraction < 0.8f) {
                return 0.0f;
            }
            return 5.0f * (durationFraction - 0.8f);
        });
    }
}

