/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.titlepane;

import java.awt.Graphics2D;
import javax.swing.JRootPane;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.titlepane.TitlePaneButtonProvider;
import org.pushingpixels.radiance.theming.api.titlepane.TitlePaneButtonsProvider;
import org.pushingpixels.radiance.theming.internal.blade.BladeIconUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;

public class DefaultTitlePaneButtonsProvider
implements TitlePaneButtonsProvider {
    @Override
    public TitlePaneButtonProvider getCloseButtonProvider() {
        return new DefaultCloseButtonProvider();
    }

    @Override
    public TitlePaneButtonProvider getRestoreButtonProvider() {
        return new DefaultRestoreButtonProvider();
    }

    @Override
    public TitlePaneButtonProvider getIconifyButtonProvider() {
        return new DefaultIconifyButtonProvider();
    }

    @Override
    public TitlePaneButtonProvider getMaximizeButtonProvider() {
        return new DefaultMaximizeButtonProvider();
    }

    public static class DefaultMaximizeButtonProvider
    implements TitlePaneButtonProvider {
        @Override
        public String getText(JRootPane rootPane) {
            return RadianceThemingCortex.GlobalScope.getLabelBundle().getString("SystemMenu.maximize");
        }

        @Override
        public void drawIcon(Graphics2D g, RadianceColorScheme scheme, float alpha, int iconSize) {
            BladeIconUtils.drawMaximizeIcon(g, iconSize, scheme);
        }
    }

    public static class DefaultIconifyButtonProvider
    implements TitlePaneButtonProvider {
        @Override
        public String getText(JRootPane rootPane) {
            return RadianceThemingCortex.GlobalScope.getLabelBundle().getString("SystemMenu.iconify");
        }

        @Override
        public void drawIcon(Graphics2D g, RadianceColorScheme scheme, float alpha, int iconSize) {
            BladeIconUtils.drawIconifyIcon(g, iconSize, scheme);
        }
    }

    public static class DefaultRestoreButtonProvider
    implements TitlePaneButtonProvider {
        @Override
        public String getText(JRootPane rootPane) {
            return RadianceThemingCortex.GlobalScope.getLabelBundle().getString("SystemMenu.restore");
        }

        @Override
        public void drawIcon(Graphics2D g, RadianceColorScheme scheme, float alpha, int iconSize) {
            BladeIconUtils.drawRestoreIcon(g, iconSize, scheme);
        }
    }

    public static class DefaultCloseButtonProvider
    implements TitlePaneButtonProvider {
        @Override
        public String getText(JRootPane rootPane) {
            if (rootPane != null && RadianceCoreUtilities.isRootPaneModified(rootPane)) {
                return RadianceThemingCortex.GlobalScope.getLabelBundle().getString("SystemMenu.close") + " [" + RadianceThemingCortex.GlobalScope.getLabelBundle().getString("Tooltip.contentsNotSaved") + "]";
            }
            return RadianceThemingCortex.GlobalScope.getLabelBundle().getString("SystemMenu.close");
        }

        @Override
        public void drawIcon(Graphics2D g, RadianceColorScheme scheme, float alpha, int iconSize) {
            BladeIconUtils.drawCloseIcon(g, iconSize, RadianceSizeUtils.getCloseIconStrokeWidth(iconSize), scheme);
        }
    }
}

