/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.skin;

import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceColorSchemeBundle;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.ColorSchemeSingleColorQuery;
import org.pushingpixels.radiance.theming.api.colorscheme.ColorTransform;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.ClassicBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.border.CompositeBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.border.DelegateFractionBasedBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.border.FractionBasedBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.decoration.MatteDecorationPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.ClassicFillPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.FractionBasedFillPainter;
import org.pushingpixels.radiance.theming.api.painter.overlay.BottomLineOverlayPainter;
import org.pushingpixels.radiance.theming.api.painter.overlay.BottomShadowOverlayPainter;
import org.pushingpixels.radiance.theming.api.painter.overlay.TopBezelOverlayPainter;
import org.pushingpixels.radiance.theming.api.painter.overlay.TopLineOverlayPainter;
import org.pushingpixels.radiance.theming.api.shaper.ClassicButtonShaper;

public class GeminiSkin
extends RadianceSkin {
    public static final String NAME = "Gemini";
    private BottomLineOverlayPainter menuOverlayPainter;
    private TopLineOverlayPainter toolbarOverlayPainter;
    private BottomLineOverlayPainter toolbarBottomLineOverlayPainter;
    private TopBezelOverlayPainter footerTopBezelOverlayPainter;

    public GeminiSkin() {
        RadianceSkin.ColorSchemes schemes = RadianceSkin.getColorSchemes(this.getClass().getClassLoader().getResourceAsStream("org/pushingpixels/radiance/theming/api/skin/gemini.colorschemes"));
        RadianceColorScheme grayScheme = schemes.get("Gemini Gray");
        RadianceColorScheme disabledScheme = schemes.get("Gemini Disabled");
        RadianceColorSchemeBundle defaultSchemeBundle = new RadianceColorSchemeBundle(grayScheme, grayScheme, disabledScheme);
        RadianceColorScheme highlightScheme = schemes.get("Gemini Highlight");
        RadianceColorScheme highlightBorderScheme = schemes.get("Gemini Highlight Border");
        GeminiSkin.applyHighlightColorScheme(defaultSchemeBundle, highlightScheme);
        GeminiSkin.applyHighlightAsFill(defaultSchemeBundle, highlightScheme, highlightBorderScheme);
        RadianceColorScheme grayBorderScheme = schemes.get("Gemini Gray Border");
        RadianceColorScheme lightGrayBorderScheme = schemes.get("Gemini Light Gray Border");
        RadianceColorScheme darkGraySeparatorScheme = schemes.get("Gemini Dark Gray Separator");
        defaultSchemeBundle.registerColorScheme(grayBorderScheme, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        defaultSchemeBundle.registerColorScheme(lightGrayBorderScheme, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, ComponentState.DISABLED_DEFAULT, ComponentState.DISABLED_SELECTED, ComponentState.DISABLED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(grayScheme, ComponentState.ROLLOVER_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(darkGraySeparatorScheme, RadianceThemingSlices.ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        defaultSchemeBundle.registerColorScheme(grayScheme, RadianceThemingSlices.ColorSchemeAssociationKind.MARK, new ComponentState[0]);
        defaultSchemeBundle.registerAlpha(0.6f, ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED);
        defaultSchemeBundle.registerColorScheme(highlightScheme.tone(0.2f), ComponentState.DISABLED_SELECTED);
        RadianceColorScheme whiteBackgroundScheme = schemes.get("Gemini White Background");
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, whiteBackgroundScheme, RadianceThemingSlices.DecorationAreaType.NONE);
        RadianceColorSchemeBundle controlPaneSchemeBundle = new RadianceColorSchemeBundle(grayScheme, grayScheme, disabledScheme);
        controlPaneSchemeBundle.registerColorScheme(grayScheme, ComponentState.ROLLOVER_UNSELECTED);
        controlPaneSchemeBundle.registerColorScheme(grayScheme, RadianceThemingSlices.ColorSchemeAssociationKind.MARK, new ComponentState[0]);
        controlPaneSchemeBundle.registerColorScheme(grayBorderScheme, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        controlPaneSchemeBundle.registerAlpha(0.6f, ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED);
        GeminiSkin.applyHighlightColorScheme(controlPaneSchemeBundle, highlightScheme);
        GeminiSkin.applyHighlightAsFill(controlPaneSchemeBundle, highlightScheme, highlightBorderScheme);
        this.registerDecorationAreaSchemeBundle(controlPaneSchemeBundle, grayScheme, RadianceThemingSlices.DecorationAreaType.CONTROL_PANE, RadianceThemingSlices.DecorationAreaType.FOOTER);
        RadianceColorScheme blackColorScheme = schemes.get("Gemini Black");
        RadianceColorScheme activeHeaderScheme = schemes.get("Gemini Black Active Header");
        RadianceColorScheme disabledHeaderScheme = schemes.get("Gemini Black Disabled Header");
        RadianceColorSchemeBundle headerSchemeBundle = new RadianceColorSchemeBundle(activeHeaderScheme, blackColorScheme, blackColorScheme);
        headerSchemeBundle.registerAlpha(0.5f, ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED);
        headerSchemeBundle.registerColorScheme(disabledHeaderScheme, ComponentState.DISABLED_SELECTED, ComponentState.DISABLED_UNSELECTED);
        headerSchemeBundle.registerColorScheme(blackColorScheme, ComponentState.ROLLOVER_UNSELECTED);
        headerSchemeBundle.registerColorScheme(blackColorScheme, RadianceThemingSlices.ColorSchemeAssociationKind.MARK, new ComponentState[0]);
        headerSchemeBundle.registerColorScheme(grayScheme, RadianceThemingSlices.ColorSchemeAssociationKind.MARK, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED);
        headerSchemeBundle.registerColorScheme(blackColorScheme.shade(0.9f), RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        GeminiSkin.applyHighlightColorScheme(headerSchemeBundle, highlightScheme);
        GeminiSkin.applyHighlightAsFill(headerSchemeBundle, highlightScheme, highlightBorderScheme);
        this.registerDecorationAreaSchemeBundle(headerSchemeBundle, blackColorScheme, RadianceThemingSlices.DecorationAreaType.PRIMARY_TITLE_PANE, RadianceThemingSlices.DecorationAreaType.SECONDARY_TITLE_PANE, RadianceThemingSlices.DecorationAreaType.HEADER);
        RadianceColorScheme darkBlueColorScheme = schemes.get("Gemini Dark Blue");
        RadianceColorScheme darkBlueBackgroundColorScheme = schemes.get("Gemini Dark Blue Background");
        RadianceColorScheme darkBlueSeparatorColorScheme = schemes.get("Gemini Dark Blue Separator");
        RadianceColorSchemeBundle toolbarSchemeBundle = new RadianceColorSchemeBundle(blackColorScheme, darkBlueColorScheme, darkBlueColorScheme);
        toolbarSchemeBundle.registerAlpha(0.5f, ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED);
        toolbarSchemeBundle.registerColorScheme(blackColorScheme, ComponentState.DISABLED_SELECTED);
        toolbarSchemeBundle.registerColorScheme(darkBlueColorScheme, ComponentState.DISABLED_UNSELECTED);
        toolbarSchemeBundle.registerColorScheme(blackColorScheme, ComponentState.ROLLOVER_UNSELECTED);
        toolbarSchemeBundle.registerColorScheme(darkBlueColorScheme, RadianceThemingSlices.ColorSchemeAssociationKind.MARK, new ComponentState[0]);
        toolbarSchemeBundle.registerColorScheme(darkBlueColorScheme, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        toolbarSchemeBundle.registerColorScheme(darkBlueSeparatorColorScheme, RadianceThemingSlices.ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        toolbarSchemeBundle.registerColorScheme(highlightScheme, RadianceThemingSlices.ColorSchemeAssociationKind.MARK, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED, ComponentState.PRESSED_SELECTED);
        GeminiSkin.applyHighlightColorScheme(toolbarSchemeBundle, highlightScheme);
        GeminiSkin.applyHighlightAsFill(toolbarSchemeBundle, highlightScheme, darkBlueColorScheme);
        this.registerDecorationAreaSchemeBundle(toolbarSchemeBundle, darkBlueBackgroundColorScheme, RadianceThemingSlices.DecorationAreaType.TOOLBAR);
        this.footerTopBezelOverlayPainter = new TopBezelOverlayPainter(ColorSchemeSingleColorQuery.DARK, ColorSchemeSingleColorQuery.ULTRALIGHT);
        this.addOverlayPainter(this.footerTopBezelOverlayPainter, RadianceThemingSlices.DecorationAreaType.FOOTER);
        this.menuOverlayPainter = new BottomLineOverlayPainter(ColorSchemeSingleColorQuery.composite(ColorSchemeSingleColorQuery.ULTRADARK, ColorTransform.brightness(-0.5f)));
        this.toolbarOverlayPainter = new TopLineOverlayPainter(ColorSchemeSingleColorQuery.composite(ColorSchemeSingleColorQuery.FOREGROUND, ColorTransform.alpha(32)));
        this.addOverlayPainter(this.menuOverlayPainter, RadianceThemingSlices.DecorationAreaType.HEADER);
        this.addOverlayPainter(this.toolbarOverlayPainter, RadianceThemingSlices.DecorationAreaType.TOOLBAR);
        this.addOverlayPainter(BottomShadowOverlayPainter.getInstance(100), RadianceThemingSlices.DecorationAreaType.TOOLBAR);
        this.toolbarBottomLineOverlayPainter = new BottomLineOverlayPainter(ColorSchemeSingleColorQuery.ULTRADARK);
        this.addOverlayPainter(this.toolbarBottomLineOverlayPainter, RadianceThemingSlices.DecorationAreaType.TOOLBAR);
        this.buttonShaper = new ClassicButtonShaper();
        this.fillPainter = new FractionBasedFillPainter(NAME, new float[]{0.0f, 0.5f, 1.0f}, new ColorSchemeSingleColorQuery[]{ColorSchemeSingleColorQuery.EXTRALIGHT, ColorSchemeSingleColorQuery.LIGHT, ColorSchemeSingleColorQuery.MID});
        this.decorationPainter = new MatteDecorationPainter();
        this.highlightFillPainter = new ClassicFillPainter();
        FractionBasedBorderPainter outerBorderPainter = new FractionBasedBorderPainter("Gemini Outer", new float[]{0.0f, 0.5f, 1.0f}, new ColorSchemeSingleColorQuery[]{ColorSchemeSingleColorQuery.ULTRADARK, ColorSchemeSingleColorQuery.ULTRADARK, ColorSchemeSingleColorQuery.ULTRADARK});
        DelegateFractionBasedBorderPainter innerBorderPainter = new DelegateFractionBasedBorderPainter("Gemini Inner", outerBorderPainter, new int[]{0x60FFFFFF, 0x40FFFFFF, 0x20FFFFFF}, scheme -> scheme.tint(0.7f));
        this.borderPainter = new CompositeBorderPainter(NAME, outerBorderPainter, innerBorderPainter);
        this.highlightBorderPainter = new ClassicBorderPainter();
    }

    private static void applyHighlightColorScheme(RadianceColorSchemeBundle schemeBundle, RadianceColorScheme highlightScheme) {
        schemeBundle.registerHighlightAlpha(0.85f, ComponentState.ROLLOVER_UNSELECTED);
        schemeBundle.registerHighlightAlpha(0.9f, ComponentState.SELECTED);
        schemeBundle.registerHighlightAlpha(1.0f, ComponentState.ROLLOVER_SELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        schemeBundle.registerHighlightColorScheme(highlightScheme, ComponentState.ROLLOVER_UNSELECTED, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
    }

    private static void applyHighlightAsFill(RadianceColorSchemeBundle schemeBundle, RadianceColorScheme highlightScheme, RadianceColorScheme highlightBorderScheme) {
        schemeBundle.registerColorScheme(highlightBorderScheme, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ROLLOVER_ARMED, ComponentState.ROLLOVER_SELECTED, ComponentState.ROLLOVER_UNSELECTED);
        schemeBundle.registerColorScheme(highlightScheme, RadianceThemingSlices.ColorSchemeAssociationKind.FILL, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED);
        schemeBundle.registerColorScheme(highlightScheme, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, ComponentState.getActiveStates());
        schemeBundle.registerColorScheme(highlightScheme, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT_TEXT, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED);
        schemeBundle.registerColorScheme(highlightScheme, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }
}

