/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ListUI;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.renderer.RadianceRenderer;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.ui.RadianceListUI;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.UpdateOptimizationInfo;

@RadianceRenderer
public abstract class RadiancePanelListCellRenderer<T>
extends JPanel
implements ListCellRenderer<T> {
    private Set<JLabel> themeAwareLabels;
    private Map<JLabel, IconData> themeAwareLabelsWithIcons;

    public RadiancePanelListCellRenderer() {
        RadianceThemingCortex.ComponentOrParentChainScope.setColorizationFactor(this, 1.0);
        this.themeAwareLabels = new HashSet<JLabel>();
        this.themeAwareLabelsWithIcons = new HashMap<JLabel, IconData>();
    }

    protected void registerThemeAwareLabelsWithText(JLabel ... labels) {
        for (JLabel label : labels) {
            this.themeAwareLabels.add(label);
        }
    }

    protected void unregisterThemeAwareLabelsWithText(JLabel ... labels) {
        for (JLabel label : labels) {
            this.themeAwareLabels.remove(label);
        }
    }

    protected void registerThemeAwareLabelWithIcon(JLabel label, RadianceIcon.Factory radianceIconFactory, Dimension iconDimension) {
        this.themeAwareLabelsWithIcons.put(label, new IconData(radianceIconFactory, iconDimension));
    }

    protected void unregisterThemeAwareLabelWithIcon(JLabel label) {
        this.themeAwareLabelsWithIcons.remove(label);
    }

    @Override
    public final Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
        Color labelForeground;
        this.setComponentOrientation(list.getComponentOrientation());
        ListUI listUI = list.getUI();
        if (listUI instanceof RadianceListUI) {
            boolean isDropLocation;
            RadianceListUI ui = (RadianceListUI)listUI;
            StateTransitionTracker.ModelStateInfo modelStateInfo = ui.getModelStateInfo(index);
            ComponentState currState = ui.getCellState(index, this);
            JList.DropLocation dropLocation = list.getDropLocation();
            boolean bl = isDropLocation = dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == index;
            if (!isDropLocation && modelStateInfo != null) {
                Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
                RadianceColorScheme colorScheme = this.getColorSchemeForState(list, ui, currState);
                if (currState.isDisabled() || activeStates == null || activeStates.size() == 1) {
                    labelForeground = new ColorUIResource(colorScheme.getForegroundColor());
                } else {
                    float aggrRed = 0.0f;
                    float aggrGreen = 0.0f;
                    float aggrBlue = 0.0f;
                    for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : modelStateInfo.getStateContributionMap().entrySet()) {
                        ComponentState activeState = activeEntry.getKey();
                        float contribution = activeEntry.getValue().getContribution();
                        RadianceColorScheme scheme = this.getColorSchemeForState(list, ui, activeState);
                        Color schemeFg = scheme.getForegroundColor();
                        aggrRed += (float)schemeFg.getRed() * contribution;
                        aggrGreen += (float)schemeFg.getGreen() * contribution;
                        aggrBlue += (float)schemeFg.getBlue() * contribution;
                    }
                    labelForeground = new ColorUIResource(new Color((int)aggrRed, (int)aggrGreen, (int)aggrBlue));
                }
            } else {
                RadianceColorScheme scheme = this.getColorSchemeForState(list, ui, currState);
                if (isDropLocation) {
                    scheme = RadianceColorSchemeUtilities.getColorScheme(list, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT, currState);
                }
                labelForeground = new ColorUIResource(scheme.getForegroundColor());
            }
        } else {
            labelForeground = isSelected ? list.getSelectionForeground() : list.getForeground();
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        this.bindData(list, value, index);
        this.onPreRender(list, value, index);
        for (JLabel jLabel : this.themeAwareLabels) {
            jLabel.setForeground(labelForeground);
        }
        for (Map.Entry entry : this.themeAwareLabelsWithIcons.entrySet()) {
            JLabel label = (JLabel)entry.getKey();
            IconData iconData = (IconData)entry.getValue();
            RadianceIcon icon = iconData.iconFactory.createNewIcon();
            icon.setColorFilter(color -> labelForeground);
            icon.setDimension(iconData.iconSize);
            label.setIcon((Icon)icon);
        }
        return this;
    }

    protected abstract void bindData(JList<? extends T> var1, T var2, int var3);

    protected void onPreRender(JList<? extends T> list, T value, int index) {
    }

    private RadianceColorScheme getColorSchemeForState(JList list, RadianceListUI ui, ComponentState state) {
        UpdateOptimizationInfo updateOptimizationInfo = ui.getUpdateOptimizationInfo();
        if (state == ComponentState.ENABLED) {
            if (updateOptimizationInfo == null) {
                return RadianceColorSchemeUtilities.getColorScheme(list, state);
            }
            return updateOptimizationInfo.getDefaultScheme();
        }
        if (updateOptimizationInfo == null) {
            return RadianceColorSchemeUtilities.getColorScheme(list, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT, state);
        }
        return updateOptimizationInfo.getHighlightColorScheme(state);
    }

    private static class IconData {
        private RadianceIcon.Factory iconFactory;
        private Dimension iconSize;

        private IconData(RadianceIcon.Factory iconFactory, Dimension iconSize) {
            this.iconFactory = iconFactory;
            this.iconSize = iconSize;
        }
    }
}

