/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.painter.fill;

import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;

public class SpecularRectangularFillPainter
implements RadianceFillPainter {
    private static int SCALE = 2;
    private RadianceFillPainter baseFillPainter;
    private float alpha;

    public SpecularRectangularFillPainter(RadianceFillPainter baseFillPainter, float alpha) {
        this.baseFillPainter = baseFillPainter;
        this.alpha = alpha;
    }

    @Override
    public String getDisplayName() {
        return "Specular Rectangular " + this.baseFillPainter.getDisplayName();
    }

    @Override
    public Color getRepresentativeColor(RadianceColorScheme fillScheme) {
        return this.baseFillPainter.getRepresentativeColor(fillScheme);
    }

    private double spline(double startY, double control1Y, double control2Y, double endY, double t) {
        double invT = 1.0 - t;
        return startY * invT * invT * invT + control1Y * 3.0 * t * invT * invT + control2Y * 3.0 * t * t * invT + endY * t * t * t;
    }

    @Override
    public void paintContourBackground(Graphics g, Component comp, float width, float height, Shape contour, RadianceColorScheme fillScheme) {
        this.baseFillPainter.paintContourBackground(g, comp, width, height, contour, fillScheme);
        int iw = (int)width;
        int ih = (int)height;
        int shineWidth = iw / SCALE;
        int shineHeight = ih / (2 * SCALE);
        if (shineWidth > 0 && shineHeight > 0) {
            BufferedImage shineImage = this.getShineImage(comp, contour, fillScheme.getUltraLightColor(), fillScheme.getLightColor(), this.alpha, shineWidth, shineHeight);
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            graphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            graphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            graphics.clip(contour);
            graphics.drawImage(shineImage, 0, 0, iw, ih / 2, 0, 0, shineImage.getWidth(), shineImage.getHeight(), null);
            graphics.dispose();
        }
    }

    private BufferedImage getShineImage(Component comp, Shape contour, Color topShineColor, Color bottomShineColor, float alpha, int shineWidth, int shineHeight) {
        BufferedImage shineImage = new BufferedImage(shineWidth, shineHeight, 2);
        Graphics2D g2d = shineImage.createGraphics();
        g2d.setComposite(new Shine(comp, contour, topShineColor, bottomShineColor, alpha));
        g2d.fillRect(0, 0, shineWidth, shineHeight);
        g2d.dispose();
        return shineImage;
    }

    private class Shine
    implements Composite {
        private Component comp;
        private Shape contour;
        private Color topShineColor;
        private Color bottomShineColor;
        private float alpha;

        public Shine(Component comp, Shape contour, Color topShineColor, Color bottomShineColor, float alpha) {
            this.comp = comp;
            this.contour = contour;
            this.topShineColor = topShineColor;
            this.bottomShineColor = bottomShineColor;
            this.alpha = alpha;
        }

        @Override
        public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
            return new ShineContext(this, this.alpha);
        }
    }

    private final class ShineContext
    implements CompositeContext {
        private Shine shine;
        private float alpha;

        public ShineContext(Shine shine, float alpha) {
            this.shine = shine;
            this.alpha = alpha;
        }

        @Override
        public void dispose() {
        }

        @Override
        public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
            if (src.getSampleModel().getDataType() != 3 || dstIn.getSampleModel().getDataType() != 3 || dstOut.getSampleModel().getDataType() != 3) {
                throw new IllegalStateException("Source and destination must store pixels as INT.");
            }
            int shineWidth = Math.min(src.getWidth(), dstIn.getWidth());
            int shineHeight = Math.min(src.getHeight(), dstIn.getHeight());
            double gap = 0.5 * RadianceCommonCortex.getScaleFactor((Component)this.shine.comp) / (double)SCALE;
            double ramp = 2.0 * RadianceCommonCortex.getScaleFactor((Component)this.shine.comp) / (double)SCALE;
            double topLeftCornerRadius = 0.0;
            double topRightCornerRadius = 0.0;
            if (this.shine.contour instanceof RoundRectangle2D) {
                RoundRectangle2D rrContour = (RoundRectangle2D)this.shine.contour;
                topLeftCornerRadius = rrContour.getArcWidth() / (2.0 * (double)SCALE);
                topRightCornerRadius = rrContour.getArcWidth() / (2.0 * (double)SCALE);
            } else if (this.shine.contour instanceof Ellipse2D) {
                Ellipse2D ellContour = (Ellipse2D)this.shine.contour;
                topLeftCornerRadius = ellContour.getWidth() / (2.0 * (double)SCALE);
                topRightCornerRadius = ellContour.getWidth() / (2.0 * (double)SCALE);
            }
            int[] dstPixels = new int[shineWidth];
            for (int row = 0; row < shineHeight; ++row) {
                if ((double)row <= gap) {
                    for (int col = 0; col < shineWidth; ++col) {
                        dstPixels[col] = 0;
                    }
                } else {
                    double yalpha;
                    double cfraction;
                    int rowColor = RadianceColorUtilities.getInterpolatedRGB(this.shine.topShineColor, this.shine.bottomShineColor, 1.0 - (double)row / (double)shineHeight);
                    int rowAlpha = rowColor >>> 24 & 0xFF;
                    int rowRed = rowColor >>> 16 & 0xFF;
                    int rowGreen = rowColor >>> 8 & 0xFF;
                    int rowBlue = rowColor >>> 0 & 0xFF;
                    if ((double)row <= gap + ramp) {
                        cfraction = ((double)row - gap) / ramp;
                        yalpha = SpecularRectangularFillPainter.this.spline(0.0, 0.1, 0.9, 1.0, cfraction);
                    } else {
                        cfraction = ((double)row - gap - ramp) / ((double)shineHeight - gap - ramp);
                        yalpha = SpecularRectangularFillPainter.this.spline(0.0, 0.1, 0.9, 1.0, 1.0 - cfraction);
                    }
                    for (int col = 0; col < shineWidth; ++col) {
                        double cfraction2;
                        double dx;
                        double dy;
                        double xalpha = 1.0;
                        if (col <= shineWidth / 2) {
                            double overlayXStart = gap;
                            if (topLeftCornerRadius > 0.0 && (double)row <= gap + topLeftCornerRadius) {
                                dy = gap + topLeftCornerRadius - (double)row;
                                dx = Math.sqrt(topLeftCornerRadius * topLeftCornerRadius - dy * dy);
                                overlayXStart = gap + topLeftCornerRadius - dx;
                            }
                            if ((double)col <= overlayXStart) {
                                xalpha = 0.0;
                            } else if ((double)col <= overlayXStart + ramp) {
                                cfraction2 = (overlayXStart + ramp - (double)col) / ramp;
                                xalpha = SpecularRectangularFillPainter.this.spline(0.0, 0.1, 0.9, 1.0, 1.0 - cfraction2);
                            }
                        } else {
                            double overlayXEnd = (double)shineWidth - gap - 1.0;
                            if (topRightCornerRadius > 0.0 && (double)row <= gap + topRightCornerRadius) {
                                dy = gap + topRightCornerRadius - (double)row;
                                dx = Math.sqrt(topRightCornerRadius * topRightCornerRadius - dy * dy);
                                overlayXEnd = (double)shineWidth - gap - 1.0 - topRightCornerRadius + dx;
                            }
                            if ((double)col > overlayXEnd) {
                                xalpha = 0.0;
                            } else if ((double)col > overlayXEnd - ramp) {
                                cfraction2 = ((double)col - (overlayXEnd - ramp)) / ramp;
                                xalpha = SpecularRectangularFillPainter.this.spline(0.0, 0.1, 0.9, 1.0, 1.0 - cfraction2);
                            }
                        }
                        int falpha = (int)(0.9 * (double)this.alpha * (double)rowAlpha * xalpha * yalpha);
                        if (falpha < 0) {
                            falpha = 0;
                        }
                        if (falpha > 255) {
                            falpha = 255;
                        }
                        dstPixels[col] = falpha << 24 | rowRed << 16 | rowGreen << 8 | rowBlue;
                    }
                }
                dstOut.setDataElements(0, row, shineWidth, 1, dstPixels);
            }
        }
    }
}

