/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.painter.fill;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Shape;
import org.pushingpixels.radiance.theming.api.colorscheme.ColorSchemeSingleColorQuery;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.FractionBasedPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;

public class FractionBasedFillPainter
extends FractionBasedPainter
implements RadianceFillPainter {
    public FractionBasedFillPainter(String displayName, float[] fractions, ColorSchemeSingleColorQuery[] colorQueries) {
        super(displayName, fractions, colorQueries);
    }

    @Override
    public void paintContourBackground(Graphics g, Component comp, float width, float height, Shape contour, RadianceColorScheme fillScheme) {
        Graphics2D graphics = (Graphics2D)g.create();
        Color[] fillColors = new Color[this.fractions.length];
        for (int i = 0; i < this.fractions.length; ++i) {
            ColorSchemeSingleColorQuery colorQuery = this.colorQueries[i];
            fillColors[i] = colorQuery.query(fillScheme);
        }
        LinearGradientPaint gradient = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, this.fractions, fillColors, MultipleGradientPaint.CycleMethod.REPEAT);
        graphics.setPaint(gradient);
        graphics.fill(contour);
        graphics.dispose();
    }

    @Override
    public Color getRepresentativeColor(RadianceColorScheme fillScheme) {
        for (int i = 0; i < this.fractions.length - 1; ++i) {
            float fractionLow = this.fractions[i];
            float fractionHigh = this.fractions[i + 1];
            if (fractionLow == 0.5f) {
                return this.colorQueries[i].query(fillScheme);
            }
            if (fractionHigh == 0.5f) {
                return this.colorQueries[i + 1].query(fillScheme);
            }
            if (fractionLow > 0.5f || fractionHigh < 0.5f) continue;
            Color colorLow = this.colorQueries[i].query(fillScheme);
            Color colorHigh = this.colorQueries[i + 1].query(fillScheme);
            float colorLowLikeness = (0.5f - fractionLow) / (fractionHigh - fractionLow);
            return RadianceColorUtilities.getInterpolatedColor(colorLow, colorHigh, colorLowLikeness);
        }
        throw new IllegalStateException("Could not find representative color");
    }
}

