/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.painter.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Shape;
import org.pushingpixels.radiance.theming.api.colorscheme.ColorSchemeSingleColorQuery;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.FractionBasedPainter;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceInternalArrowButton;

public class FractionBasedBorderPainter
extends FractionBasedPainter
implements RadianceBorderPainter {
    public FractionBasedBorderPainter(String displayName, float[] fractions, ColorSchemeSingleColorQuery[] colorQueries) {
        super(displayName, fractions, colorQueries);
    }

    @Override
    public void paintBorder(Graphics g, Component c, float width, float height, Shape contour, Shape innerContour, RadianceColorScheme borderScheme) {
        if (contour == null) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        Color[] drawColors = new Color[this.fractions.length];
        for (int i = 0; i < this.fractions.length; ++i) {
            ColorSchemeSingleColorQuery colorQuery = this.colorQueries[i];
            drawColors[i] = colorQuery.query(borderScheme);
        }
        boolean isSpecialButton = c != null && c.getClass().isAnnotationPresent(RadianceInternalArrowButton.class);
        int joinKind = isSpecialButton ? 0 : 1;
        int capKind = isSpecialButton ? 2 : 0;
        graphics.setStroke(new BasicStroke(1.0f, capKind, joinKind));
        LinearGradientPaint gradient = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, this.fractions, drawColors, MultipleGradientPaint.CycleMethod.REPEAT);
        graphics.setPaint(gradient);
        graphics.draw(contour);
        graphics.dispose();
    }

    @Override
    public boolean isPaintingInnerContour() {
        return false;
    }

    @Override
    public Color getRepresentativeColor(RadianceColorScheme borderScheme) {
        for (int i = 0; i < this.fractions.length - 1; ++i) {
            float fractionLow = this.fractions[i];
            float fractionHigh = this.fractions[i + 1];
            if (fractionLow == 0.5f) {
                return this.colorQueries[i].query(borderScheme);
            }
            if (fractionHigh == 0.5f) {
                return this.colorQueries[i + 1].query(borderScheme);
            }
            if (fractionLow > 0.5f || fractionHigh < 0.5f) continue;
            Color colorLow = this.colorQueries[i].query(borderScheme);
            Color colorHigh = this.colorQueries[i + 1].query(borderScheme);
            float colorLowLikeness = (0.5f - fractionLow) / (fractionHigh - fractionLow);
            return RadianceColorUtilities.getInterpolatedColor(colorLow, colorHigh, colorLowLikeness);
        }
        throw new IllegalStateException("Could not find representative color");
    }
}

