/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.colorscheme;

import java.awt.Color;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.colorscheme.SchemeDerivedColors;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorUtilities;

public class DerivedColorsResolverLight
implements SchemeDerivedColors {
    private RadianceColorScheme scheme;

    public DerivedColorsResolverLight(RadianceColorScheme scheme) {
        if (scheme.isDark()) {
            throw new IllegalArgumentException("The scheme must be light: " + scheme.getDisplayName());
        }
        this.scheme = scheme;
    }

    public String toString() {
        return "Resolver for " + this.scheme.getDisplayName();
    }

    @Override
    public Color getLineColor() {
        return RadianceColorUtilities.getInterpolatedColor(this.scheme.getMidColor(), this.scheme.getDarkColor(), 0.7f);
    }

    @Override
    public Color getSelectionForegroundColor() {
        return this.scheme.getForegroundColor();
    }

    @Override
    public Color getSelectionBackgroundColor() {
        return this.scheme.getExtraLightColor();
    }

    @Override
    public Color getBackgroundFillColor() {
        return this.scheme.getExtraLightColor();
    }

    @Override
    public Color getAccentedBackgroundFillColor() {
        return RadianceColorUtilities.getDarkerColor(this.scheme.getExtraLightColor(), 0.08f);
    }

    @Override
    public Color getFocusRingColor() {
        return RadianceColorUtilities.getAlphaColor(this.scheme.getForegroundColor(), 192);
    }

    @Override
    public Color getTextBackgroundFillColor() {
        return RadianceColorUtilities.getInterpolatedColor(this.scheme.getUltraLightColor(), this.scheme.getExtraLightColor(), 0.8f);
    }

    @Override
    public Color getSeparatorPrimaryColor() {
        return RadianceColorUtilities.getInterpolatedColor(this.scheme.getMidColor(), this.scheme.getDarkColor(), 0.4f);
    }

    @Override
    public Color getSeparatorSecondaryColor() {
        return this.scheme.getUltraLightColor();
    }

    @Override
    public Color getMarkColor() {
        return RadianceColorUtilities.getInterpolatedColor(this.scheme.getForegroundColor(), this.scheme.getUltraDarkColor(), 0.7);
    }

    @Override
    public Color getEchoColor() {
        return this.scheme.getUltraLightColor();
    }
}

