/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.api.colorscheme;

import java.awt.Color;
import org.pushingpixels.radiance.theming.api.colorscheme.ColorTransform;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.colorscheme.SchemeBaseColors;

@FunctionalInterface
public interface ColorSchemeSingleColorQuery {
    public static final ColorSchemeSingleColorQuery ULTRALIGHT = SchemeBaseColors::getUltraLightColor;
    public static final ColorSchemeSingleColorQuery EXTRALIGHT = SchemeBaseColors::getExtraLightColor;
    public static final ColorSchemeSingleColorQuery LIGHT = SchemeBaseColors::getLightColor;
    public static final ColorSchemeSingleColorQuery MID = SchemeBaseColors::getMidColor;
    public static final ColorSchemeSingleColorQuery DARK = SchemeBaseColors::getDarkColor;
    public static final ColorSchemeSingleColorQuery ULTRADARK = SchemeBaseColors::getUltraDarkColor;
    public static final ColorSchemeSingleColorQuery FOREGROUND = SchemeBaseColors::getForegroundColor;

    public Color query(RadianceColorScheme var1);

    public static ColorSchemeSingleColorQuery composite(ColorSchemeSingleColorQuery base, ColorTransform ... transforms) {
        return scheme -> {
            Color result = base.query(scheme);
            for (ColorTransform transform : transforms) {
                result = transform.transform(result);
            }
            return result;
        };
    }
}

