/*
 * @(#)SwatchPanel.java  1.0  30 March 2005
 *
 * Copyright (c) 2004 Werner Randelshofer
 * Staldenmattweg 2, Immensee, CH-6405, Switzerland.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */

package org.pushingpixels.radiance.theming.internal.contrib.randelshofer.quaqua.colorchooser;

import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseEvent;

/**
 * SwatchPanel.
 * <p>
 * Code derived from javax.swing.colorchooser.DefaultSwatchChooserPanel.
 *
 * @author Werner Randelshofer
 * @version 1.0  30 March 2005  Created.
 */
public class SwatchPanel extends javax.swing.JPanel {
    protected Color[] colors;
    protected Dimension swatchSize = new Dimension();
    protected Dimension defaultSwatchSize;
    protected Dimension numSwatches;
    protected Dimension gap;

    /**
     * Creates new form.
     */
    public SwatchPanel() {
        initComponents();

        initValues();
        initColors();
        setToolTipText(""); // register for events
        setOpaque(false);
        //setBackground(Color.white);
        setRequestFocusEnabled(false);
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents

        setLayout(new java.awt.BorderLayout());

    }//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables


    @Override
    public boolean isFocusable() {
        return false;
    }

    protected void initValues() {
        defaultSwatchSize = UIManager.getDimension("ColorChooser.swatchesSwatchSize");
        swatchSize.width = defaultSwatchSize.width;
        swatchSize.height = defaultSwatchSize.height;
        gap = new Dimension(1, 1);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (width > getPreferredSize().width) {
            swatchSize.width = (width - numSwatches.width * gap.width) / numSwatches.width;
        } else {
            swatchSize.width = defaultSwatchSize.width;
        }
        if (height > getPreferredSize().height) {
            swatchSize.height = (height - numSwatches.height * gap.height) / numSwatches.height;
        } else {
            swatchSize.height = defaultSwatchSize.height;
        }
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
    }

    public void setNumSwatches(int rows, int columns) {
        numSwatches = new Dimension(rows, columns);
    }

    public void paintComponent(Graphics g) {
        Dimension preferredSize = getSwatchesSize();

        Color border = RadianceCoreUtilities.getBorderPainter(this).getRepresentativeColor(
                RadianceColorSchemeUtilities.getColorScheme(this,
                        RadianceThemingSlices.ColorSchemeAssociationKind.BORDER,
                        ComponentState.ENABLED));

        // Important - do not set KEY_STROKE_CONTROL to VALUE_STROKE_PURE, as that instructs AWT
        // to not normalize coordinates to paint at full pixels, and will result in blurry
        // outlines.
        Graphics2D graphics = (Graphics2D) g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        RadianceCommonCortex.paintAtScale1x(graphics, 0, 0, getWidth(), getHeight(),
                (graphics1X, scaledX, scaledY, scaledWidth, scaledHeight, scaleFactor) -> {
                    int xoffset = (int) (scaledWidth - scaleFactor * preferredSize.width) / 2;
                    int swatchWidth = (int) (scaleFactor * swatchSize.width);
                    int swatchHeight = (int) (scaleFactor * swatchSize.height);
                    int gapWidth = (int) (scaleFactor * gap.width);
                    int gapHeight = (int) (scaleFactor * gap.height);

                    for (int row = 0; row < numSwatches.height; row++) {
                        for (int column = 0; column < numSwatches.width; column++) {
                            int x = xoffset + column * (swatchWidth + gapWidth) + 1;
                            int y = row * (swatchHeight + gapHeight) + 1;

                            Color cellColor = getColorForCell(column, row);
                            graphics1X.setColor(cellColor);
                            graphics1X.fillRect(x, y, swatchWidth + 1, swatchHeight + 1);

                            graphics1X.setColor(border);
                            // top horizontal
                            graphics1X.drawLine(x - 1, y - 1, x + swatchWidth, y - 1);
                            // left vertical
                            graphics1X.drawLine(x - 1, y, x - 1, y + swatchHeight);
                        }
                    }

                    int lastVerticalX = xoffset + (numSwatches.width - 1) * (swatchWidth + gapWidth)
                            + swatchWidth + 1;
                    int lastHorizontalY = (numSwatches.height - 1) * (swatchHeight + gapHeight) +
                            swatchHeight + 1;

                    graphics1X.setColor(border);
                    // bottom horizontal
                    graphics1X.drawLine(xoffset, lastHorizontalY, lastVerticalX, lastHorizontalY);
                    // right vertical
                    graphics1X.drawLine(lastVerticalX, 0, lastVerticalX, lastHorizontalY);
                });
        graphics.dispose();
    }

    public Dimension getSwatchesSize() {
        int x = numSwatches.width * (swatchSize.width + gap.width);
        int y = numSwatches.height * (swatchSize.height + gap.height);
        return new Dimension(x, y);
    }

    public Dimension getPreferredSize() {
        int x = numSwatches.width * (defaultSwatchSize.width + gap.width);
        int y = numSwatches.height * (defaultSwatchSize.height + gap.height);
        return new Dimension(x, y);
    }

    protected void initColors() {


    }

    public String getToolTipText(MouseEvent e) {
        Color color = getColorForLocation(e.getX(), e.getY());
        return (color == null) ? null :
                color.getRed() + ", " + color.getGreen() + ", " + color.getBlue();
    }

    public Color getColorForLocation(int x, int y) {
        Dimension preferredSize = getSwatchesSize();
        x -= (getWidth() - preferredSize.width) / 2;
        //y -= (getHeight() - preferredSize.height) / 2;
        int column;
        if ((!this.getComponentOrientation().isLeftToRight())) {
            column = numSwatches.width - x / (swatchSize.width + gap.width) - 1;
        } else {
            column = x / (swatchSize.width + gap.width);
        }
        int row = y / (swatchSize.height + gap.height);
        return getColorForCell(column, row);
    }

    private Color getColorForCell(int column, int row) {
        int index = (row * numSwatches.width) + column;
        return (index < colors.length) ? colors[index] : null;
    }


}
