/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.tools.themingdebugger;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceLookAndFeel;
import org.pushingpixels.radiance.theming.api.RadianceSkin;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.RadianceThemingWidget;
import org.pushingpixels.radiance.theming.api.colorscheme.ColorSchemeTransform;
import org.pushingpixels.radiance.theming.api.text.RadianceTextArea;
import org.pushingpixels.radiance.theming.internal.utils.LazyResettableHashMap;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.widget.animation.effects.GhostPaintingUtils;
import org.pushingpixels.radiance.tools.themingdebugger.ColorBlindColorScheme;
import org.pushingpixels.radiance.tools.themingdebugger.DeuteranopiaColorScheme;
import org.pushingpixels.radiance.tools.themingdebugger.ProtanopiaColorScheme;
import org.pushingpixels.radiance.tools.themingdebugger.TritanopiaColorScheme;

public class RootPaneTitlePaneUiDebugger
extends RadianceThemingWidget<JRootPane> {
    private MouseListener radianceDebugUiListener;
    private JComponent titlePane;

    private static void dump(Component comp, int level) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            sb.append("  ");
        }
        sb.append(comp.toString());
        System.out.println(sb);
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                RootPaneTitlePaneUiDebugger.dump(cont.getComponent(i), level + 1);
            }
        }
    }

    public void installUI() {
        SwingUtilities.invokeLater(() -> {
            if (!(UIManager.getLookAndFeel() instanceof RadianceLookAndFeel)) {
                return;
            }
            this.titlePane = RadianceCoreUtilities.getTitlePaneComponent((Window)SwingUtilities.getWindowAncestor(this.jcomp));
            if (this.titlePane != null) {
                this.radianceDebugUiListener = new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        this.process(e);
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        this.process(e);
                    }

                    private void process(MouseEvent e) {
                        if (!e.isPopupTrigger()) {
                            return;
                        }
                        JPopupMenu popup = new JPopupMenu();
                        RadianceThemingCortex.ComponentOrParentChainScope.setDecorationType((JComponent)popup, (RadianceThemingSlices.DecorationAreaType)RadianceThemingSlices.DecorationAreaType.HEADER);
                        JMenu cbMenu = new JMenu("Color blindness");
                        JMenuItem protanopiaCurrent = new JMenuItem("Protanopia current");
                        protanopiaCurrent.addActionListener(new SkinChanger(ProtanopiaColorScheme::new, "Protanopia current"));
                        cbMenu.add(protanopiaCurrent);
                        JMenuItem deuteranopiaCurrent = new JMenuItem("Deuteranopia current");
                        deuteranopiaCurrent.addActionListener(new SkinChanger(DeuteranopiaColorScheme::new, "Deuteranopia current"));
                        cbMenu.add(deuteranopiaCurrent);
                        JMenuItem tritanopiaCurrent = new JMenuItem("Tritanopia current");
                        tritanopiaCurrent.addActionListener(new SkinChanger(TritanopiaColorScheme::new, "Tritanopia current"));
                        cbMenu.add(tritanopiaCurrent);
                        cbMenu.addSeparator();
                        JMenuItem restoreOriginal = new JMenuItem("Restore original");
                        if (RadianceThemingCortex.GlobalScope.getCurrentSkin().getColorScheme(null, ComponentState.ENABLED) instanceof ColorBlindColorScheme) {
                            restoreOriginal.addActionListener(new SkinChanger(scheme -> {
                                if (scheme instanceof ColorBlindColorScheme) {
                                    return ((ColorBlindColorScheme)scheme).getOrigScheme();
                                }
                                return scheme;
                            }, "Current"));
                        } else {
                            restoreOriginal.setEnabled(false);
                        }
                        cbMenu.add(restoreOriginal);
                        popup.add(cbMenu);
                        JMenu animMenu = new JMenu("Animation rate");
                        JMenuItem debugNone = new JMenuItem("None");
                        debugNone.addActionListener(new AnimationChanger(0L));
                        animMenu.add(debugNone);
                        JMenuItem debugAnim = new JMenuItem("Debug rate (extra slow)");
                        debugAnim.addActionListener(new AnimationChanger(5000L));
                        animMenu.add(debugAnim);
                        JMenuItem debugAnimFast = new JMenuItem("Debug rate (faster)");
                        debugAnimFast.addActionListener(new AnimationChanger(2500L));
                        animMenu.add(debugAnimFast);
                        JMenuItem debugSlow = new JMenuItem("Slow rate");
                        debugSlow.addActionListener(new AnimationChanger(1000L));
                        animMenu.add(debugSlow);
                        JMenuItem debugRegular = new JMenuItem("Regular rate");
                        debugRegular.addActionListener(new AnimationChanger(250L));
                        animMenu.add(debugRegular);
                        JMenuItem debugFast = new JMenuItem("Fast rate");
                        debugFast.addActionListener(new AnimationChanger(100L));
                        animMenu.add(debugFast);
                        popup.add(animMenu);
                        JMenu focusMenu = new JMenu("Focus kind");
                        for (RadianceThemingSlices.FocusKind fKind : RadianceThemingSlices.FocusKind.values()) {
                            JMenuItem focusMenuItem = new JMenuItem(fKind.name().toLowerCase());
                            focusMenuItem.addActionListener(new FocusKindChanger(fKind));
                            focusMenu.add(focusMenuItem);
                        }
                        popup.add(focusMenu);
                        JMenuItem dumpHierarchy = new JMenuItem("Dump hierarchy");
                        dumpHierarchy.addActionListener(event -> RootPaneTitlePaneUiDebugger.dump(RootPaneTitlePaneUiDebugger.this.jcomp, 0));
                        popup.add(dumpHierarchy);
                        JCheckBoxMenuItem ltrChange = new JCheckBoxMenuItem("Is left-to-right");
                        ltrChange.setSelected(((JRootPane)RootPaneTitlePaneUiDebugger.this.jcomp).getComponentOrientation().isLeftToRight());
                        ltrChange.addActionListener(event -> SwingUtilities.invokeLater(() -> ((JRootPane)RootPaneTitlePaneUiDebugger.this.jcomp).applyComponentOrientation(ltrChange.isSelected() ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.RIGHT_TO_LEFT)));
                        popup.add(ltrChange);
                        JMenu iconFiltering = new JMenu("Icon filtering");
                        JMenuItem defaultIconFiltering = new JMenuItem("Default");
                        defaultIconFiltering.addActionListener(event -> SwingUtilities.invokeLater(() -> {
                            RadianceThemingCortex.GlobalScope.setIconFilterStrategies((RadianceThemingSlices.IconFilterStrategy)RadianceThemingSlices.IconFilterStrategy.ORIGINAL, (RadianceThemingSlices.IconFilterStrategy)RadianceThemingSlices.IconFilterStrategy.ORIGINAL, (RadianceThemingSlices.IconFilterStrategy)RadianceThemingSlices.IconFilterStrategy.THEMED_FOLLOW_COLOR_SCHEME);
                            ((JRootPane)RootPaneTitlePaneUiDebugger.this.jcomp).repaint();
                        }));
                        iconFiltering.add(defaultIconFiltering);
                        JMenuItem mutedIconFiltering = new JMenuItem("Muted");
                        mutedIconFiltering.addActionListener(event -> SwingUtilities.invokeLater(() -> {
                            RadianceThemingCortex.GlobalScope.setIconFilterStrategies((RadianceThemingSlices.IconFilterStrategy)RadianceThemingSlices.IconFilterStrategy.ORIGINAL, (RadianceThemingSlices.IconFilterStrategy)RadianceThemingSlices.IconFilterStrategy.THEMED_FOLLOW_COLOR_SCHEME, (RadianceThemingSlices.IconFilterStrategy)RadianceThemingSlices.IconFilterStrategy.THEMED_FOLLOW_COLOR_SCHEME);
                            ((JRootPane)RootPaneTitlePaneUiDebugger.this.jcomp).repaint();
                        }));
                        iconFiltering.add(mutedIconFiltering);
                        JMenuItem textInactiveIconFiltering = new JMenuItem("Text inactive");
                        textInactiveIconFiltering.addActionListener(event -> SwingUtilities.invokeLater(() -> {
                            RadianceThemingCortex.GlobalScope.setIconFilterStrategies((RadianceThemingSlices.IconFilterStrategy)RadianceThemingSlices.IconFilterStrategy.ORIGINAL, (RadianceThemingSlices.IconFilterStrategy)RadianceThemingSlices.IconFilterStrategy.THEMED_FOLLOW_TEXT, (RadianceThemingSlices.IconFilterStrategy)RadianceThemingSlices.IconFilterStrategy.THEMED_FOLLOW_TEXT);
                            ((JRootPane)RootPaneTitlePaneUiDebugger.this.jcomp).repaint();
                        }));
                        iconFiltering.add(textInactiveIconFiltering);
                        JMenuItem textAlwaysIconFiltering = new JMenuItem("Text always");
                        textAlwaysIconFiltering.addActionListener(event -> SwingUtilities.invokeLater(() -> {
                            RadianceThemingCortex.GlobalScope.setIconFilterStrategies((RadianceThemingSlices.IconFilterStrategy)RadianceThemingSlices.IconFilterStrategy.THEMED_FOLLOW_TEXT, (RadianceThemingSlices.IconFilterStrategy)RadianceThemingSlices.IconFilterStrategy.THEMED_FOLLOW_TEXT, (RadianceThemingSlices.IconFilterStrategy)RadianceThemingSlices.IconFilterStrategy.THEMED_FOLLOW_TEXT);
                            ((JRootPane)RootPaneTitlePaneUiDebugger.this.jcomp).repaint();
                        }));
                        iconFiltering.add(textAlwaysIconFiltering);
                        popup.add(iconFiltering);
                        JCheckBoxMenuItem ghostDebugMode = new JCheckBoxMenuItem("Ghost debug mode");
                        ghostDebugMode.addActionListener(event -> SwingUtilities.invokeLater(() -> {
                            ghostDebugMode.setEnabled(false);
                            GhostPaintingUtils.MAX_ICON_GHOSTING_ALPHA = 0.8f;
                            GhostPaintingUtils.MIN_ICON_GHOSTING_ALPHA = 0.6f;
                            GhostPaintingUtils.MAX_PRESS_GHOSTING_ALPHA = 0.8f;
                            GhostPaintingUtils.MIN_PRESS_GHOSTING_ALPHA = 0.6f;
                            GhostPaintingUtils.DECAY_FACTOR = 0.7f;
                        }));
                        popup.add(ghostDebugMode);
                        JMenuItem showCacheStats = new JMenuItem("Show cache stats");
                        showCacheStats.addActionListener(event -> SwingUtilities.invokeLater(() -> {
                            RadianceTextArea textArea = new RadianceTextArea();
                            List stats = LazyResettableHashMap.getStats();
                            if (stats != null) {
                                for (String stat : stats) {
                                    textArea.append(stat + "\n");
                                }
                            }
                            JDialog dialog = new JDialog(SwingUtilities.getWindowAncestor(RootPaneTitlePaneUiDebugger.this.jcomp), Dialog.ModalityType.APPLICATION_MODAL);
                            dialog.setTitle("Radiance cache stats");
                            dialog.setLayout(new BorderLayout());
                            dialog.add((Component)new JScrollPane((Component)textArea), "Center");
                            JButton dismiss = new JButton("Dismiss");
                            dismiss.addActionListener(actionEvent -> dialog.dispose());
                            JButton copyToClipboard = new JButton("Copy to clipboard");
                            copyToClipboard.addActionListener(arg_0 -> 1.lambda$process$15((JTextArea)textArea, arg_0));
                            JPanel controls = new JPanel(new FlowLayout(2));
                            controls.add(copyToClipboard);
                            controls.add(dismiss);
                            dialog.add((Component)controls, "South");
                            dialog.setSize(500, 400);
                            dialog.setLocationRelativeTo(((JRootPane)RootPaneTitlePaneUiDebugger.this.jcomp).getRootPane());
                            dialog.setVisible(true);
                        }));
                        popup.add(showCacheStats);
                        popup.show(RootPaneTitlePaneUiDebugger.this.titlePane, e.getX(), e.getY());
                    }

                    private static /* synthetic */ void lambda$process$15(JTextArea textArea, ActionEvent actionEvent) {
                        textArea.selectAll();
                        TransferHandler.getCopyAction().actionPerformed(new ActionEvent(textArea, 1001, "Copy"));
                    }
                };
                this.titlePane.addMouseListener(this.radianceDebugUiListener);
            }
        });
    }

    public void uninstallUI() {
        if (this.radianceDebugUiListener != null) {
            this.titlePane.removeMouseListener(this.radianceDebugUiListener);
            this.radianceDebugUiListener = null;
        }
    }

    private static class FocusKindChanger
    implements ActionListener {
        private RadianceThemingSlices.FocusKind newFocusKind;

        private FocusKindChanger(RadianceThemingSlices.FocusKind newFocusKind) {
            this.newFocusKind = newFocusKind;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(() -> RadianceThemingCortex.GlobalScope.setFocusKind((RadianceThemingSlices.FocusKind)this.newFocusKind));
        }
    }

    private static class AnimationChanger
    implements ActionListener {
        private long newAnimationDuration;

        private AnimationChanger(long newAnimationDuration) {
            this.newAnimationDuration = newAnimationDuration;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(() -> RadianceThemingCortex.GlobalScope.setTimelineDuration((long)this.newAnimationDuration));
        }
    }

    private static class SkinChanger
    implements ActionListener {
        private ColorSchemeTransform transform;
        private String name;

        private SkinChanger(ColorSchemeTransform transform, String name) {
            this.transform = transform;
            this.name = name;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(() -> {
                RadianceSkin newSkin = RadianceThemingCortex.GlobalScope.getCurrentSkin().transform(this.transform, this.name);
                RadianceThemingCortex.GlobalScope.setSkin((RadianceSkin)newSkin);
            });
        }
    }
}

