/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.tools.svgtranscoder.internal;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.batik.bridge.SVGPatternElementBridge;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.CompositeShapePainter;
import org.apache.batik.gvt.FillShapePainter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.Marker;
import org.apache.batik.gvt.MarkerShapePainter;
import org.apache.batik.gvt.PatternPaint;
import org.apache.batik.gvt.RasterImageNode;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.gvt.ShapePainter;
import org.apache.batik.gvt.StrokeShapePainter;
import org.pushingpixels.radiance.tools.svgtranscoder.api.LanguageRenderer;
import org.pushingpixels.radiance.tools.svgtranscoder.internal.graphics.McStableGraphics2D;

public class RasterScanner {
    private PrintWriter printWriter;
    private LanguageRenderer languageRenderer;
    private Set<String> processedMD5s = new HashSet<String>();

    public RasterScanner(PrintWriter printWriter, LanguageRenderer languageRenderer) {
        this.printWriter = printWriter;
        this.languageRenderer = languageRenderer;
    }

    public void scan(GraphicsNode gvtRoot) {
        this.scanGraphicsNode(gvtRoot);
    }

    public boolean hasRasters() {
        return !this.processedMD5s.isEmpty();
    }

    private void scanPatternPaint(PatternPaint paint) {
        SVGPatternElementBridge.PatternGraphicsNode pgn = (SVGPatternElementBridge.PatternGraphicsNode)paint.getGraphicsNode();
        pgn.primitivePaint((Graphics2D)new McStableGraphics2D(){

            @Override
            public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
                RasterScanner.this.transcodeRenderedImage((RenderedImage)((Object)img));
                return false;
            }
        });
    }

    private void scanPaint(Paint paint) throws UnsupportedOperationException {
        if (paint instanceof PatternPaint) {
            this.scanPatternPaint((PatternPaint)paint);
        }
    }

    private void scanShapePainter(ShapePainter painter) throws UnsupportedOperationException {
        if (painter == null) {
            return;
        }
        if (painter instanceof CompositeShapePainter) {
            this.scanCompositeShapePainter((CompositeShapePainter)painter);
            return;
        }
        if (painter instanceof FillShapePainter) {
            this.scanFillShapePainter((FillShapePainter)painter);
            return;
        }
        if (painter instanceof StrokeShapePainter) {
            this.scanStrokeShapePainter((StrokeShapePainter)painter);
            return;
        }
        if (painter instanceof MarkerShapePainter) {
            this.scanMarkerShapePainter((MarkerShapePainter)painter);
            return;
        }
        throw new UnsupportedOperationException(painter.getClass().getCanonicalName());
    }

    private void scanCompositeShapePainter(CompositeShapePainter painter) {
        for (int i = 0; i < painter.getShapePainterCount(); ++i) {
            this.scanShapePainter(painter.getShapePainter(i));
        }
    }

    private void scanFillShapePainter(FillShapePainter painter) {
        Paint paint = painter.getPaint();
        if (paint == null) {
            return;
        }
        this.scanPaint(paint);
    }

    private void scanStrokeShapePainter(StrokeShapePainter painter) {
        Paint paint = painter.getPaint();
        if (paint == null) {
            return;
        }
        this.scanPaint(paint);
    }

    private void scanMarkerShapePainter(MarkerShapePainter painter) {
        Marker end;
        Marker middle;
        Marker start = painter.getStartMarker();
        if (start != null) {
            this.scanGraphicsNode(start.getMarkerNode());
        }
        if ((middle = painter.getMiddleMarker()) != null) {
            this.scanGraphicsNode(middle.getMarkerNode());
        }
        if ((end = painter.getEndMarker()) != null) {
            this.scanGraphicsNode(end.getMarkerNode());
        }
    }

    private void scanShapeNode(ShapeNode node) {
        ShapePainter sPainter = node.getShapePainter();
        this.scanShapePainter(sPainter);
    }

    private void scanCompositeGraphicsNode(CompositeGraphicsNode node) {
        for (Object obj : node.getChildren()) {
            this.scanGraphicsNode((GraphicsNode)obj);
        }
    }

    private void transcodeRenderedImage(RenderedImage image) {
        String md5 = RasterScanner.getMD5(image);
        if (this.processedMD5s.contains(md5)) {
            return;
        }
        this.printWriter.println("private static WeakReference<BufferedImage> image" + md5 + ";");
        this.printWriter.println("private static BufferedImage getImage" + md5 + "() {");
        this.printWriter.println("    BufferedImage result = (image" + md5 + " != null)");
        this.printWriter.println("        ? image" + md5 + ".get() : null;");
        this.printWriter.println("    if (result != null) {");
        this.printWriter.println("        return result;");
        this.printWriter.println("    }");
        String encoded = RasterScanner.convertToBase64String(image);
        this.printWriter.println("    " + this.languageRenderer.startVariableDefinition("StringBuilder") + "imageData = " + this.languageRenderer.getObjectCreation("StringBuilder") + "(" + encoded.length() + ")" + this.languageRenderer.getStatementEnd());
        int imageDataStart = 0;
        do {
            int chunkLength = Math.min(1000, encoded.length() - imageDataStart);
            this.printWriter.println("    imageData.append(\"" + encoded.substring(imageDataStart, imageDataStart + chunkLength) + "\")" + this.languageRenderer.getStatementEnd());
        } while ((imageDataStart += 1000) <= encoded.length());
        this.printWriter.println("    try {");
        this.printWriter.println("        result = ImageIO.read(new ByteArrayInputStream(Base64.getDecoder().decode(imageData.toString())));");
        this.printWriter.println("        image" + md5 + " = new WeakReference<>(result);");
        this.printWriter.println("        return result;");
        this.printWriter.println("    } catch (IOException ioe) {");
        this.printWriter.println("    }");
        this.printWriter.println("    return null;");
        this.printWriter.println("}");
        this.processedMD5s.add(md5);
    }

    private void scanRasterImageNode(RasterImageNode node) {
        RenderedImage image = node.getImage().createDefaultRendering();
        this.transcodeRenderedImage(image);
    }

    private void scanGraphicsNode(GraphicsNode node) throws UnsupportedOperationException {
        if (node instanceof ShapeNode) {
            this.scanShapeNode((ShapeNode)node);
            return;
        }
        if (node instanceof CompositeGraphicsNode) {
            this.scanCompositeGraphicsNode((CompositeGraphicsNode)node);
            return;
        }
        if (node instanceof RasterImageNode) {
            this.scanRasterImageNode((RasterImageNode)node);
            return;
        }
    }

    private static String convertToBase64String(RenderedImage renderedImage) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write(renderedImage, "png", Base64.getEncoder().wrap(os));
            return os.toString(StandardCharsets.ISO_8859_1.name());
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public static String getMD5(RenderedImage renderedImage) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write(renderedImage, "png", Base64.getEncoder().wrap(os));
            MessageDigest md5Digest = MessageDigest.getInstance("MD5");
            md5Digest.update(os.toByteArray());
            byte[] digest = md5Digest.digest();
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < digest.length; ++i) {
                result.append(Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1));
            }
            return result.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

