/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.tools.svgtranscoder.api;

import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.pushingpixels.radiance.tools.svgtranscoder.api.LanguageRenderer;
import org.pushingpixels.radiance.tools.svgtranscoder.api.SvgTranscoder;
import org.pushingpixels.radiance.tools.svgtranscoder.api.TranscoderListener;

public abstract class SvgBatchBaseConverter {
    protected static final String CHECK_DOCUMENTATION = "Check the documentation for the parameters to pass";

    protected String getInputArgument(String[] args, String argumentName, String defaultValue) {
        for (String arg : args) {
            String[] split = arg.split("=");
            if (split.length != 2) {
                System.out.println("Argument '" + arg + "' unsupported");
                System.out.println(CHECK_DOCUMENTATION);
                System.exit(1);
            }
            if (split[0].compareTo(argumentName) != 0) continue;
            return split[1];
        }
        return defaultValue;
    }

    protected void transcodeAllFilesInFolder(File inputFolder, File outputFolder, String outputClassNamePrefix, String outputFileNameExtension, String outputPackageName, LanguageRenderer languageRenderer, String templateFile) {
        File[] svgFiles = inputFolder.listFiles((directory, name) -> name.endsWith(".svg"));
        if (svgFiles == null) {
            return;
        }
        for (File file : svgFiles) {
            String filename = file.getName();
            String svgClassName = (outputClassNamePrefix + filename.substring(0, filename.length() - 4)).replace('-', '_').replace(' ', '_');
            String classFilename = outputFolder.getAbsolutePath() + File.separator + svgClassName + outputFileNameExtension;
            System.out.println("Processing " + file.getAbsolutePath() + "\n\tto " + classFilename);
            try (final PrintWriter writer = new PrintWriter(classFilename);
                 InputStream templateStream = SvgBatchBaseConverter.class.getResourceAsStream(templateFile);){
                Objects.requireNonNull(templateStream, "Couldn't load " + templateFile);
                final CountDownLatch latch = new CountDownLatch(1);
                String uri = file.toURI().toURL().toString();
                SvgTranscoder transcoder = new SvgTranscoder(uri, svgClassName, languageRenderer);
                transcoder.setPackageName(outputPackageName);
                transcoder.setListener(new TranscoderListener(){

                    @Override
                    public Writer getWriter() {
                        return writer;
                    }

                    @Override
                    public void finished() {
                        latch.countDown();
                    }
                });
                transcoder.transcode(templateStream);
                latch.await(10L, TimeUnit.SECONDS);
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
        System.out.println();
    }
}

