/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.tools.svgtranscoder.api;

import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Objects;
import java.util.stream.Stream;
import org.pushingpixels.radiance.tools.svgtranscoder.api.LanguageRenderer;
import org.pushingpixels.radiance.tools.svgtranscoder.api.SvgBatchBaseConverter;
import org.pushingpixels.radiance.tools.svgtranscoder.api.java.JavaLanguageRenderer;
import org.pushingpixels.radiance.tools.svgtranscoder.api.kotlin.KotlinLanguageRenderer;

public class SvgDeepBatchConverter
extends SvgBatchBaseConverter {
    public static void main(String[] args) throws IOException {
        String outputFileNameExtension;
        LanguageRenderer languageRenderer;
        if (args.length < 4) {
            System.out.println("=== Usage ===");
            Stream.of("java " + SvgDeepBatchConverter.class.getCanonicalName(), "  sourceRootFolder=xyz - points to the root folder to traverse for SVG images", "  outputRootPackageName=xyz - the root package name for the transcoded classes", "  templateFile=xyz - the template file for creating the transcoded classes", "  outputLanguage=java|kotlin - the language for the transcoded classes", "  outputRootFolder=xyz - optional root location of output files. If not specified, output files will be placed under the 'sourceRootFolder'", "  outputClassNamePrefix=xyz - optional prefix for the class name of each transcoded class").forEach(System.out::println);
            System.out.println("Check the documentation for the parameters to pass");
            System.exit(1);
        }
        SvgDeepBatchConverter converter = new SvgDeepBatchConverter();
        String sourceRootFolderName = converter.getInputArgument(args, "sourceRootFolder", null);
        Objects.requireNonNull(sourceRootFolderName, "Missing source folder. Check the documentation for the parameters to pass");
        String outputRootPackageName = converter.getInputArgument(args, "outputRootPackageName", null);
        Objects.requireNonNull(outputRootPackageName, "Missing output package name. Check the documentation for the parameters to pass");
        String templateFile = converter.getInputArgument(args, "templateFile", null);
        Objects.requireNonNull(templateFile, "Missing template file. Check the documentation for the parameters to pass");
        String outputLanguage = converter.getInputArgument(args, "outputLanguage", null);
        Objects.requireNonNull(outputLanguage, "Missing output language. Check the documentation for the parameters to pass");
        if ("java".equals(outputLanguage)) {
            languageRenderer = new JavaLanguageRenderer();
            outputFileNameExtension = ".java";
        } else if ("kotlin".equals(outputLanguage)) {
            languageRenderer = new KotlinLanguageRenderer();
            outputFileNameExtension = ".kt";
        } else {
            throw new IllegalArgumentException("Output language must be either Java or Kotlin. Check the documentation for the parameters to pass");
        }
        String outputClassNamePrefix = converter.getInputArgument(args, "outputClassNamePrefix", "");
        String outputRootFolderName = converter.getInputArgument(args, "outputRootFolder", sourceRootFolderName);
        File inputRootFolder = new File(sourceRootFolderName);
        if (!inputRootFolder.exists()) {
            throw new NoSuchFileException(sourceRootFolderName);
        }
        File outputRootFolder = new File(outputRootFolderName);
        if (!outputRootFolder.exists()) {
            throw new NoSuchFileException(outputRootFolderName);
        }
        System.out.println("******************************************************************************");
        System.out.println("Processing");
        System.out.println("\tsource root folder: " + sourceRootFolderName);
        System.out.println("\troot package name: " + outputRootPackageName);
        System.out.println("\toutput language: " + outputLanguage);
        System.out.println("******************************************************************************");
        System.out.println();
        converter.processFolder(inputRootFolder, outputRootFolder, outputClassNamePrefix, outputFileNameExtension, outputRootPackageName, languageRenderer, templateFile);
    }

    protected void processFolder(File inputFolder, File outputFolder, String outputClassNamePrefix, String outputFileNameExtension, String outputPackageName, LanguageRenderer languageRenderer, String templateFile) {
        System.out.println("******************************************************************************");
        System.out.println("Processing");
        System.out.println("\tsource folder: " + inputFolder.getAbsolutePath());
        System.out.println("\tpackage name: " + outputPackageName);
        System.out.println("******************************************************************************");
        this.transcodeAllFilesInFolder(inputFolder, outputFolder, outputClassNamePrefix, outputFileNameExtension, outputPackageName, languageRenderer, templateFile);
        for (File inputSubfolder : inputFolder.listFiles((directory, name) -> new File(directory, name).isDirectory())) {
            String subfolderName = inputSubfolder.getName();
            System.out.println("Going into sub-folder " + subfolderName);
            File outputSubfolder = new File(outputFolder, subfolderName);
            if (!outputSubfolder.exists()) {
                outputSubfolder.mkdir();
            }
            this.processFolder(inputSubfolder, outputSubfolder, outputClassNamePrefix, outputFileNameExtension, outputPackageName + "." + subfolderName, languageRenderer, templateFile);
        }
        System.out.println();
    }
}

