/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.tools.svgtranscoder.api;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.batik.bridge.SVGPatternElementBridge;
import org.apache.batik.bridge.TextNode;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.RadialGradientPaint;
import org.apache.batik.ext.awt.geom.ExtendedGeneralPath;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.CompositeShapePainter;
import org.apache.batik.gvt.FillShapePainter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.Marker;
import org.apache.batik.gvt.MarkerShapePainter;
import org.apache.batik.gvt.PatternPaint;
import org.apache.batik.gvt.RasterImageNode;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.gvt.ShapePainter;
import org.apache.batik.gvt.StrokeShapePainter;
import org.pushingpixels.radiance.tools.svgtranscoder.api.LanguageRenderer;
import org.pushingpixels.radiance.tools.svgtranscoder.api.TranscoderListener;
import org.pushingpixels.radiance.tools.svgtranscoder.internal.RasterScanner;
import org.pushingpixels.radiance.tools.svgtranscoder.internal.graphics.McCrashyGraphics2D;

abstract class SvgBaseTranscoder {
    protected TranscoderListener listener;
    protected PrintWriter externalPrintWriter;
    private PrintWriterManager printWriterManager;
    private LanguageRenderer languageRenderer;
    private String classname;
    private String packageName;
    private boolean hasRasters = false;
    private static final String TOKEN_PACKAGE = "TOKEN_PACKAGE";
    private static final String TOKEN_CLASSNAME = "TOKEN_CLASSNAME";
    private static final String TOKEN_RASTER_CODE = "TOKEN_RASTER_CODE";
    private static final String TOKEN_SET_COLOR_FILTER = "TOKEN_SET_COLOR_FILTER";
    private static final String TOKEN_SUPPORTS_COLOR_FILTER = "TOKEN_SUPPORTS_COLOR_FILTER";
    private static final String TOKEN_PAINTING_CODE = "TOKEN_PAINTING_CODE";
    private static final String TOKEN_PAINTING_INVOCATIONS = "TOKEN_PAINTING_INVOCATIONS";
    private static final String TOKEN_ORIG_X = "TOKEN_ORIG_X";
    private static final String TOKEN_ORIG_Y = "TOKEN_ORIG_Y";
    private static final String TOKEN_ORIG_WIDTH = "TOKEN_ORIG_WIDTH";
    private static final String TOKEN_ORIG_HEIGHT = "TOKEN_ORIG_HEIGHT";

    public SvgBaseTranscoder(String classname, LanguageRenderer languageRenderer) {
        this.classname = classname;
        this.languageRenderer = languageRenderer;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setListener(TranscoderListener listener) {
        this.listener = listener;
        this.setPrintWriter(new PrintWriter(this.listener.getWriter()));
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.externalPrintWriter = printWriter;
    }

    public void transcode(GraphicsNode gvtRoot, InputStream templateStream) {
        StringBuffer templateBuffer = new StringBuffer();
        BufferedReader templateReader = new BufferedReader(new InputStreamReader(templateStream));
        try {
            String line;
            while ((line = templateReader.readLine()) != null) {
                templateBuffer.append(line + "\n");
            }
            templateReader.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        String templateString = templateBuffer.toString();
        templateString = this.packageName != null ? templateString.replaceAll(TOKEN_PACKAGE, "package " + this.packageName + this.languageRenderer.getStatementEnd()) : templateString.replaceAll(TOKEN_PACKAGE, "");
        templateString = templateString.replaceAll(TOKEN_CLASSNAME, this.classname);
        ByteArrayOutputStream rasterCodeStream = new ByteArrayOutputStream();
        PrintWriter rasterPrintWriter = new PrintWriter(rasterCodeStream);
        RasterScanner rasterScanner = new RasterScanner(rasterPrintWriter, this.languageRenderer);
        rasterScanner.scan(gvtRoot);
        rasterPrintWriter.close();
        String rasterCode = new String(rasterCodeStream.toByteArray());
        templateString = templateString.replaceAll(TOKEN_RASTER_CODE, rasterCode);
        this.hasRasters = rasterScanner.hasRasters();
        String setColorFilter = this.hasRasters ? "throw " + this.languageRenderer.getObjectCreation("UnsupportedOperationException") + "(\"Color filters on raster content not supported\")" : "this.colorFilter = colorFilter";
        templateString = templateString.replace(TOKEN_SET_COLOR_FILTER, setColorFilter + this.languageRenderer.getStatementEnd());
        templateString = templateString.replace(TOKEN_SUPPORTS_COLOR_FILTER, this.hasRasters ? "false" : "true");
        this.printWriterManager = new PrintWriterManager();
        this.transcodeGraphicsNode(gvtRoot, "");
        this.printWriterManager.close();
        List<ByteArrayOutputStream> paintingCodeStreams = this.printWriterManager.getStreamList();
        int streamCount = paintingCodeStreams.size();
        StringBuffer combinedPaintingCode = new StringBuffer();
        for (int i = 0; i < streamCount; ++i) {
            ByteArrayOutputStream currentPaintingCodeStream = paintingCodeStreams.get(i);
            String paintingCode = new String(currentPaintingCodeStream.toByteArray());
            String paintingCodeMethod = this.languageRenderer.startMethod("_paint" + i, new LanguageRenderer.MethodArgument("g", "Graphics2D"), new LanguageRenderer.MethodArgument("origAlpha", this.languageRenderer.getPrimitiveTypeFor(Float.TYPE))) + "\n" + paintingCode + "\n" + this.languageRenderer.endMethod();
            combinedPaintingCode.append(paintingCodeMethod);
            combinedPaintingCode.append("\n\n");
        }
        templateString = templateString.replaceAll(TOKEN_PAINTING_CODE, combinedPaintingCode.toString());
        StringBuffer combinedPaintingInvocations = new StringBuffer();
        for (int i = 0; i < streamCount; ++i) {
            combinedPaintingInvocations.append("_paint" + i + "(g, origAlpha)" + this.languageRenderer.getStatementEnd() + "\n");
        }
        templateString = templateString.replaceAll(TOKEN_PAINTING_INVOCATIONS, combinedPaintingInvocations.toString());
        Rectangle2D bounds = gvtRoot.getBounds();
        templateString = templateString.replaceAll(TOKEN_ORIG_X, "" + bounds.getX());
        templateString = templateString.replaceAll(TOKEN_ORIG_Y, "" + bounds.getY());
        templateString = templateString.replaceAll(TOKEN_ORIG_WIDTH, "" + bounds.getWidth());
        templateString = templateString.replaceAll(TOKEN_ORIG_HEIGHT, "" + bounds.getHeight());
        this.externalPrintWriter.println(templateString);
        this.externalPrintWriter.close();
        if (this.listener != null) {
            this.listener.finished();
        }
    }

    private void transcodePathIterator(PathIterator pathIterator, String suffix) {
        float[] coords = new float[6];
        this.printWriterManager.println("if (generalPath" + suffix + " == null) {");
        this.printWriterManager.println("   generalPath" + suffix + " = " + this.languageRenderer.getObjectCreationNoParams("GeneralPath") + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("} else {");
        this.printWriterManager.println("   " + this.languageRenderer.getObjectNoNull("generalPath" + suffix) + ".reset()" + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("}");
        while (!pathIterator.isDone()) {
            this.printWriterManager.checkin();
            int type = pathIterator.currentSegment(coords);
            switch (type) {
                case 3: {
                    this.printWriterManager.println(this.languageRenderer.getObjectNoNull("generalPath" + suffix) + ".curveTo(" + coords[0] + "f, " + coords[1] + "f, " + coords[2] + "f, " + coords[3] + "f, " + coords[4] + "f, " + coords[5] + "f)" + this.languageRenderer.getStatementEnd());
                    break;
                }
                case 2: {
                    this.printWriterManager.println(this.languageRenderer.getObjectNoNull("generalPath" + suffix) + ".quadTo(" + coords[0] + "f, " + coords[1] + "f, " + coords[2] + "f, " + coords[3] + "f)" + this.languageRenderer.getStatementEnd());
                    break;
                }
                case 0: {
                    this.printWriterManager.println(this.languageRenderer.getObjectNoNull("generalPath" + suffix) + ".moveTo(" + coords[0] + "f, " + coords[1] + "f)" + this.languageRenderer.getStatementEnd());
                    break;
                }
                case 1: {
                    this.printWriterManager.println(this.languageRenderer.getObjectNoNull("generalPath" + suffix) + ".lineTo(" + coords[0] + "f, " + coords[1] + "f)" + this.languageRenderer.getStatementEnd());
                    break;
                }
                case 4: {
                    this.printWriterManager.println(this.languageRenderer.getObjectNoNull("generalPath" + suffix) + ".closePath()" + this.languageRenderer.getStatementEnd());
                }
            }
            pathIterator.next();
        }
        this.printWriterManager.println("shape" + suffix + " = generalPath" + this.languageRenderer.getStatementEnd());
    }

    private void transcodeShape(Shape shape, String suffix) throws UnsupportedOperationException {
        if (shape instanceof ExtendedGeneralPath) {
            this.transcodePathIterator(shape.getPathIterator(null), suffix);
            return;
        }
        if (shape instanceof GeneralPath) {
            this.transcodePathIterator(shape.getPathIterator(null), suffix);
            return;
        }
        if (shape instanceof Rectangle2D) {
            Rectangle2D rect = (Rectangle2D)shape;
            this.printWriterManager.println("shape" + suffix + " = " + this.languageRenderer.getObjectCreation("Rectangle2D.Double") + "(" + rect.getX() + ", " + rect.getY() + ", " + rect.getWidth() + ", " + rect.getHeight() + ")" + this.languageRenderer.getStatementEnd());
            return;
        }
        if (shape instanceof RoundRectangle2D) {
            RoundRectangle2D rRect = (RoundRectangle2D)shape;
            this.printWriterManager.println("shape" + suffix + " = " + this.languageRenderer.getObjectCreation("RoundRectangle2D.Double") + "(" + rRect.getX() + ", " + rRect.getY() + ", " + rRect.getWidth() + ", " + rRect.getHeight() + ", " + rRect.getArcWidth() + ", " + rRect.getArcHeight() + ")" + this.languageRenderer.getStatementEnd());
            return;
        }
        if (shape instanceof Ellipse2D) {
            Ellipse2D ell = (Ellipse2D)shape;
            this.printWriterManager.println("shape" + suffix + " = " + this.languageRenderer.getObjectCreation("Ellipse2D.Double") + "(" + ell.getX() + ", " + ell.getY() + ", " + ell.getWidth() + ", " + ell.getHeight() + ")" + this.languageRenderer.getStatementEnd());
            return;
        }
        if (shape instanceof Line2D) {
            Line2D l2df = (Line2D)shape;
            this.printWriterManager.print("shape" + suffix + " = " + this.languageRenderer.getObjectCreation("Line2D.Float"));
            this.printWriterManager.format("(%ff,%ff,%ff,%ff)", Float.valueOf((float)l2df.getX1()), Float.valueOf((float)l2df.getY1()), Float.valueOf((float)l2df.getX2()), Float.valueOf((float)l2df.getY2()));
            this.printWriterManager.println(this.languageRenderer.getStatementEnd());
            return;
        }
        throw new UnsupportedOperationException(shape.getClass().getCanonicalName());
    }

    private void transcodeLinearGradientPaint(LinearGradientPaint paint) throws IllegalArgumentException {
        Point2D startPoint = paint.getStartPoint();
        Point2D endPoint = paint.getEndPoint();
        float[] fractions = paint.getFractions();
        Color[] colors = paint.getColors();
        MultipleGradientPaint.CycleMethodEnum cycleMethod = paint.getCycleMethod();
        MultipleGradientPaint.ColorSpaceEnum colorSpace = paint.getColorSpace();
        AffineTransform transform = paint.getTransform();
        float previousFraction = -1.0f;
        for (float currentFraction : fractions) {
            if (currentFraction < 0.0f || currentFraction > 1.0f) {
                throw new IllegalArgumentException("Fraction values must be in the range 0 to 1: " + currentFraction);
            }
            if (currentFraction < previousFraction) {
                throw new IllegalArgumentException("Keyframe fractions must be non-decreasing: " + currentFraction);
            }
            previousFraction = currentFraction;
        }
        StringBuffer fractionsRep = new StringBuffer();
        if (fractions == null) {
            fractionsRep.append("null");
        } else {
            String sep = "";
            fractionsRep.append(this.languageRenderer.startPrimitiveArrayOf("float"));
            previousFraction = -1.0f;
            for (float currentFraction : fractions) {
                fractionsRep.append(sep);
                if (currentFraction == previousFraction) {
                    currentFraction += 1.0E-9f;
                }
                fractionsRep.append(currentFraction + "f");
                sep = ",";
                previousFraction = currentFraction;
            }
            fractionsRep.append(this.languageRenderer.endArray());
        }
        StringBuffer colorsRep = new StringBuffer();
        if (fractions == null) {
            colorsRep.append("null");
        } else {
            String sep = "";
            colorsRep.append(this.languageRenderer.startGenericArrayOf("Color"));
            for (Color color : colors) {
                colorsRep.append(sep);
                String colorParameter = this.languageRenderer.getObjectCreation("Color") + "(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ", " + color.getAlpha() + ")";
                colorsRep.append("(" + this.languageRenderer.getNullableInvocation("colorFilter", "filter", colorParameter) + ")");
                sep = ",";
            }
            colorsRep.append(this.languageRenderer.endArray());
        }
        String cycleMethodRep = null;
        if (cycleMethod == MultipleGradientPaint.NO_CYCLE) {
            cycleMethodRep = "MultipleGradientPaint.CycleMethod.NO_CYCLE";
        }
        if (cycleMethod == MultipleGradientPaint.REFLECT) {
            cycleMethodRep = "MultipleGradientPaint.CycleMethod.REFLECT";
        }
        if (cycleMethod == MultipleGradientPaint.REPEAT) {
            cycleMethodRep = "MultipleGradientPaint.CycleMethod.REPEAT";
        }
        String colorSpaceRep = null;
        if (colorSpace == MultipleGradientPaint.SRGB) {
            colorSpaceRep = "MultipleGradientPaint.ColorSpaceType.SRGB";
        }
        if (colorSpace == MultipleGradientPaint.LINEAR_RGB) {
            colorSpaceRep = "MultipleGradientPaint.ColorSpaceType.LINEAR_RGB";
        }
        double[] transfMatrix = new double[6];
        transform.getMatrix(transfMatrix);
        this.printWriterManager.println("paint = " + this.languageRenderer.getObjectCreation("LinearGradientPaint") + "(" + this.languageRenderer.getObjectCreation("Point2D.Double") + "(" + startPoint.getX() + ", " + startPoint.getY() + "), " + this.languageRenderer.getObjectCreation("Point2D.Double") + "(" + endPoint.getX() + ", " + endPoint.getY() + "), " + fractionsRep.toString() + ", " + colorsRep.toString() + ", " + cycleMethodRep + ", " + colorSpaceRep + ", " + this.languageRenderer.getObjectCreation("AffineTransform") + "(" + transfMatrix[0] + "f, " + transfMatrix[1] + "f, " + transfMatrix[2] + "f, " + transfMatrix[3] + "f, " + transfMatrix[4] + "f, " + transfMatrix[5] + "f))" + this.languageRenderer.getStatementEnd());
    }

    private void transcodePatternPaint(PatternPaint paint) {
        AffineTransform transform = paint.getPatternTransform();
        transform.concatenate(paint.getGraphicsNode().getTransform());
        this.printWriterManager.println("clip = g" + this.languageRenderer.getGetter("clip") + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("g.clip(shape)" + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("{");
        Rectangle2D rect2D = paint.getGraphicsNode().getBounds();
        this.printWriterManager.println("    " + this.languageRenderer.startVariableDefinition("Rectangle2D") + "rect2D = " + this.languageRenderer.getObjectCreation("Rectangle2D.Double") + "(" + rect2D.getX() + ", " + rect2D.getY() + ", " + rect2D.getWidth() + ", " + rect2D.getHeight() + ")" + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("    " + this.languageRenderer.startVariableDefinition("Graphics2D") + "gTiled = " + this.languageRenderer.getObjectCast("g.create()", "Graphics2D") + this.languageRenderer.getStatementEnd());
        double[] transfMatrix = new double[6];
        transform.getMatrix(transfMatrix);
        this.printWriterManager.println("    " + this.languageRenderer.startVariableDefinition("AffineTransform") + "tTiled = " + this.languageRenderer.getObjectCreation("AffineTransform") + "(" + transfMatrix[0] + "f, " + transfMatrix[1] + "f, " + transfMatrix[2] + "f, " + transfMatrix[3] + "f, " + transfMatrix[4] + "f, " + transfMatrix[5] + "f)" + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("    gTiled.transform(tTiled)" + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("    " + this.languageRenderer.startVariableDefinition("Point2D") + "src = " + this.languageRenderer.getObjectCreation("Point2D.Double") + "(0, 0)" + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("    " + this.languageRenderer.startVariableDefinition("Point2D") + "dst = " + this.languageRenderer.getObjectCreation("Point2D.Double") + "(0, 0)" + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("    " + this.languageRenderer.startVariableDefinition("double") + "startX = rect2D.getX()" + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("    while (true) {");
        this.printWriterManager.println("        " + this.languageRenderer.startVariableDefinition("double") + "startY = rect2D.getY()" + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("        while (true) {");
        this.printWriterManager.println("            gTiled.translate(startX, startY)" + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("            " + this.languageRenderer.startVariableDefinition("Shape") + "shapeTile = null" + this.languageRenderer.getStatementEnd());
        SVGPatternElementBridge.PatternGraphicsNode pgn = (SVGPatternElementBridge.PatternGraphicsNode)paint.getGraphicsNode();
        pgn.primitivePaint((Graphics2D)new McCrashyGraphics2D(){
            private Shape clip;
            private RenderingHints hints = new RenderingHints(new HashMap());
            private AffineTransform transform = new AffineTransform();
            private Composite composite;

            @Override
            public Graphics create() {
                return this;
            }

            @Override
            public void dispose() {
            }

            @Override
            public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
                SvgBaseTranscoder.this.transcodeRenderedImage((RenderedImage)((Object)img), "gTiled");
                return false;
            }

            @Override
            public void draw(Shape shape) {
                SvgBaseTranscoder.this.transcodeShape(shape, "Tile");
                SvgBaseTranscoder.this.printWriterManager.println("gTiled.draw(shapeTile);");
            }

            @Override
            public void fill(Shape shape) {
                SvgBaseTranscoder.this.transcodeShape(shape, "Tile");
                SvgBaseTranscoder.this.printWriterManager.println("gTiled.fill(shapeTile);");
            }

            @Override
            public void setComposite(Composite composite) {
                this.composite = composite;
                int rule = ((AlphaComposite)composite).getRule();
                float alpha = ((AlphaComposite)composite).getAlpha();
                SvgBaseTranscoder.this.printWriterManager.println("gTiled" + SvgBaseTranscoder.this.languageRenderer.startSetterAssignment("composite") + "AlphaComposite.getInstance(" + rule + ", " + alpha + "f * origAlpha)" + SvgBaseTranscoder.this.languageRenderer.endSetterAssignment() + SvgBaseTranscoder.this.languageRenderer.getStatementEnd());
            }

            @Override
            public void setPaint(Paint paint) {
                SvgBaseTranscoder.this.transcodePaint(paint);
                SvgBaseTranscoder.this.printWriterManager.println("gTiled" + SvgBaseTranscoder.this.languageRenderer.startSetterAssignment("paint") + "paint" + SvgBaseTranscoder.this.languageRenderer.endSetterAssignment() + SvgBaseTranscoder.this.languageRenderer.getStatementEnd());
            }

            @Override
            public void setStroke(Stroke stroke) {
                float strokeWidth = ((BasicStroke)stroke).getLineWidth();
                int endCap = ((BasicStroke)stroke).getEndCap();
                int lineJoin = ((BasicStroke)stroke).getLineJoin();
                float miterLimit = ((BasicStroke)stroke).getMiterLimit();
                float[] dash = ((BasicStroke)stroke).getDashArray();
                float dash_phase = ((BasicStroke)stroke).getDashPhase();
                StringBuffer dashRep = new StringBuffer();
                if (dash == null) {
                    dashRep.append("null");
                } else {
                    String sep = "";
                    dashRep.append(SvgBaseTranscoder.this.languageRenderer.startPrimitiveArrayOf("float"));
                    for (float _dash : dash) {
                        dashRep.append(sep);
                        dashRep.append(_dash + "f");
                        sep = ",";
                    }
                    dashRep.append("}");
                }
                SvgBaseTranscoder.this.printWriterManager.println("gTiled" + SvgBaseTranscoder.this.languageRenderer.startSetterAssignment("stroke") + SvgBaseTranscoder.this.languageRenderer.getObjectCreation("BasicStroke") + "(" + strokeWidth + "f," + endCap + "," + lineJoin + "," + miterLimit + "f," + dashRep + "," + dash_phase + "f)" + SvgBaseTranscoder.this.languageRenderer.endSetterAssignment() + SvgBaseTranscoder.this.languageRenderer.getStatementEnd());
            }

            @Override
            public Shape getClip() {
                return this.clip;
            }

            @Override
            public void setClip(Shape clip) {
                this.clip = clip;
            }

            @Override
            public void setClip(int x, int y, int width, int height) {
                this.clip = new Rectangle2D.Double(x, y, width, height);
            }

            @Override
            public void clip(Shape s) {
                if (this.clip == null) {
                    this.clip = s;
                } else {
                    Area current = new Area(this.clip);
                    Area requested = new Area(s);
                    current.intersect(requested);
                    this.clip = current;
                }
            }

            @Override
            public void clipRect(int x, int y, int width, int height) {
                this.clip(new Rectangle2D.Double(x, y, width, height));
            }

            @Override
            public void setRenderingHints(Map<?, ?> hints) {
                this.hints.clear();
                this.hints.putAll(hints);
            }

            @Override
            public void addRenderingHints(Map<?, ?> hints) {
                this.hints.putAll(hints);
            }

            @Override
            public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
                this.hints.put(hintKey, hintValue);
            }

            @Override
            public Object getRenderingHint(RenderingHints.Key key) {
                return this.hints.get(key);
            }

            @Override
            public RenderingHints getRenderingHints() {
                return this.hints;
            }

            @Override
            public void setTransform(AffineTransform transform) {
                this.transform = transform;
            }

            @Override
            public void transform(AffineTransform Tx) {
                this.transform.concatenate(Tx);
            }

            @Override
            public void translate(int x, int y) {
                this.transform.translate(x, y);
            }

            @Override
            public void translate(double tx, double ty) {
                this.transform.translate(tx, ty);
            }

            @Override
            public void rotate(double theta) {
                this.transform.rotate(theta);
            }

            @Override
            public void rotate(double theta, double x, double y) {
                this.transform.rotate(theta, x, y);
            }

            @Override
            public AffineTransform getTransform() {
                return this.transform;
            }

            @Override
            public Composite getComposite() {
                return this.composite;
            }

            @Override
            public GraphicsConfiguration getDeviceConfiguration() {
                return null;
            }
        });
        this.printWriterManager.println("            gTiled.translate(-startX, -startY)" + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("            startY += rect2D.getHeight()" + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("            src.setLocation(startX, startY)" + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("            tTiled.transform(src, dst)" + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("            if (dst.getY() > shape.getBounds().getMaxY()) {");
        this.printWriterManager.println("                break" + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("            }");
        this.printWriterManager.println("        }");
        this.printWriterManager.println("        startX += rect2D.getWidth()" + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("        src.setLocation(startX, startY)" + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("        tTiled.transform(src, dst)" + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("        if (dst.getX() > shape.getBounds().getMaxX()) {");
        this.printWriterManager.println("            break" + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("        }");
        this.printWriterManager.println("    }");
        this.printWriterManager.println("    gTiled.dispose()" + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("}");
        this.printWriterManager.println("g.setClip(clip)" + this.languageRenderer.getStatementEnd());
    }

    private void transcodeRadialGradientPaint(RadialGradientPaint paint) throws IllegalArgumentException {
        Point2D centerPoint = paint.getCenterPoint();
        float radius = paint.getRadius();
        Point2D focusPoint = paint.getFocusPoint();
        float[] fractions = paint.getFractions();
        Color[] colors = paint.getColors();
        MultipleGradientPaint.CycleMethodEnum cycleMethod = paint.getCycleMethod();
        MultipleGradientPaint.ColorSpaceEnum colorSpace = paint.getColorSpace();
        AffineTransform transform = paint.getTransform();
        float previousFraction = -1.0f;
        for (float currentFraction : fractions) {
            if (currentFraction < 0.0f || currentFraction > 1.0f) {
                throw new IllegalArgumentException("Fraction values must be in the range 0 to 1: " + currentFraction);
            }
            if (currentFraction < previousFraction) {
                throw new IllegalArgumentException("Keyframe fractions must be non-decreasing: " + currentFraction);
            }
            previousFraction = currentFraction;
        }
        StringBuffer fractionsRep = new StringBuffer();
        if (fractions == null) {
            fractionsRep.append("null");
        } else {
            String sep = "";
            fractionsRep.append(this.languageRenderer.startPrimitiveArrayOf("float"));
            previousFraction = -1.0f;
            for (float currentFraction : fractions) {
                fractionsRep.append(sep);
                if (currentFraction == previousFraction) {
                    currentFraction += 1.0E-9f;
                }
                fractionsRep.append(currentFraction + "f");
                sep = ",";
                previousFraction = currentFraction;
            }
            fractionsRep.append(this.languageRenderer.endArray());
        }
        StringBuffer colorsRep = new StringBuffer();
        if (fractions == null) {
            colorsRep.append("null");
        } else {
            String sep = "";
            colorsRep.append(this.languageRenderer.startGenericArrayOf("Color"));
            for (Color color : colors) {
                colorsRep.append(sep);
                String colorParameter = this.languageRenderer.getObjectCreation("Color") + "(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ", " + color.getAlpha() + ")";
                colorsRep.append("(" + this.languageRenderer.getNullableInvocation("colorFilter", "filter", colorParameter) + ")");
                sep = ",";
            }
            colorsRep.append(this.languageRenderer.endArray());
        }
        String cycleMethodRep = null;
        if (cycleMethod == MultipleGradientPaint.NO_CYCLE) {
            cycleMethodRep = "MultipleGradientPaint.CycleMethod.NO_CYCLE";
        }
        if (cycleMethod == MultipleGradientPaint.REFLECT) {
            cycleMethodRep = "MultipleGradientPaint.CycleMethod.REFLECT";
        }
        if (cycleMethod == MultipleGradientPaint.REPEAT) {
            cycleMethodRep = "MultipleGradientPaint.CycleMethod.REPEAT";
        }
        String colorSpaceRep = null;
        if (colorSpace == MultipleGradientPaint.SRGB) {
            colorSpaceRep = "MultipleGradientPaint.ColorSpaceType.SRGB";
        }
        if (colorSpace == MultipleGradientPaint.LINEAR_RGB) {
            colorSpaceRep = "MultipleGradientPaint.ColorSpaceType.LINEAR_RGB";
        }
        double[] transfMatrix = new double[6];
        transform.getMatrix(transfMatrix);
        this.printWriterManager.println("paint = " + this.languageRenderer.getObjectCreation("RadialGradientPaint") + "(" + this.languageRenderer.getObjectCreation("Point2D.Double") + "(" + centerPoint.getX() + ", " + centerPoint.getY() + "), " + radius + "f, " + this.languageRenderer.getObjectCreation("Point2D.Double") + "(" + focusPoint.getX() + ", " + focusPoint.getY() + "), " + fractionsRep.toString() + ", " + colorsRep.toString() + ", " + cycleMethodRep + ", " + colorSpaceRep + ", " + this.languageRenderer.getObjectCreation("AffineTransform") + "(" + transfMatrix[0] + "f, " + transfMatrix[1] + "f, " + transfMatrix[2] + "f, " + transfMatrix[3] + "f, " + transfMatrix[4] + "f, " + transfMatrix[5] + "f))" + this.languageRenderer.getStatementEnd());
    }

    private void transcodePaint(Paint paint) throws UnsupportedOperationException {
        if (paint instanceof PatternPaint) {
            this.transcodePatternPaint((PatternPaint)paint);
            return;
        }
        if (paint instanceof RadialGradientPaint) {
            this.transcodeRadialGradientPaint((RadialGradientPaint)paint);
            return;
        }
        if (paint instanceof LinearGradientPaint) {
            this.transcodeLinearGradientPaint((LinearGradientPaint)paint);
            return;
        }
        if (paint instanceof Color) {
            Color c = (Color)paint;
            String colorParameter = this.languageRenderer.getObjectCreation("Color") + "(" + c.getRed() + ", " + c.getGreen() + ", " + c.getBlue() + ", " + c.getAlpha() + ")";
            this.printWriterManager.println("paint = " + this.languageRenderer.getNullableInvocation("colorFilter", "filter", colorParameter) + this.languageRenderer.getStatementEnd());
            return;
        }
        if (paint == null) {
            this.printWriterManager.println("No paint");
            return;
        }
        throw new UnsupportedOperationException(paint.getClass().getCanonicalName());
    }

    private void transcodePaintAndFill(Paint paint) throws UnsupportedOperationException {
        if (paint instanceof PatternPaint) {
            this.transcodePatternPaint((PatternPaint)paint);
            return;
        }
        if (paint instanceof RadialGradientPaint) {
            this.transcodeRadialGradientPaint((RadialGradientPaint)paint);
            this.printWriterManager.println("g" + this.languageRenderer.startSetterAssignment("paint") + "paint" + this.languageRenderer.endSetterAssignment() + this.languageRenderer.getStatementEnd());
            this.printWriterManager.println("g.fill(shape)" + this.languageRenderer.getStatementEnd());
            return;
        }
        if (paint instanceof LinearGradientPaint) {
            this.transcodeLinearGradientPaint((LinearGradientPaint)paint);
            this.printWriterManager.println("g" + this.languageRenderer.startSetterAssignment("paint") + "paint" + this.languageRenderer.endSetterAssignment() + this.languageRenderer.getStatementEnd());
            this.printWriterManager.println("g.fill(shape)" + this.languageRenderer.getStatementEnd());
            return;
        }
        if (paint instanceof Color) {
            Color c = (Color)paint;
            String colorParameter = this.languageRenderer.getObjectCreation("Color") + "(" + c.getRed() + ", " + c.getGreen() + ", " + c.getBlue() + ", " + c.getAlpha() + ")";
            this.printWriterManager.println("paint = " + this.languageRenderer.getNullableInvocation("colorFilter", "filter", colorParameter) + this.languageRenderer.getStatementEnd());
            this.printWriterManager.println("g" + this.languageRenderer.startSetterAssignment("paint") + "paint" + this.languageRenderer.endSetterAssignment() + this.languageRenderer.getStatementEnd());
            this.printWriterManager.println("g.fill(shape)" + this.languageRenderer.getStatementEnd());
            return;
        }
        if (paint == null) {
            throw new UnsupportedOperationException("No paint");
        }
        throw new UnsupportedOperationException(paint.getClass().getCanonicalName());
    }

    private void transcodeShapePainter(ShapePainter painter, Shape shape, String comment) throws UnsupportedOperationException {
        if (painter == null) {
            return;
        }
        if (painter instanceof CompositeShapePainter) {
            this.transcodeCompositeShapePainter((CompositeShapePainter)painter, shape, comment);
            return;
        }
        if (painter instanceof FillShapePainter) {
            this.transcodeFillShapePainter((FillShapePainter)painter);
            return;
        }
        if (painter instanceof StrokeShapePainter) {
            this.transcodeStrokeShapePainter((StrokeShapePainter)painter);
            return;
        }
        if (painter instanceof MarkerShapePainter) {
            this.transcodeMarkerShapePainter((MarkerShapePainter)painter, shape, comment);
            return;
        }
        throw new UnsupportedOperationException(painter.getClass().getCanonicalName());
    }

    private void transcodeCompositeShapePainter(CompositeShapePainter painter, Shape shape, String comment) {
        for (int i = 0; i < painter.getShapePainterCount(); ++i) {
            this.transcodeShapePainter(painter.getShapePainter(i), shape, comment);
        }
    }

    private void transcodeFillShapePainter(FillShapePainter painter) {
        Paint paint = painter.getPaint();
        if (paint == null) {
            return;
        }
        this.transcodeShape(painter.getShape(), "");
        this.transcodePaintAndFill(paint);
    }

    private void transcodeStrokeShapePainter(StrokeShapePainter painter) {
        Shape shape = painter.getShape();
        Paint paint = painter.getPaint();
        if (paint == null) {
            return;
        }
        this.transcodePaint(paint);
        Stroke stroke = painter.getStroke();
        BasicStroke bStroke = (BasicStroke)stroke;
        float width = bStroke.getLineWidth();
        int cap = bStroke.getEndCap();
        int join = bStroke.getLineJoin();
        float miterlimit = bStroke.getMiterLimit();
        float[] dash = bStroke.getDashArray();
        float dash_phase = bStroke.getDashPhase();
        StringBuffer dashRep = new StringBuffer();
        if (dash == null) {
            dashRep.append("null");
        } else {
            String sep = "";
            dashRep.append(this.languageRenderer.startPrimitiveArrayOf("float"));
            for (float _dash : dash) {
                dashRep.append(sep);
                dashRep.append(_dash + "f");
                sep = ",";
            }
            dashRep.append("}");
        }
        this.printWriterManager.println("stroke = " + this.languageRenderer.getObjectCreation("BasicStroke") + "(" + width + "f," + cap + "," + join + "," + miterlimit + "f," + dashRep + "," + dash_phase + "f)" + this.languageRenderer.getStatementEnd());
        this.transcodeShape(shape, "");
        this.printWriterManager.println("g" + this.languageRenderer.startSetterAssignment("paint") + "paint" + this.languageRenderer.endSetterAssignment() + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("g" + this.languageRenderer.startSetterAssignment("stroke") + "stroke" + this.languageRenderer.endSetterAssignment() + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("g.draw(shape)" + this.languageRenderer.getStatementEnd());
    }

    private void transcodeMarkerShapePainter(MarkerShapePainter painter, Shape shape, String comment) {
        double dy;
        double dx;
        PathIterator pathIterator = shape.getPathIterator(null);
        ArrayList<Point2D.Float> pathPoints = new ArrayList<Point2D.Float>();
        float[] coords = new float[6];
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(coords);
            switch (type) {
                case 3: {
                    pathPoints.add(new Point2D.Float(coords[4], coords[5]));
                    break;
                }
                case 2: {
                    pathPoints.add(new Point2D.Float(coords[2], coords[3]));
                    break;
                }
                case 0: 
                case 1: {
                    pathPoints.add(new Point2D.Float(coords[0], coords[1]));
                }
            }
            pathIterator.next();
        }
        int pathPointCount = pathPoints.size();
        if (painter.getStartMarker() != null) {
            Point2D firstPoint = (Point2D)pathPoints.get(0);
            Marker startMarker = painter.getStartMarker();
            dx = firstPoint.getX() - startMarker.getRef().getX();
            dy = firstPoint.getY() - startMarker.getRef().getY();
            this.printWriterManager.println("g.translate(" + dx + ", " + dy + ")" + this.languageRenderer.getStatementEnd());
            this.rotate(startMarker.getOrient());
            this.transcodeGraphicsNode(startMarker.getMarkerNode(), comment + "_m0");
            this.rotate(-startMarker.getOrient());
            this.printWriterManager.println("g.translate(" + -dx + ", " + -dy + ")" + this.languageRenderer.getStatementEnd());
        }
        if (painter.getMiddleMarker() != null && pathPointCount > 2) {
            Marker middleMarker = painter.getMiddleMarker();
            for (int i = 1; i < pathPointCount - 1; ++i) {
                Point2D middlePoint = (Point2D)pathPoints.get(i);
                double dx2 = middlePoint.getX() - middleMarker.getRef().getX();
                double dy2 = middlePoint.getY() - middleMarker.getRef().getY();
                this.printWriterManager.println("g.translate(" + dx2 + ", " + dy2 + ")" + this.languageRenderer.getStatementEnd());
                this.rotate(middleMarker.getOrient());
                this.transcodeGraphicsNode(middleMarker.getMarkerNode(), comment + "_m" + i);
                this.rotate(-middleMarker.getOrient());
                this.printWriterManager.println("g.translate(" + -dx2 + ", " + -dy2 + ")" + this.languageRenderer.getStatementEnd());
            }
        }
        if (painter.getEndMarker() != null) {
            Point2D lastPoint = (Point2D)pathPoints.get(pathPointCount - 1);
            Marker endMarker = painter.getEndMarker();
            dx = lastPoint.getX() - endMarker.getRef().getX();
            dy = lastPoint.getY() - endMarker.getRef().getY();
            this.printWriterManager.println("g.translate(" + dx + ", " + dy + ")" + this.languageRenderer.getStatementEnd());
            this.rotate(endMarker.getOrient());
            this.transcodeGraphicsNode(endMarker.getMarkerNode(), comment + "_m" + (pathPointCount - 1));
            this.rotate(-endMarker.getOrient());
            this.printWriterManager.println("g.translate(" + -dx + ", " + -dy + ")" + this.languageRenderer.getStatementEnd());
        }
    }

    private void rotate(double angle) {
        if (Double.isFinite(angle) && angle != 0.0) {
            this.printWriterManager.println("g.rotate(" + angle + ")" + this.languageRenderer.getStatementEnd());
        }
    }

    private void transcodeShapeNode(ShapeNode node, String comment) {
        this.printWriterManager.println("// " + comment);
        this.transcodeShapePainter(node.getShapePainter(), node.getShape(), comment);
        this.printWriterManager.checkin();
    }

    private void transcodeCompositeGraphicsNode(CompositeGraphicsNode node, String comment) {
        this.printWriterManager.println("// " + comment);
        int count = 0;
        for (Object obj : node.getChildren()) {
            this.transcodeGraphicsNode((GraphicsNode)obj, comment + "_" + count);
            ++count;
        }
        this.printWriterManager.checkin();
    }

    private void transcodeRenderedImage(RenderedImage image, String graphicsName) {
        String md5 = RasterScanner.getMD5(image);
        this.printWriterManager.println(this.languageRenderer.startVariableDefinition("BufferedImage") + "image" + md5 + "=getImage" + md5 + "()" + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("if (image" + md5 + " != null) {");
        this.printWriterManager.println("    " + graphicsName + ".drawImage(image" + md5 + ", 0, 0, null)" + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("}");
    }

    private void transcodeRasterImageNode(RasterImageNode node, String comment) {
        this.printWriterManager.println("// " + comment);
        RenderedImage image = node.getImage().createDefaultRendering();
        this.transcodeRenderedImage(image, "g");
    }

    private void transcodeTextNode(TextNode node, String comment) {
        this.printWriterManager.println("// " + comment);
        this.printWriterManager.println("{");
        this.printWriterManager.println("    " + this.languageRenderer.startVariableDefinition("Graphics2D") + "gText = " + this.languageRenderer.getObjectCast("g.create()", "Graphics2D") + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("            " + this.languageRenderer.startVariableDefinition("Shape") + "shapeText = null" + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("            " + this.languageRenderer.startVariableDefinition("GeneralPath") + "generalPathText = null" + this.languageRenderer.getStatementEnd());
        node.primitivePaint((Graphics2D)new McCrashyGraphics2D(){
            private Shape clip;
            private RenderingHints hints = new RenderingHints(new HashMap());
            private AffineTransform transform = new AffineTransform();
            private Composite composite;

            @Override
            public Graphics create() {
                return this;
            }

            @Override
            public void dispose() {
            }

            @Override
            public void draw(Shape shape) {
                SvgBaseTranscoder.this.transcodeShape(shape, "Text");
                SvgBaseTranscoder.this.printWriterManager.println("gText.draw(shapeText);");
            }

            @Override
            public void fill(Shape shape) {
                SvgBaseTranscoder.this.transcodeShape(shape, "Text");
                SvgBaseTranscoder.this.printWriterManager.println("gText.fill(shapeText);");
            }

            @Override
            public void setComposite(Composite composite) {
                this.composite = composite;
                int rule = ((AlphaComposite)composite).getRule();
                float alpha = ((AlphaComposite)composite).getAlpha();
                SvgBaseTranscoder.this.printWriterManager.println("gText" + SvgBaseTranscoder.this.languageRenderer.startSetterAssignment("composite") + "AlphaComposite.getInstance(" + rule + ", " + alpha + "f * origAlpha)" + SvgBaseTranscoder.this.languageRenderer.endSetterAssignment() + SvgBaseTranscoder.this.languageRenderer.getStatementEnd());
            }

            @Override
            public void setPaint(Paint paint) {
                SvgBaseTranscoder.this.transcodePaint(paint);
                SvgBaseTranscoder.this.printWriterManager.println("gText" + SvgBaseTranscoder.this.languageRenderer.startSetterAssignment("paint") + "paint" + SvgBaseTranscoder.this.languageRenderer.endSetterAssignment() + SvgBaseTranscoder.this.languageRenderer.getStatementEnd());
            }

            @Override
            public void setStroke(Stroke stroke) {
                float strokeWidth = ((BasicStroke)stroke).getLineWidth();
                int endCap = ((BasicStroke)stroke).getEndCap();
                int lineJoin = ((BasicStroke)stroke).getLineJoin();
                float miterLimit = ((BasicStroke)stroke).getMiterLimit();
                float[] dash = ((BasicStroke)stroke).getDashArray();
                float dash_phase = ((BasicStroke)stroke).getDashPhase();
                StringBuffer dashRep = new StringBuffer();
                if (dash == null) {
                    dashRep.append("null");
                } else {
                    String sep = "";
                    dashRep.append(SvgBaseTranscoder.this.languageRenderer.startPrimitiveArrayOf("float"));
                    for (float _dash : dash) {
                        dashRep.append(sep);
                        dashRep.append(_dash + "f");
                        sep = ",";
                    }
                    dashRep.append("}");
                }
                SvgBaseTranscoder.this.printWriterManager.println("gText" + SvgBaseTranscoder.this.languageRenderer.startSetterAssignment("stroke") + SvgBaseTranscoder.this.languageRenderer.getObjectCreation("BasicStroke") + "(" + strokeWidth + "f," + endCap + "," + lineJoin + "," + miterLimit + "f," + dashRep + "," + dash_phase + "f)" + SvgBaseTranscoder.this.languageRenderer.endSetterAssignment() + SvgBaseTranscoder.this.languageRenderer.getStatementEnd());
            }

            @Override
            public Shape getClip() {
                return this.clip;
            }

            @Override
            public void setClip(Shape clip) {
                this.clip = clip;
            }

            @Override
            public void setClip(int x, int y, int width, int height) {
                this.clip = new Rectangle2D.Double(x, y, width, height);
            }

            @Override
            public void clip(Shape s) {
                if (this.clip == null) {
                    this.clip = s;
                } else {
                    Area current = new Area(this.clip);
                    Area requested = new Area(s);
                    current.intersect(requested);
                    this.clip = current;
                }
            }

            @Override
            public void clipRect(int x, int y, int width, int height) {
                this.clip(new Rectangle2D.Double(x, y, width, height));
            }

            @Override
            public void setRenderingHints(Map<?, ?> hints) {
                this.hints.clear();
                this.hints.putAll(hints);
            }

            @Override
            public void addRenderingHints(Map<?, ?> hints) {
                this.hints.putAll(hints);
            }

            @Override
            public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
                this.hints.put(hintKey, hintValue);
            }

            @Override
            public Object getRenderingHint(RenderingHints.Key key) {
                return this.hints.get(key);
            }

            @Override
            public RenderingHints getRenderingHints() {
                return this.hints;
            }

            @Override
            public void setTransform(AffineTransform transform) {
                this.transform = transform;
            }

            @Override
            public void transform(AffineTransform Tx) {
                this.transform.concatenate(Tx);
            }

            @Override
            public void translate(int x, int y) {
                this.transform.translate(x, y);
            }

            @Override
            public void translate(double tx, double ty) {
                this.transform.translate(tx, ty);
            }

            @Override
            public void rotate(double theta) {
                this.transform.rotate(theta);
            }

            @Override
            public void rotate(double theta, double x, double y) {
                this.transform.rotate(theta, x, y);
            }

            @Override
            public AffineTransform getTransform() {
                return this.transform;
            }

            @Override
            public Composite getComposite() {
                return this.composite;
            }

            @Override
            public GraphicsConfiguration getDeviceConfiguration() {
                return null;
            }
        });
        this.printWriterManager.println("    gText.dispose()" + this.languageRenderer.getStatementEnd());
        this.printWriterManager.println("}");
        this.printWriterManager.checkin();
    }

    private void transcodeGraphicsNode(GraphicsNode node, String comment) throws UnsupportedOperationException {
        AlphaComposite composite = (AlphaComposite)node.getComposite();
        if (composite != null) {
            int rule = composite.getRule();
            float alpha = composite.getAlpha();
            this.printWriterManager.println("g" + this.languageRenderer.startSetterAssignment("composite") + "AlphaComposite.getInstance(" + rule + ", " + alpha + "f * origAlpha)" + this.languageRenderer.endSetterAssignment() + this.languageRenderer.getStatementEnd());
        }
        AffineTransform transform = node.getTransform();
        this.printWriterManager.println("transformsStack.push(g" + this.languageRenderer.getGetter("transform") + ")" + this.languageRenderer.getStatementEnd());
        if (transform != null) {
            double[] transfMatrix = new double[6];
            transform.getMatrix(transfMatrix);
            this.printWriterManager.println("g.transform(" + this.languageRenderer.getObjectCreation("AffineTransform") + "(" + transfMatrix[0] + "f, " + transfMatrix[1] + "f, " + transfMatrix[2] + "f, " + transfMatrix[3] + "f, " + transfMatrix[4] + "f, " + transfMatrix[5] + "f))" + this.languageRenderer.getStatementEnd());
        }
        try {
            if (node instanceof ShapeNode) {
                this.transcodeShapeNode((ShapeNode)node, comment);
                return;
            }
            if (node instanceof CompositeGraphicsNode) {
                this.transcodeCompositeGraphicsNode((CompositeGraphicsNode)node, comment);
                return;
            }
            if (node instanceof RasterImageNode) {
                this.transcodeRasterImageNode((RasterImageNode)node, comment);
                return;
            }
            if (node instanceof TextNode) {
                this.transcodeTextNode((TextNode)node, comment);
                return;
            }
            throw new UnsupportedOperationException(node.getClass().getCanonicalName());
        }
        finally {
            this.printWriterManager.println("g" + this.languageRenderer.startSetterAssignment("transform") + "transformsStack.pop()" + this.languageRenderer.endSetterAssignment() + this.languageRenderer.getStatementEnd());
        }
    }

    private static class PrintWriterManager {
        private static final int ROTATION_THRESHOLD = 1000;
        private List<ByteArrayOutputStream> streamList = new ArrayList<ByteArrayOutputStream>();
        private PrintWriter currentWriter;
        private int lines = 0;

        public PrintWriterManager() {
            ByteArrayOutputStream paintingCodeStream = new ByteArrayOutputStream();
            this.streamList.add(paintingCodeStream);
            this.currentWriter = new PrintWriter(paintingCodeStream);
        }

        public void println(String string) {
            this.currentWriter.println(string);
            ++this.lines;
        }

        public void print(String string) {
            this.currentWriter.print(string);
        }

        public void format(String format, Object ... args) {
            this.currentWriter.format(format, args);
        }

        public void format(Locale l, String format, Object ... args) {
            this.currentWriter.format(l, format, args);
        }

        public void checkin() {
            if (this.lines >= 1000) {
                this.currentWriter.close();
                ByteArrayOutputStream paintingCodeStream = new ByteArrayOutputStream();
                this.streamList.add(paintingCodeStream);
                this.currentWriter = new PrintWriter(paintingCodeStream);
                this.lines = 0;
            }
        }

        public void close() {
            this.currentWriter.close();
        }

        public List<ByteArrayOutputStream> getStreamList() {
            return Collections.unmodifiableList(this.streamList);
        }
    }
}

