/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.tools.svgtranscoder.gradle;

import java.io.File;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.pushingpixels.radiance.tools.svgtranscoder.api.LanguageRenderer;
import org.pushingpixels.radiance.tools.svgtranscoder.api.java.JavaLanguageRenderer;
import org.pushingpixels.radiance.tools.svgtranscoder.api.kotlin.KotlinLanguageRenderer;
import org.pushingpixels.radiance.tools.svgtranscoder.gradle.TranscodeBaseTask;

public class TranscodeDeepTask
extends TranscodeBaseTask {
    private String outputRootPackageName;
    private String outputLanguage;
    private String outputClassNamePrefix = "";
    private File inputRootDirectory;
    private File outputRootDirectory;

    @Input
    public String getOutputRootPackageName() {
        return this.outputRootPackageName;
    }

    @Option(option="outputRootPackageName", description="Configures the output root package name.")
    public void setOutputRootPackageName(String outputRootPackageName) {
        this.outputRootPackageName = outputRootPackageName;
    }

    @Input
    public String getOutputLanguage() {
        return this.outputLanguage;
    }

    @Option(option="outputLanguage", description="Configures the output language.")
    public void setOutputLanguage(String outputLanguage) {
        this.outputLanguage = outputLanguage;
    }

    @Input
    public String getOutputClassNamePrefix() {
        return this.outputClassNamePrefix;
    }

    @Option(option="outputClassNamePrefix", description="Configures the output class name prefix.")
    public void setOutputClassNamePrefix(String outputClassNamePrefix) {
        this.outputClassNamePrefix = outputClassNamePrefix;
    }

    @InputDirectory
    public File getInputRootDirectory() {
        return this.inputRootDirectory;
    }

    @Option(option="inputRootDirectory", description="Configures the input root directory.")
    public void setInputRootDirectory(File inputRootDirectory) {
        this.inputRootDirectory = inputRootDirectory;
    }

    @OutputDirectory
    public File getOutputRootDirectory() {
        return this.outputRootDirectory;
    }

    @Option(option="outputRootDirectory", description="Configures the output root directory.")
    public void setOutputRootDirectory(File outputRootDirectory) {
        this.outputRootDirectory = outputRootDirectory;
    }

    @TaskAction
    public void transcode() {
        Logger logger = this.getLogger();
        logger.trace("Working on files in " + this.inputRootDirectory.getAbsolutePath());
        if (!this.inputRootDirectory.exists()) {
            return;
        }
        this.outputRootDirectory.mkdirs();
        boolean renderAsKotlinCode = "kotlin".compareTo(this.outputLanguage) == 0;
        KotlinLanguageRenderer languageRenderer = renderAsKotlinCode ? new KotlinLanguageRenderer() : new JavaLanguageRenderer();
        String outputFileNameExtension = "java".compareTo(this.outputLanguage) == 0 ? ".java" : ".kt";
        logger.trace("Processing " + this.inputRootDirectory.getAbsolutePath() + " to " + this.outputRootPackageName + " in " + this.outputLanguage);
        String templateFileName = "/org/pushingpixels/radiance/tools/svgtranscoder/api/" + this.outputLanguage + "/SvgTranscoderTemplateRadiance.templ";
        this.processFolder(this.inputRootDirectory, this.outputRootDirectory, this.outputClassNamePrefix, outputFileNameExtension, this.outputRootPackageName, (LanguageRenderer)languageRenderer, templateFileName);
    }

    protected void processFolder(File inputFolder, File outputFolder, String outputClassNamePrefix, String outputFileNameExtension, String outputPackageName, LanguageRenderer languageRenderer, String templateFile) {
        Logger logger = this.getLogger();
        logger.trace("Working on files in " + inputFolder.getAbsolutePath());
        this.transcodeAllFilesInFolder(inputFolder, outputFolder, outputClassNamePrefix, outputFileNameExtension, outputPackageName, languageRenderer, templateFile);
        for (File inputSubfolder : inputFolder.listFiles((directory, name) -> new File(directory, name).isDirectory())) {
            String subfolderName = inputSubfolder.getName();
            logger.trace("Going into sub-folder " + subfolderName);
            File outputSubfolder = new File(outputFolder, subfolderName);
            if (!outputSubfolder.exists()) {
                outputSubfolder.mkdir();
            }
            this.processFolder(inputSubfolder, outputSubfolder, outputClassNamePrefix, outputFileNameExtension, outputPackageName + "." + subfolderName, languageRenderer, templateFile);
        }
        System.out.println();
    }
}

