/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.tools.svgtranscoder.gradle;

import java.io.File;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.pushingpixels.radiance.tools.svgtranscoder.api.LanguageRenderer;
import org.pushingpixels.radiance.tools.svgtranscoder.api.java.JavaLanguageRenderer;
import org.pushingpixels.radiance.tools.svgtranscoder.api.kotlin.KotlinLanguageRenderer;
import org.pushingpixels.radiance.tools.svgtranscoder.gradle.TranscodeBaseTask;

public class TranscodeTask
extends TranscodeBaseTask {
    private String outputPackageName;
    private String outputLanguage;
    private String outputClassNamePrefix = "";
    private File inputDirectory;
    private File outputDirectory;

    @Input
    public String getOutputPackageName() {
        return this.outputPackageName;
    }

    @Option(option="outputPackageName", description="Configures the output package name.")
    public void setOutputPackageName(String outputPackageName) {
        this.outputPackageName = outputPackageName;
    }

    @Input
    public String getOutputLanguage() {
        return this.outputLanguage;
    }

    @Option(option="outputLanguage", description="Configures the output language.")
    public void setOutputLanguage(String outputLanguage) {
        this.outputLanguage = outputLanguage;
    }

    @Input
    public String getOutputClassNamePrefix() {
        return this.outputClassNamePrefix;
    }

    @Option(option="outputClassNamePrefix", description="Configures the output class name prefix.")
    public void setOutputClassNamePrefix(String outputClassNamePrefix) {
        this.outputClassNamePrefix = outputClassNamePrefix;
    }

    @InputDirectory
    public File getInputDirectory() {
        return this.inputDirectory;
    }

    @Option(option="inputDirectory", description="Configures the input directory.")
    public void setInputDirectory(File inputDirectory) {
        this.inputDirectory = inputDirectory;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Option(option="outputDirectory", description="Configures the output directory.")
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @TaskAction
    public void transcode() {
        Logger logger = this.getLogger();
        logger.trace("Working on files in " + this.inputDirectory.getAbsolutePath());
        if (!this.inputDirectory.exists()) {
            return;
        }
        this.outputDirectory.mkdirs();
        boolean renderAsKotlinCode = "kotlin".compareTo(this.outputLanguage) == 0;
        KotlinLanguageRenderer languageRenderer = renderAsKotlinCode ? new KotlinLanguageRenderer() : new JavaLanguageRenderer();
        String outputFileNameExtension = "java".compareTo(this.outputLanguage) == 0 ? ".java" : ".kt";
        logger.trace("Processing " + this.inputDirectory.getAbsolutePath() + " to " + this.outputPackageName + " in " + this.outputLanguage);
        String templateFileName = "/org/pushingpixels/radiance/tools/svgtranscoder/api/" + this.outputLanguage + "/SvgTranscoderTemplateRadiance.templ";
        this.transcodeAllFilesInFolder(this.inputDirectory, this.outputDirectory, this.outputClassNamePrefix, outputFileNameExtension, this.outputPackageName, (LanguageRenderer)languageRenderer, templateFileName);
    }
}

