/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.tools.svgtranscoder.gradle;

import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.gradle.api.DefaultTask;
import org.gradle.api.logging.Logger;
import org.pushingpixels.radiance.tools.svgtranscoder.api.LanguageRenderer;
import org.pushingpixels.radiance.tools.svgtranscoder.api.SvgBatchBaseConverter;
import org.pushingpixels.radiance.tools.svgtranscoder.api.SvgTranscoder;
import org.pushingpixels.radiance.tools.svgtranscoder.api.TranscoderListener;

public abstract class TranscodeBaseTask
extends DefaultTask {
    protected void transcodeAllFilesInFolder(File inputFolder, File outputFolder, String outputClassNamePrefix, String outputFileNameExtension, String outputPackageName, LanguageRenderer languageRenderer, String templateFileName) {
        Logger logger = this.getLogger();
        File[] svgFiles = inputFolder.listFiles((directory, name) -> name.endsWith(".svg"));
        if (svgFiles == null) {
            return;
        }
        for (File file : svgFiles) {
            Object svgClassName = outputClassNamePrefix + file.getName().substring(0, file.getName().length() - 4);
            svgClassName = ((String)svgClassName).replace('-', '_');
            svgClassName = ((String)svgClassName).replace(' ', '_');
            String classFilename = outputFolder + File.separator + (String)svgClassName + outputFileNameExtension;
            logger.trace("Processing " + file.getName());
            try (final PrintWriter pw = new PrintWriter(classFilename);
                 InputStream templateStream = SvgBatchBaseConverter.class.getResourceAsStream(templateFileName);){
                if (templateStream == null) {
                    logger.error("Couldn't load " + templateFileName);
                    return;
                }
                final CountDownLatch latch = new CountDownLatch(1);
                SvgTranscoder transcoder = new SvgTranscoder(file.toURI().toURL().toString(), (String)svgClassName, languageRenderer);
                transcoder.setPackageName(outputPackageName);
                transcoder.setListener(new TranscoderListener(){

                    public Writer getWriter() {
                        return pw;
                    }

                    public void finished() {
                        latch.countDown();
                    }
                });
                transcoder.transcode(templateStream);
                latch.await(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                logger.error("Transcoding failed", (Throwable)e);
            }
        }
    }
}

