/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.combo;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.JComboBox;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.ImageHashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;

public class ComboBoxBackgroundDelegate {
    private static LazyResettableHashMap<BufferedImage> regularBackgrounds = new LazyResettableHashMap("ComboBoxBackgroundDelegate");

    public static BufferedImage getFullAlphaBackground(JComboBox combo, SubstanceFillPainter fillPainter, SubstanceBorderPainter borderPainter, int width, int height) {
        double scale = NeonCortex.getScaleFactor((Component)combo);
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)combo.getUI());
        StateTransitionTracker.ModelStateInfo modelStateInfo = transitionAwareUI.getTransitionTracker().getModelStateInfo();
        ComponentState currState = modelStateInfo.getCurrModelState();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        int comboFontSize = SubstanceSizeUtils.getComponentFontSize(combo);
        float radius = SubstanceSizeUtils.getClassicButtonCornerRadius(comboFontSize);
        SubstanceColorScheme baseFillScheme = SubstanceColorSchemeUtilities.getColorScheme(combo, currState);
        SubstanceColorScheme baseBorderScheme = SubstanceColorSchemeUtilities.getColorScheme(combo, SubstanceSlices.ColorSchemeAssociationKind.BORDER, currState);
        ImageHashMapKey keyBase = SubstanceCoreUtilities.getScaleAwareHashKey(scale, width, height, baseFillScheme.getDisplayName(), baseBorderScheme.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), combo.getClass().getName(), Float.valueOf(radius), comboFontSize);
        BufferedImage layerBase = regularBackgrounds.get(keyBase);
        if (layerBase == null) {
            layerBase = ComboBoxBackgroundDelegate.createBackgroundImage(combo, fillPainter, borderPainter, width, height, baseFillScheme, baseBorderScheme, radius);
            regularBackgrounds.put(keyBase, layerBase);
        }
        if (currState.isDisabled() || activeStates.size() == 1) {
            return layerBase;
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankUnscaledImage(layerBase);
        Graphics2D g2d = result.createGraphics();
        g2d.drawImage(layerBase, 0, 0, layerBase.getWidth(), layerBase.getHeight(), null);
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
            float stateContribution;
            ComponentState activeState = activeEntry.getKey();
            if (activeState == currState || !((stateContribution = activeEntry.getValue().getContribution()) > 0.0f)) continue;
            g2d.setComposite(AlphaComposite.SrcOver.derive(stateContribution));
            SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme(combo, activeState);
            SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme(combo, SubstanceSlices.ColorSchemeAssociationKind.BORDER, activeState);
            ImageHashMapKey key = SubstanceCoreUtilities.getScaleAwareHashKey(scale, width, height, fillScheme.getDisplayName(), borderScheme.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), combo.getClass().getName(), Float.valueOf(radius), comboFontSize);
            BufferedImage layer = regularBackgrounds.get(key);
            if (layer == null) {
                layer = ComboBoxBackgroundDelegate.createBackgroundImage(combo, fillPainter, borderPainter, width, height, fillScheme, borderScheme, radius);
                regularBackgrounds.put(key, layer);
            }
            g2d.drawImage(layer, 0, 0, layer.getWidth(), layer.getHeight(), null);
        }
        g2d.dispose();
        return result;
    }

    private static BufferedImage createBackgroundImage(JComboBox combo, SubstanceFillPainter fillPainter, SubstanceBorderPainter borderPainter, int width, int height, SubstanceColorScheme fillScheme, SubstanceColorScheme borderScheme, float radius) {
        double scale = NeonCortex.getScaleFactor((Component)combo);
        float borderDelta = SubstanceSizeUtils.getBorderStrokeWidth(combo) / 2.0f;
        Shape contour = SubstanceOutlineUtilities.getBaseOutline(width, height, radius, null, borderDelta);
        BufferedImage newBackground = SubstanceCoreUtilities.getBlankImage(scale, width, height);
        Graphics2D finalGraphics = (Graphics2D)newBackground.getGraphics();
        fillPainter.paintContourBackground(finalGraphics, combo, width, height, contour, false, fillScheme, true);
        float borderThickness = SubstanceSizeUtils.getBorderStrokeWidth(combo);
        Shape contourInner = borderPainter.isPaintingInnerContour() ? SubstanceOutlineUtilities.getBaseOutline(width, height, radius - borderThickness, null, borderDelta + borderThickness) : null;
        borderPainter.paintBorder(finalGraphics, combo, width, height, contour, contourInner, borderScheme);
        return newBackground;
    }

    public void updateBackground(Graphics g, JComboBox combo) {
        if (!SubstanceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        int width = combo.getWidth();
        int height = combo.getHeight();
        int y = 0;
        SubstanceFillPainter fillPainter = SubstanceCoreUtilities.getFillPainter(combo);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(combo);
        BufferedImage bgImage = ComboBoxBackgroundDelegate.getFullAlphaBackground(combo, fillPainter, borderPainter, width, height);
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)combo.getUI());
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        boolean isFlat = SubstanceCoreUtilities.hasFlatAppearance(combo, false);
        boolean isSpecial = isFlat || !combo.isEnabled();
        float extraAlpha = 1.0f;
        if (isSpecial) {
            if (isFlat) {
                extraAlpha = 0.0f;
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                    ComponentState activeState = activeEntry.getKey();
                    if (activeState.isDisabled() || activeState == ComponentState.ENABLED) continue;
                    extraAlpha += activeEntry.getValue().getContribution();
                }
            } else if (!combo.isEnabled()) {
                extraAlpha = SubstanceColorSchemeUtilities.getAlpha(combo, modelStateInfo.getCurrModelState());
            }
        }
        if (extraAlpha > 0.0f) {
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setComposite(WidgetUtilities.getAlphaComposite(combo, extraAlpha, g));
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            NeonCortex.drawImageWithScale((Graphics)graphics, (double)NeonCortex.getScaleFactor((Component)combo), (Image)bgImage, (int)0, (int)y);
            graphics.dispose();
        }
    }
}

