/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.JTextComponent;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.utils.border.SubstanceTextComponentBorder;

public class SubstanceTextUtilities {
    public static final String ENFORCE_FG_COLOR = "substancelaf.internal.textUtilities.enforceFgColor";

    public static void paintTextWithDropShadow(JComponent c, Graphics g, Color foregroundColor, Color echoColor, String text, int width, int height, int xOffset, int yOffset) {
        Graphics2D graphics = (Graphics2D)g.create();
        NeonCortex.installDesktopHints((Graphics2D)graphics, (Font)c.getFont());
        BufferedImage blurred = SubstanceCoreUtilities.getBlankImage(NeonCortex.getScaleFactor((Component)c), width, height);
        Graphics2D gBlurred = (Graphics2D)blurred.getGraphics();
        gBlurred.setFont(graphics.getFont());
        gBlurred.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        float luminFactor = SubstanceColorUtilities.getColorStrength(foregroundColor);
        gBlurred.setColor(echoColor);
        ConvolveOp convolve = new ConvolveOp(new Kernel(3, 3, new float[]{0.04f, 0.06f, 0.04f, 0.06f, 0.04f, 0.06f, 0.04f, 0.06f, 0.04f}), 1, null);
        gBlurred.drawString(text, xOffset, yOffset);
        blurred = convolve.filter(blurred, null);
        graphics.setComposite(WidgetUtilities.getAlphaComposite(c, luminFactor, g));
        double scaleFactor = NeonCortex.getScaleFactor((Component)c);
        graphics.drawImage(blurred, 0, 0, (int)((double)blurred.getWidth() / scaleFactor), (int)((double)blurred.getHeight() / scaleFactor), null);
        graphics.setComposite(WidgetUtilities.getAlphaComposite((Component)c, g));
        FontMetrics fm = graphics.getFontMetrics();
        SubstanceTextUtilities.paintText((Graphics)graphics, new Rectangle(xOffset, yOffset - fm.getAscent(), width - xOffset, fm.getHeight()), text, -1, graphics.getFont(), foregroundColor, graphics.getClipBounds());
        graphics.dispose();
    }

    private static void paintText(Graphics g, Rectangle textRect, String text, int mnemonicIndex, Font font, Color color, Rectangle clip, AffineTransform transform) {
        if (text == null || text.length() == 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setFont(font);
        g2d.setColor(color);
        int dx = textRect.x;
        int dy = textRect.y + g2d.getFontMetrics().getAscent();
        if (clip != null) {
            g2d.clip(clip);
        }
        if (transform != null) {
            g2d.transform(transform);
        }
        BasicGraphicsUtils.drawStringUnderlineCharAt(g2d, text, mnemonicIndex, dx, dy);
        g2d.dispose();
    }

    public static void paintText(Graphics g, Rectangle textRect, String text, int mnemonicIndex, Font font, Color color, Rectangle clip) {
        SubstanceTextUtilities.paintText(g, textRect, text, mnemonicIndex, font, color, clip, null);
    }

    public static void paintVerticalText(Graphics g, Rectangle textRect, String text, int mnemonicIndex, Font font, Color color, Rectangle clip, boolean isFromBottomToTop) {
        AffineTransform at;
        if (text == null || text.length() == 0) {
            return;
        }
        if (!isFromBottomToTop) {
            at = AffineTransform.getTranslateInstance(textRect.x + textRect.width, textRect.y);
            at.rotate(1.5707963267948966);
        } else {
            at = AffineTransform.getTranslateInstance(textRect.x, textRect.y + textRect.height);
            at.rotate(-1.5707963267948966);
        }
        Rectangle newRect = new Rectangle(0, 0, textRect.width, textRect.height);
        SubstanceTextUtilities.paintText(g, newRect, text, mnemonicIndex, font, color, clip, at);
    }

    public static Color paintText(Graphics g, AbstractButton button, Rectangle textRect, String text, int mnemonicIndex) {
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)button.getUI());
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        if (button instanceof JMenuItem) {
            float menuItemAlpha = SubstanceColorSchemeUtilities.getAlpha(button, ComponentState.getState(button.getModel(), button, true));
            return SubstanceTextUtilities.paintMenuItemText(g, (JMenuItem)button, textRect, text, mnemonicIndex, stateTransitionTracker.getModelStateInfo(), menuItemAlpha);
        }
        float buttonAlpha = SubstanceColorSchemeUtilities.getAlpha(button, ComponentState.getState(button));
        return SubstanceTextUtilities.paintText(g, (JComponent)button, textRect, text, mnemonicIndex, stateTransitionTracker.getModelStateInfo(), buttonAlpha);
    }

    public static Color paintText(Graphics g, JComponent component, Rectangle textRect, String text, int mnemonicIndex, ComponentState state, float textAlpha) {
        Color fgColor = SubstanceTextUtilities.getForegroundColor(component, text, state, textAlpha);
        SubstanceTextUtilities.paintText(g, textRect, text, mnemonicIndex, component.getFont(), fgColor, null);
        return fgColor;
    }

    public static Color paintText(Graphics g, JComponent component, Rectangle textRect, String text, int mnemonicIndex, StateTransitionTracker.ModelStateInfo modelStateInfo, float textAlpha) {
        Color fgColor = SubstanceTextUtilities.getForegroundColor(component, text, modelStateInfo, textAlpha);
        SubstanceTextUtilities.paintText(g, textRect, text, mnemonicIndex, component.getFont(), fgColor, null);
        return fgColor;
    }

    public static Color paintMenuItemText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text, int mnemonicIndex, StateTransitionTracker.ModelStateInfo modelStateInfo, float textAlpha) {
        Color fgColor = SubstanceTextUtilities.getMenuComponentForegroundColor(menuItem, text, modelStateInfo, textAlpha);
        SubstanceTextUtilities.paintText(g, textRect, text, mnemonicIndex, menuItem.getFont(), fgColor, null);
        return fgColor;
    }

    public static Color getForegroundColor(JComponent component, String text, ComponentState state, float textAlpha) {
        Color fgColor;
        boolean toEnforceFgColor = SwingUtilities.getAncestorOfClass(CellRendererPane.class, component) != null || Boolean.TRUE.equals(component.getClientProperty(ENFORCE_FG_COLOR));
        Color color = fgColor = toEnforceFgColor ? component.getForeground() : SubstanceColorSchemeUtilities.getColorScheme(component, state).getForegroundColor();
        if (textAlpha < 1.0f) {
            Color bgFillColor = SubstanceColorUtilities.getBackgroundFillColor(component);
            fgColor = SubstanceColorUtilities.getInterpolatedColor(fgColor, bgFillColor, textAlpha);
        }
        return fgColor;
    }

    public static Color getForegroundColor(JComponent component, String text, StateTransitionTracker.ModelStateInfo modelStateInfo, float textAlpha) {
        if (text == null || text.length() == 0) {
            return null;
        }
        boolean toEnforceFgColor = SwingUtilities.getAncestorOfClass(CellRendererPane.class, component) != null || Boolean.TRUE.equals(component.getClientProperty(ENFORCE_FG_COLOR));
        Color fgColor = null;
        fgColor = toEnforceFgColor ? component.getForeground() : SubstanceColorUtilities.getForegroundColor(component, modelStateInfo);
        if (textAlpha < 1.0f) {
            Color bgFillColor = SubstanceColorUtilities.getBackgroundFillColor(component);
            fgColor = SubstanceColorUtilities.getInterpolatedColor(fgColor, bgFillColor, textAlpha);
        }
        return fgColor;
    }

    public static Color getMenuComponentForegroundColor(JMenuItem menuComponent, String text, StateTransitionTracker.ModelStateInfo modelStateInfo, float textAlpha) {
        if (text == null || text.length() == 0) {
            return null;
        }
        Color fgColor = SubstanceColorUtilities.getMenuComponentForegroundColor(menuComponent, modelStateInfo);
        if (textAlpha < 1.0f) {
            Color bgFillColor = SubstanceColorUtilities.getBackgroundFillColor(menuComponent);
            fgColor = SubstanceColorUtilities.getInterpolatedColor(fgColor, bgFillColor, textAlpha);
        }
        return fgColor;
    }

    public static Color getTextBackgroundFillColor(JComponent comp) {
        TextUI ui;
        Color backgroundFillColor = SubstanceColorUtilities.getBackgroundFillColor(comp);
        JTextComponent componentForTransitions = SubstanceCoreUtilities.getTextComponentForTransitions(comp);
        if (componentForTransitions != null && (ui = componentForTransitions.getUI()) instanceof TransitionAwareUI) {
            TransitionAwareUI trackable = (TransitionAwareUI)((Object)ui);
            StateTransitionTracker stateTransitionTracker = trackable.getTransitionTracker();
            float lightnessFactor = SubstanceColorSchemeUtilities.getColorScheme(componentForTransitions, componentForTransitions.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED).isDark() ? 0.1f : 0.4f;
            Color lighterFill = SubstanceColorUtilities.getLighterColor(backgroundFillColor, lightnessFactor);
            lighterFill = SubstanceColorUtilities.getInterpolatedColor(lighterFill, backgroundFillColor, 0.6);
            float selectionStrength = stateTransitionTracker.getFacetStrength(SubstanceSlices.ComponentStateFacet.SELECTION);
            float rolloverStrength = stateTransitionTracker.getFacetStrength(SubstanceSlices.ComponentStateFacet.ROLLOVER);
            backgroundFillColor = SubstanceColorUtilities.getInterpolatedColor(lighterFill, backgroundFillColor, Math.max(selectionStrength, rolloverStrength) / 4.0f);
        }
        return backgroundFillColor;
    }

    public static Color getTextSelectionBackground(JTextComponent comp) {
        TransitionAwareUI ui = (TransitionAwareUI)((Object)comp.getUI());
        StateTransitionTracker stateTransitionTracker = ui.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        ComponentState state = modelStateInfo.getCurrModelState();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        if (state == ComponentState.ENABLED) {
            state = ComponentState.SELECTED;
        }
        Color result = SubstanceCoreUtilities.getTextSelectionBackground(comp, state);
        if (!state.isDisabled() && activeStates != null && activeStates.size() > 1) {
            for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                float alpha;
                float contribution;
                ComponentState activeState = activeEntry.getKey();
                if (activeState == state) continue;
                if (activeState == ComponentState.ENABLED) {
                    activeState = ComponentState.SELECTED;
                }
                if ((contribution = activeEntry.getValue().getContribution()) == 0.0f || (alpha = SubstanceColorSchemeUtilities.getAlpha(comp, activeState)) == 0.0f) continue;
                Color active = SubstanceCoreUtilities.getTextSelectionBackground(comp, activeState);
                result = SubstanceColorUtilities.getInterpolatedColor(result, active, 1.0f - contribution * alpha);
            }
        }
        return result;
    }

    public static Color getTextSelectionForeground(JTextComponent comp) {
        TransitionAwareUI ui = (TransitionAwareUI)((Object)comp.getUI());
        StateTransitionTracker stateTransitionTracker = ui.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        ComponentState state = modelStateInfo.getCurrModelState();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        if (state == ComponentState.ENABLED) {
            state = ComponentState.SELECTED;
        }
        Color result = SubstanceCoreUtilities.getTextSelectionForeground(comp, state);
        if (!state.isDisabled() && activeStates != null && activeStates.size() > 1) {
            for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                float alpha;
                float contribution;
                ComponentState activeState = activeEntry.getKey();
                if (activeState == state) continue;
                if (activeState == ComponentState.ENABLED) {
                    activeState = ComponentState.SELECTED;
                }
                if ((contribution = activeEntry.getValue().getContribution()) == 0.0f || (alpha = SubstanceColorSchemeUtilities.getAlpha(comp, activeState)) == 0.0f) continue;
                Color active = SubstanceCoreUtilities.getTextSelectionForeground(comp, activeState);
                result = SubstanceColorUtilities.getInterpolatedColor(result, active, 1.0f - contribution * alpha);
            }
        }
        return result;
    }

    public static void paintTextCompBackground(Graphics g, JComponent comp) {
        TextUI ui;
        Graphics2D g2d = (Graphics2D)g.create();
        BackgroundPaintingUtils.update(g2d, comp, false);
        Color backgroundFillColor = SubstanceTextUtilities.getTextBackgroundFillColor(comp);
        g2d.setColor(backgroundFillColor);
        float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(comp);
        g2d.fill(new Rectangle2D.Float(borderStrokeWidth / 2.0f, borderStrokeWidth / 2.0f, (float)comp.getWidth() - borderStrokeWidth, (float)comp.getHeight() - borderStrokeWidth));
        ComponentState state = comp.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = null;
        JTextComponent componentForTransitions = SubstanceCoreUtilities.getTextComponentForTransitions(comp);
        if (componentForTransitions != null && (ui = componentForTransitions.getUI()) instanceof TransitionAwareUI) {
            TransitionAwareUI trackable = (TransitionAwareUI)((Object)ui);
            StateTransitionTracker stateTransitionTracker = trackable.getTransitionTracker();
            StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
            state = modelStateInfo.getCurrModelState();
            activeStates = modelStateInfo.getStateContributionMap();
        }
        if (componentForTransitions != null && !componentForTransitions.isEditable()) {
            return;
        }
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(comp);
        SubstanceColorScheme baseBorderScheme = SubstanceColorSchemeUtilities.getColorScheme(comp, SubstanceSlices.ColorSchemeAssociationKind.BORDER, state);
        Color borderColor = borderPainter.getRepresentativeColor(baseBorderScheme);
        if (!state.isDisabled() && activeStates != null && activeStates.size() > 1) {
            for (Map.Entry entry : activeStates.entrySet()) {
                float alpha;
                float contribution;
                ComponentState activeState = (ComponentState)entry.getKey();
                if (activeState == state || (contribution = ((StateTransitionTracker.StateContributionInfo)entry.getValue()).getContribution()) == 0.0f || (alpha = SubstanceColorSchemeUtilities.getAlpha(componentForTransitions, activeState)) == 0.0f) continue;
                SubstanceColorScheme activeBorderScheme = SubstanceColorSchemeUtilities.getColorScheme(componentForTransitions, SubstanceSlices.ColorSchemeAssociationKind.BORDER, activeState);
                Color activeBorderColor = borderPainter.getRepresentativeColor(activeBorderScheme);
                borderColor = SubstanceColorUtilities.getInterpolatedColor(borderColor, activeBorderColor, 1.0f - contribution * alpha);
            }
        }
        if (SubstanceTextUtilities.hasSubstanceTextBorder(comp)) {
            int shadowHeight = 6;
            int n = state.isDisabled() ? 16 : 32;
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, SubstanceColorUtilities.getAlphaColor(borderColor, n), 0.0f, shadowHeight, SubstanceColorUtilities.getAlphaColor(borderColor, 0)));
            float yTop = SubstanceSizeUtils.getBorderStrokeWidth(comp);
            g2d.fill(new Rectangle2D.Float(borderStrokeWidth, yTop, (float)comp.getWidth() - 2.0f * borderStrokeWidth, shadowHeight));
        }
        g2d.dispose();
    }

    private static boolean hasSubstanceTextBorder(JComponent comp) {
        Border border = comp.getBorder();
        if (border instanceof SubstanceTextComponentBorder) {
            return true;
        }
        if (border instanceof CompoundBorder) {
            CompoundBorder compoundBorder = (CompoundBorder)border;
            return compoundBorder.getOutsideBorder() instanceof SubstanceTextComponentBorder || compoundBorder.getInsideBorder() instanceof SubstanceTextComponentBorder;
        }
        return false;
    }
}

