/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.SoftHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SubstanceMetricsUtilities {
    private static Map<Double, BufferedImage> offscreens = new HashMap<Double, BufferedImage>();
    private static Map<HashMapKey, FontMetrics> metricsMap = new SoftHashMap<HashMapKey, FontMetrics>();
    private static Map<HashMapKey, FontRenderContext> renderContextMap = new SoftHashMap<HashMapKey, FontRenderContext>();
    private static Rectangle iconR = new Rectangle();
    private static Rectangle textR = new Rectangle();
    private static Rectangle viewR = new Rectangle();
    private static Insets insets = new Insets(0, 0, 0, 0);

    private static BufferedImage getOffscreenImage(double scale) {
        if (offscreens.containsKey(scale)) {
            return offscreens.get(scale);
        }
        BufferedImage offscreen = NeonCortex.getBlankScaledImage((double)scale, (int)1, (int)1);
        offscreens.put(scale, offscreen);
        return offscreen;
    }

    public static FontMetrics getFontMetrics(double scale, Font font) {
        HashMapKey key = SubstanceCoreUtilities.getHashKey(scale, font);
        if (metricsMap.containsKey(key)) {
            return metricsMap.get(key);
        }
        Graphics2D g2d = SubstanceMetricsUtilities.getOffscreenImage(scale).createGraphics();
        g2d.setFont(font);
        NeonCortex.installDesktopHints((Graphics2D)g2d, (Font)font);
        FontMetrics result = g2d.getFontMetrics();
        NeonCortex.clearDesktopHints((Graphics2D)g2d, (Font)font);
        g2d.dispose();
        metricsMap.put(key, result);
        return result;
    }

    public static FontRenderContext getFontRenderContext(double scale, Font font) {
        HashMapKey key = SubstanceCoreUtilities.getHashKey(scale, font);
        if (renderContextMap.containsKey(key)) {
            return renderContextMap.get(key);
        }
        Graphics2D g2d = SubstanceMetricsUtilities.getOffscreenImage(scale).createGraphics();
        g2d.setFont(font);
        NeonCortex.installDesktopHints((Graphics2D)g2d, (Font)font);
        FontRenderContext result = g2d.getFontRenderContext();
        NeonCortex.clearDesktopHints((Graphics2D)g2d, (Font)font);
        g2d.dispose();
        renderContextMap.put(key, result);
        return result;
    }

    public static Dimension getPreferredLabelSize(JLabel label) {
        String text = label.getText();
        Icon icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        Font font = label.getFont();
        insets = label.getInsets(insets);
        int dx = SubstanceMetricsUtilities.insets.left + SubstanceMetricsUtilities.insets.right;
        int dy = SubstanceMetricsUtilities.insets.top + SubstanceMetricsUtilities.insets.bottom;
        if (icon == null && (text == null || font == null)) {
            return new Dimension(dx, dy);
        }
        if (text == null || icon != null && font == null) {
            return new Dimension(icon.getIconWidth() + dx, icon.getIconHeight() + dy);
        }
        FontMetrics fm = SubstanceMetricsUtilities.getFontMetrics(NeonCortex.getScaleFactor((Component)label), font);
        iconR.setBounds(0, 0, 0, 0);
        textR.setBounds(0, 0, 0, 0);
        viewR.setBounds(dx, dy, Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(label, fm, text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, label.getIconTextGap());
        int minLeft = Math.min(SubstanceMetricsUtilities.iconR.x, SubstanceMetricsUtilities.textR.x);
        int maxRight = Math.max(SubstanceMetricsUtilities.iconR.x + SubstanceMetricsUtilities.iconR.width, SubstanceMetricsUtilities.textR.x + SubstanceMetricsUtilities.textR.width);
        int minTop = Math.min(SubstanceMetricsUtilities.iconR.y, SubstanceMetricsUtilities.textR.y);
        int maxBottom = Math.max(SubstanceMetricsUtilities.iconR.y + SubstanceMetricsUtilities.iconR.height, SubstanceMetricsUtilities.textR.y + SubstanceMetricsUtilities.textR.height);
        Dimension result = new Dimension(maxRight - minLeft, maxBottom - minTop);
        result.width += dx;
        result.height += dy;
        return result;
    }

    public static Dimension getPreferredButtonSize(AbstractButton button) {
        if (button.getComponentCount() > 0) {
            return null;
        }
        iconR.setBounds(0, 0, 0, 0);
        textR.setBounds(0, 0, 0, 0);
        viewR.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(button, SubstanceMetricsUtilities.getFontMetrics(NeonCortex.getScaleFactor((Component)button), button.getFont()), button.getText(), button.getIcon(), button.getVerticalAlignment(), button.getHorizontalAlignment(), button.getVerticalTextPosition(), button.getHorizontalTextPosition(), viewR, iconR, textR, button.getText() == null ? 0 : button.getIconTextGap());
        Rectangle r = iconR.union(textR);
        insets = button.getInsets(insets);
        r.width += SubstanceMetricsUtilities.insets.left + SubstanceMetricsUtilities.insets.right;
        r.height += SubstanceMetricsUtilities.insets.top + SubstanceMetricsUtilities.insets.bottom;
        return r.getSize();
    }

    public static Dimension getPreferredCheckButtonSize(JToggleButton button, Icon defaultIcon) {
        if (button.getComponentCount() > 0) {
            return null;
        }
        String text = button.getText();
        Icon buttonIcon = button.getIcon();
        if (buttonIcon == null) {
            buttonIcon = defaultIcon;
        }
        FontMetrics fm = SubstanceMetricsUtilities.getFontMetrics(NeonCortex.getScaleFactor((Component)button), button.getFont());
        textR.setBounds(0, 0, 0, 0);
        iconR.setBounds(0, 0, 0, 0);
        viewR.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(button, fm, text, buttonIcon, button.getVerticalAlignment(), button.getHorizontalAlignment(), button.getVerticalTextPosition(), button.getHorizontalTextPosition(), viewR, iconR, textR, text == null ? 0 : button.getIconTextGap());
        int minLeft = Math.min(SubstanceMetricsUtilities.iconR.x, SubstanceMetricsUtilities.textR.x);
        int maxRight = Math.max(SubstanceMetricsUtilities.iconR.x + SubstanceMetricsUtilities.iconR.width, SubstanceMetricsUtilities.textR.x + SubstanceMetricsUtilities.textR.width);
        int minTop = Math.min(SubstanceMetricsUtilities.iconR.y, SubstanceMetricsUtilities.textR.y);
        int maxBottom = Math.max(SubstanceMetricsUtilities.iconR.y + SubstanceMetricsUtilities.iconR.height, SubstanceMetricsUtilities.textR.y + SubstanceMetricsUtilities.textR.height);
        int width = maxRight - minLeft;
        int height = maxBottom - minTop;
        insets = button.getInsets(insets);
        return new Dimension(width += SubstanceMetricsUtilities.insets.left + SubstanceMetricsUtilities.insets.right, height += SubstanceMetricsUtilities.insets.top + SubstanceMetricsUtilities.insets.bottom);
    }
}

