/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.neon.api.UiThreadingViolationException;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.combo.ComboPopupPrototypeCallback;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.api.tabbed.TabCloseCallback;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.contrib.jgoodies.looks.LookUtils;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.ui.SubstanceRootPaneUI;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.ImageHashMapKey;
import org.pushingpixels.substance.internal.utils.MemoryAnalyzer;
import org.pushingpixels.substance.internal.utils.ScaleAwareImageWrapperIcon;
import org.pushingpixels.substance.internal.utils.SubstanceColorResource;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceInternalButton;
import org.pushingpixels.substance.internal.utils.SubstanceInternalFrameTitlePane;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceSpinnerButton;
import org.pushingpixels.substance.internal.utils.TrackableThread;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.utils.combo.SubstanceComboPopup;
import org.pushingpixels.substance.internal.utils.icon.ArrowButtonTransitionAwareIcon;
import org.pushingpixels.substance.internal.utils.icon.TransitionAware;
import org.pushingpixels.substance.internal.utils.icon.TransitionAwareIcon;
import org.pushingpixels.substance.internal.utils.menu.SubstanceMenu;
import org.pushingpixels.substance.internal.utils.scroll.SubstanceScrollButton;
import org.pushingpixels.trident.api.swing.SwingRepaintCallback;

public class SubstanceCoreUtilities {
    public static final String IS_COVERED_BY_LIGHTWEIGHT_POPUPS = "substancelaf.internal.paint.isCoveredByLightweightPopups";
    public static final String TEXT_COMPONENT_AWARE = "substancelaf.internal.textComponentAware";
    private static List<AWTEventListener> awtEventListeners = new ArrayList<AWTEventListener>();

    private SubstanceCoreUtilities() {
    }

    public static String clipString(FontMetrics metrics, int availableWidth, String fullText) {
        if (metrics.stringWidth(fullText) <= availableWidth) {
            return fullText;
        }
        String ellipses = "...";
        int ellipsesWidth = metrics.stringWidth(ellipses);
        if (ellipsesWidth > availableWidth) {
            return "";
        }
        Object starter = "";
        Object ender = "";
        int w = fullText.length();
        int w2 = w / 2 + w % 2;
        Object prevTitle = "";
        for (int i = 0; i < w2; ++i) {
            String newTitle;
            String newStarter = (String)starter + fullText.charAt(i);
            Object newEnder = ender;
            if (w - i > w2) {
                newEnder = fullText.charAt(w - i - 1) + (String)newEnder;
            }
            if (metrics.stringWidth(newTitle = newStarter + ellipses + (String)newEnder) > availableWidth) {
                return prevTitle;
            }
            starter = newStarter;
            ender = newEnder;
            prevTitle = newTitle;
        }
        return fullText;
    }

    public static boolean hasIcon(AbstractButton button) {
        return button.getIcon() != null;
    }

    public static boolean hasText(AbstractButton button) {
        String text = button.getText();
        return text != null && text.length() > 0;
    }

    public static boolean isComboBoxButton(AbstractButton button) {
        return SwingUtilities.getAncestorOfClass(JComboBox.class, button) != null;
    }

    public static boolean isScrollBarButton(AbstractButton button) {
        return SwingUtilities.getAncestorOfClass(JScrollBar.class, button) != null;
    }

    public static boolean isSpinnerButton(AbstractButton button) {
        if (!(button instanceof SubstanceSpinnerButton)) {
            return false;
        }
        return SwingUtilities.getAncestorOfClass(JSpinner.class, button) != null;
    }

    public static boolean isToolBarButton(JComponent component) {
        if (component.getClass().isAnnotationPresent(SubstanceInternalButton.class)) {
            return false;
        }
        return SwingUtilities.getAncestorOfClass(JToolBar.class, component) != null;
    }

    public static boolean isScrollButton(JComponent comp) {
        return comp instanceof SubstanceScrollButton;
    }

    public static boolean isButtonNeverPainted(JComponent button) {
        JComponent jparent;
        if (button instanceof JCheckBox) {
            return false;
        }
        if (button instanceof JRadioButton) {
            return false;
        }
        Object backgroundAppearanceStrategy = button.getClientProperty("substancelaf.internal.backgroundAppearanceStrategy");
        if (backgroundAppearanceStrategy != null && SubstanceSlices.BackgroundAppearanceStrategy.NEVER.equals(backgroundAppearanceStrategy)) {
            return true;
        }
        Container parent = button.getParent();
        if (parent instanceof JComponent && (backgroundAppearanceStrategy = (jparent = (JComponent)parent).getClientProperty("substancelaf.internal.backgroundAppearanceStrategy")) != null && SubstanceSlices.BackgroundAppearanceStrategy.NEVER.equals(backgroundAppearanceStrategy)) {
            return true;
        }
        return SubstanceSlices.BackgroundAppearanceStrategy.NEVER.equals(UIManager.get("substancelaf.internal.backgroundAppearanceStrategy"));
    }

    public static SubstanceSlices.FocusKind getFocusKind(Component component) {
        while (component != null) {
            JComponent jcomp;
            Object jcompFocusKind;
            if (component instanceof JComponent && (jcompFocusKind = (jcomp = (JComponent)component).getClientProperty("substancelaf.internal.focusKind")) instanceof SubstanceSlices.FocusKind) {
                return (SubstanceSlices.FocusKind)((Object)jcompFocusKind);
            }
            component = component.getParent();
        }
        Object globalFocusKind = UIManager.get("substancelaf.internal.focusKind");
        if (globalFocusKind instanceof SubstanceSlices.FocusKind) {
            return (SubstanceSlices.FocusKind)((Object)globalFocusKind);
        }
        return SubstanceSlices.FocusKind.ALL_INNER;
    }

    public static SubstanceButtonShaper getButtonShaper(Component comp) {
        Object prop;
        if (comp instanceof JComponent && (prop = ((JComponent)comp).getClientProperty("substancelaf.internal.buttonShaper")) instanceof SubstanceButtonShaper) {
            return (SubstanceButtonShaper)prop;
        }
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(comp);
        if (skin == null) {
            return null;
        }
        return skin.getButtonShaper();
    }

    public static SubstanceFillPainter getFillPainter(Component comp) {
        return SubstanceCoreUtilities.getSkin(comp).getFillPainter();
    }

    public static boolean isTabModified(Component tabComponent) {
        if (tabComponent instanceof JComponent) {
            JComponent jc = (JComponent)tabComponent;
            return Boolean.TRUE.equals(jc.getClientProperty("substancelaf.internal.contentsModified"));
        }
        return false;
    }

    public static boolean isRootPaneModified(JRootPane rootPane) {
        return Boolean.TRUE.equals(rootPane.getClientProperty("substancelaf.internal.contentsModified"));
    }

    public static boolean hasCloseButton(JTabbedPane tabbedPane, int tabIndex) {
        Object tabProp;
        int tabCount = tabbedPane.getTabCount();
        if (tabIndex < 0 || tabIndex >= tabCount) {
            return false;
        }
        if (!tabbedPane.isEnabledAt(tabIndex)) {
            return false;
        }
        Component tabComponent = tabbedPane.getComponentAt(tabIndex);
        if (tabComponent instanceof JComponent) {
            Object compProp = ((JComponent)tabComponent).getClientProperty("substancelaf.internal.tabbedPaneHasCloseButtons");
            if (Boolean.TRUE.equals(compProp)) {
                return true;
            }
            if (Boolean.FALSE.equals(compProp)) {
                return false;
            }
        }
        if (Boolean.TRUE.equals(tabProp = tabbedPane.getClientProperty("substancelaf.internal.tabbedPaneHasCloseButtons"))) {
            return true;
        }
        if (Boolean.FALSE.equals(tabProp)) {
            return false;
        }
        return UIManager.getBoolean("substancelaf.internal.tabbedPaneHasCloseButtons");
    }

    public static int getCloseButtonSize(JTabbedPane tabbedPane, int tabIndex) {
        if (!SubstanceCoreUtilities.hasCloseButton(tabbedPane, tabIndex)) {
            return 0;
        }
        return SubstanceSizeUtils.getTabCloseIconSize(SubstanceSizeUtils.getComponentFontSize(tabbedPane));
    }

    public static SubstanceSlices.TabContentPaneBorderKind getContentBorderKind(JTabbedPane tabbedPane) {
        Object tabProp = tabbedPane.getClientProperty("substancelaf.internal.tabbedPaneContentBorderKind");
        if (tabProp instanceof SubstanceSlices.TabContentPaneBorderKind) {
            return (SubstanceSlices.TabContentPaneBorderKind)((Object)tabProp);
        }
        Object globalProp = UIManager.get("substancelaf.internal.tabbedPaneContentBorderKind");
        if (globalProp instanceof SubstanceSlices.TabContentPaneBorderKind) {
            return (SubstanceSlices.TabContentPaneBorderKind)((Object)globalProp);
        }
        return SubstanceSlices.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
    }

    public static boolean toAnimateCloseIconOfModifiedTab(JTabbedPane tabbedPane, int tabIndex) {
        Object tabProp;
        int tabCount = tabbedPane.getTabCount();
        if (tabIndex < 0 || tabIndex >= tabCount) {
            return false;
        }
        if (!SubstanceCoreUtilities.hasCloseButton(tabbedPane, tabIndex)) {
            return false;
        }
        Component tabComponent = tabbedPane.getComponentAt(tabIndex);
        if (tabComponent instanceof JComponent) {
            Object compProp = ((JComponent)tabComponent).getClientProperty("substancelaf.internal.tabbedPaneCloseButtonsModifiedAnimation");
            if (Boolean.TRUE.equals(compProp)) {
                return true;
            }
            if (Boolean.FALSE.equals(compProp)) {
                return false;
            }
        }
        if (Boolean.TRUE.equals(tabProp = tabbedPane.getClientProperty("substancelaf.internal.tabbedPaneCloseButtonsModifiedAnimation"))) {
            return true;
        }
        if (Boolean.FALSE.equals(tabProp)) {
            return false;
        }
        return UIManager.getBoolean("substancelaf.internal.tabbedPaneCloseButtonsModifiedAnimation");
    }

    public static BufferedImage getBlankImage(double scale, int width, int height) {
        if (MemoryAnalyzer.isRunning() && (width >= 100 || height >= 100)) {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            StringBuffer sb = new StringBuffer();
            int count = 0;
            for (StackTraceElement stackEntry : stack) {
                if (count++ > 8) break;
                sb.append(stackEntry.getClassName() + ".");
                sb.append(stackEntry.getMethodName() + " [");
                sb.append(stackEntry.getLineNumber() + "]");
                sb.append("\n");
            }
            MemoryAnalyzer.enqueueUsage("Blank " + width + "*" + height + "\n" + sb.toString());
        }
        return NeonCortex.getBlankScaledImage((double)scale, (int)width, (int)height);
    }

    public static BufferedImage getBlankUnscaledImage(int width, int height) {
        if (MemoryAnalyzer.isRunning() && (width >= 100 || height >= 100)) {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            StringBuffer sb = new StringBuffer();
            int count = 0;
            for (StackTraceElement stackEntry : stack) {
                if (count++ > 8) break;
                sb.append(stackEntry.getClassName() + ".");
                sb.append(stackEntry.getMethodName() + " [");
                sb.append(stackEntry.getLineNumber() + "]");
                sb.append("\n");
            }
            MemoryAnalyzer.enqueueUsage("Blank " + width + "*" + height + "\n" + sb.toString());
        }
        return NeonCortex.getBlankUnscaledImage((int)width, (int)height);
    }

    public static BufferedImage getBlankUnscaledImage(BufferedImage image) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        if (MemoryAnalyzer.isRunning() && (imageWidth >= 100 || imageHeight >= 100)) {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            StringBuffer sb = new StringBuffer();
            int count = 0;
            for (StackTraceElement stackEntry : stack) {
                if (count++ > 8) break;
                sb.append(stackEntry.getClassName() + ".");
                sb.append(stackEntry.getMethodName() + " [");
                sb.append(stackEntry.getLineNumber() + "]");
                sb.append("\n");
            }
            MemoryAnalyzer.enqueueUsage("Blank " + imageWidth + "*" + imageHeight + "\n" + sb.toString());
        }
        return NeonCortex.getBlankUnscaledImage((int)imageWidth, (int)imageHeight);
    }

    public static boolean hasNoMinSizeProperty(AbstractButton button) {
        Object noMinSizeProperty = button.getClientProperty("substancelaf.internal.buttonNoMinSize");
        if (Boolean.TRUE.equals(noMinSizeProperty)) {
            return true;
        }
        if (Boolean.FALSE.equals(noMinSizeProperty)) {
            return false;
        }
        Container parent = button.getParent();
        if (parent instanceof JComponent) {
            noMinSizeProperty = ((JComponent)parent).getClientProperty("substancelaf.internal.buttonNoMinSize");
            if (Boolean.TRUE.equals(noMinSizeProperty)) {
                return true;
            }
            if (Boolean.FALSE.equals(noMinSizeProperty)) {
                return false;
            }
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.internal.buttonNoMinSize"));
    }

    public static void markButtonAsFlat(AbstractButton button) {
        SubstanceCortex.ComponentOrParentScope.setBackgroundAppearanceStrategy(button, SubstanceSlices.BackgroundAppearanceStrategy.FLAT);
        button.setOpaque(false);
    }

    public static boolean hasFlatAppearance(Component comp, boolean defaultValue) {
        JComponent jparent;
        Object backgroundAppearanceStrategyProperty;
        Container parent;
        JComponent jcomp;
        Object backgroundAppearanceStrategyProperty2;
        if (comp instanceof JCheckBox) {
            return defaultValue;
        }
        if (comp instanceof JRadioButton) {
            return defaultValue;
        }
        Component c = comp;
        if (c instanceof JComponent && (backgroundAppearanceStrategyProperty2 = (jcomp = (JComponent)c).getClientProperty("substancelaf.internal.backgroundAppearanceStrategy")) != null && SubstanceSlices.BackgroundAppearanceStrategy.FLAT.equals(backgroundAppearanceStrategyProperty2)) {
            return true;
        }
        if (c != null && (parent = c.getParent()) instanceof JComponent && (backgroundAppearanceStrategyProperty = (jparent = (JComponent)parent).getClientProperty("substancelaf.internal.backgroundAppearanceStrategy")) != null && SubstanceSlices.BackgroundAppearanceStrategy.FLAT.equals(backgroundAppearanceStrategyProperty)) {
            return true;
        }
        Object backgroundAppearanceStrategyProperty3 = UIManager.get("substancelaf.internal.backgroundAppearanceStrategy");
        if (backgroundAppearanceStrategyProperty3 != null && SubstanceSlices.BackgroundAppearanceStrategy.FLAT.equals(backgroundAppearanceStrategyProperty3)) {
            return true;
        }
        return defaultValue;
    }

    public static boolean hasFlatAppearance(AbstractButton button) {
        if (button instanceof JCheckBox) {
            return false;
        }
        if (button instanceof JRadioButton) {
            return false;
        }
        return SubstanceCoreUtilities.isToolBarButton(button) && SubstanceCoreUtilities.hasFlatAppearance(button, true) || SubstanceCoreUtilities.hasFlatAppearance(button, false);
    }

    public static int getPopupFlyoutOrientation(JComboBox combobox) {
        Object comboProperty = combobox.getClientProperty("substancelaf.internal.comboBoxPopupFlyoutOrientation");
        if (comboProperty instanceof Integer) {
            return (Integer)comboProperty;
        }
        Object globalProperty = UIManager.get("substancelaf.internal.comboBoxPopupFlyoutOrientation");
        if (globalProperty instanceof Integer) {
            return (Integer)globalProperty;
        }
        return 5;
    }

    public static void makeNonOpaque(Component comp, Map<Component, Boolean> opacitySnapshot) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            opacitySnapshot.put(comp, jcomp.isOpaque());
            jcomp.setOpaque(false);
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                SubstanceCoreUtilities.makeNonOpaque(cont.getComponent(i), opacitySnapshot);
            }
        }
    }

    public static void restoreOpaque(Component comp, Map<Component, Boolean> opacitySnapshot) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            if (opacitySnapshot.containsKey(comp)) {
                jcomp.setOpaque(opacitySnapshot.get(comp));
            } else {
                jcomp.setOpaque(true);
            }
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                SubstanceCoreUtilities.restoreOpaque(cont.getComponent(i), opacitySnapshot);
            }
        }
    }

    public static SubstanceSlices.IconFilterStrategy getActiveIconFilterStrategy(JComponent comp) {
        if (comp == null || comp.getClass().isAnnotationPresent(SubstanceInternalButton.class)) {
            return SubstanceSlices.IconFilterStrategy.ORIGINAL;
        }
        Object compProperty = comp.getClientProperty("substancelaf.internal.iconFilterStrategyActive");
        if (compProperty instanceof SubstanceSlices.IconFilterStrategy) {
            return (SubstanceSlices.IconFilterStrategy)((Object)compProperty);
        }
        Object globalProperty = UIManager.get("substancelaf.internal.iconFilterStrategyActive");
        if (globalProperty instanceof SubstanceSlices.IconFilterStrategy) {
            return (SubstanceSlices.IconFilterStrategy)((Object)globalProperty);
        }
        return SubstanceSlices.IconFilterStrategy.ORIGINAL;
    }

    public static SubstanceSlices.IconFilterStrategy getEnabledIconFilterStrategy(JComponent comp) {
        if (comp == null || comp.getClass().isAnnotationPresent(SubstanceInternalButton.class)) {
            return SubstanceSlices.IconFilterStrategy.ORIGINAL;
        }
        Object compProperty = comp.getClientProperty("substancelaf.internal.iconFilterStrategyEnabled");
        if (compProperty instanceof SubstanceSlices.IconFilterStrategy) {
            return (SubstanceSlices.IconFilterStrategy)((Object)compProperty);
        }
        Object globalProperty = UIManager.get("substancelaf.internal.iconFilterStrategyEnabled");
        if (globalProperty instanceof SubstanceSlices.IconFilterStrategy) {
            return (SubstanceSlices.IconFilterStrategy)((Object)globalProperty);
        }
        return SubstanceSlices.IconFilterStrategy.ORIGINAL;
    }

    public static SubstanceSlices.IconFilterStrategy getDisabledIconFilterStrategy(JComponent comp) {
        if (comp == null || comp.getClass().isAnnotationPresent(SubstanceInternalButton.class)) {
            return SubstanceSlices.IconFilterStrategy.THEMED_FOLLOW_COLOR_SCHEME;
        }
        Object compProperty = comp.getClientProperty("substancelaf.internal.iconFilterStrategyDisabled");
        if (compProperty instanceof SubstanceSlices.IconFilterStrategy) {
            return (SubstanceSlices.IconFilterStrategy)((Object)compProperty);
        }
        Object globalProperty = UIManager.get("substancelaf.internal.iconFilterStrategyDisabled");
        if (globalProperty instanceof SubstanceSlices.IconFilterStrategy) {
            return (SubstanceSlices.IconFilterStrategy)((Object)globalProperty);
        }
        return SubstanceSlices.IconFilterStrategy.THEMED_FOLLOW_COLOR_SCHEME;
    }

    public static TabCloseCallback getTabCloseCallback(JTabbedPane tabbedPane, int tabIndex) {
        Object compProp;
        int tabCount = tabbedPane.getTabCount();
        if (tabIndex < 0 || tabIndex >= tabCount) {
            return null;
        }
        Component tabComponent = tabbedPane.getComponentAt(tabIndex);
        if (tabComponent instanceof JComponent && (compProp = ((JComponent)tabComponent).getClientProperty("substancelaf.internal.tabbedPaneCloseCallback")) instanceof TabCloseCallback) {
            return (TabCloseCallback)compProp;
        }
        Object tabProp = tabbedPane.getClientProperty("substancelaf.internal.tabbedPaneCloseCallback");
        if (tabProp instanceof TabCloseCallback) {
            return (TabCloseCallback)tabProp;
        }
        Object globProp = UIManager.get("substancelaf.internal.tabbedPaneCloseCallback");
        if (globProp instanceof TabCloseCallback) {
            return (TabCloseCallback)globProp;
        }
        return null;
    }

    public static BufferedImage blendImagesVertical(BufferedImage imageTop, BufferedImage imageBottom, double start, double end) {
        int width = imageTop.getWidth();
        if (width != imageBottom.getWidth()) {
            throw new IllegalArgumentException("Widths are not the same: " + imageTop.getWidth() + " and " + imageBottom.getWidth());
        }
        int height = imageTop.getHeight();
        if (height != imageBottom.getHeight()) {
            throw new IllegalArgumentException("Heights are not the same: " + imageTop.getHeight() + " and " + imageBottom.getHeight());
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankUnscaledImage(imageTop);
        Graphics2D graphics = result.createGraphics();
        int endY = (int)(end * (double)height);
        int startY = (int)(start * (double)height);
        int rampHeight = endY - startY;
        if (rampHeight == 0) {
            graphics.drawImage(imageTop, 0, 0, width, startY, 0, 0, width, startY, null);
            graphics.drawImage(imageBottom, 0, startY, width, height, 0, startY, width, height, null);
        } else {
            BufferedImage rampBottom = SubstanceCoreUtilities.getBlankUnscaledImage(width, rampHeight);
            Graphics2D rampBottomG = (Graphics2D)rampBottom.getGraphics();
            rampBottomG.setPaint(new GradientPaint(new Point(0, 0), new Color(0, 0, 0, 255), new Point(0, rampHeight), new Color(0, 0, 0, 0)));
            rampBottomG.fillRect(0, 0, width, rampHeight);
            BufferedImage tempBottom = SubstanceCoreUtilities.getBlankUnscaledImage(width, height - startY);
            Graphics2D tempBottomG = (Graphics2D)tempBottom.getGraphics();
            tempBottomG.drawImage(imageBottom, 0, 0, width, height - startY, 0, startY, width, height, null);
            tempBottomG.setComposite(AlphaComposite.DstOut);
            tempBottomG.drawImage((Image)rampBottom, 0, 0, null);
            tempBottomG.setComposite(AlphaComposite.SrcOver);
            graphics.drawImage((Image)imageTop, 0, 0, null);
            graphics.drawImage((Image)tempBottom, 0, startY, null);
        }
        graphics.dispose();
        return result;
    }

    public static BufferedImage blendImagesHorizontal(BufferedImage imageLeft, BufferedImage imageRight, double start, double end) {
        int width = imageLeft.getWidth();
        if (width != imageRight.getWidth()) {
            throw new IllegalArgumentException("Widths are not the same: " + imageLeft.getWidth() + " and " + imageRight.getWidth());
        }
        int height = imageLeft.getHeight();
        if (height != imageRight.getHeight()) {
            throw new IllegalArgumentException("Heights are not the same: " + imageLeft.getHeight() + " and " + imageRight.getHeight());
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankUnscaledImage(imageLeft);
        Graphics2D graphics = result.createGraphics();
        int endX = (int)(end * (double)width);
        int startX = (int)(start * (double)width);
        int rampWidth = endX - startX;
        if (rampWidth == 0) {
            graphics.drawImage(imageLeft, 0, 0, startX, height, 0, 0, startX, height, null);
            graphics.drawImage(imageRight, startX, 0, width, height, startX, 0, width, height, null);
        } else {
            BufferedImage rampRight = SubstanceCoreUtilities.getBlankUnscaledImage(rampWidth, height);
            Graphics2D rampRightG = (Graphics2D)rampRight.getGraphics();
            rampRightG.setPaint(new GradientPaint(new Point(0, 0), new Color(0, 0, 0, 255), new Point(rampWidth, 0), new Color(0, 0, 0, 0)));
            rampRightG.fillRect(0, 0, rampWidth, height);
            BufferedImage tempRight = SubstanceCoreUtilities.getBlankUnscaledImage(width - startX, height);
            Graphics2D tempRightG = (Graphics2D)tempRight.getGraphics();
            tempRightG.drawImage(imageRight, 0, 0, width - startX, height, startX, 0, width, height, null);
            tempRightG.setComposite(AlphaComposite.DstOut);
            tempRightG.drawImage((Image)rampRight, 0, 0, null);
            tempRightG.setComposite(AlphaComposite.SrcOver);
            graphics.drawImage((Image)imageLeft, 0, 0, null);
            graphics.drawImage((Image)tempRight, startX, 0, null);
        }
        graphics.dispose();
        return result;
    }

    public static <T> T getComboPopupPrototypeDisplayValue(JComboBox<T> combo) {
        Object callback = combo.getClientProperty("substancelaf.internal.comboPopupPrototype");
        if (callback == null) {
            callback = UIManager.get("substancelaf.internal.comboPopupPrototype");
        }
        if (callback instanceof ComboPopupPrototypeCallback) {
            return ((ComboPopupPrototypeCallback)callback).getPopupPrototypeDisplayValue(combo);
        }
        Object displayValue = combo.getClientProperty("substancelaf.internal.comboPopupPrototype");
        if (displayValue == null) {
            displayValue = UIManager.get("substancelaf.internal.comboPopupPrototype");
        }
        return (T)displayValue;
    }

    public static Set<SubstanceSlices.Side> getSides(JComponent component, String propertyName) {
        if (component == null) {
            return null;
        }
        Object prop = component.getClientProperty(propertyName);
        if (prop == null) {
            return null;
        }
        if (prop instanceof Set) {
            return (Set)prop;
        }
        if (prop instanceof SubstanceSlices.Side) {
            EnumSet<SubstanceSlices.Side> result = EnumSet.noneOf(SubstanceSlices.Side.class);
            result.add((SubstanceSlices.Side)((Object)prop));
            return result;
        }
        return null;
    }

    public static float getToolbarButtonCornerRadius(JComponent button, float insets) {
        float height;
        JToolBar toolbar = null;
        for (Container c = button.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof JToolBar)) continue;
            toolbar = (JToolBar)c;
            break;
        }
        if (toolbar == null) {
            return 2.0f;
        }
        float width = (float)button.getWidth() - 2.0f * insets;
        float maxRadius = width > (height = (float)button.getHeight() - 2.0f * insets) ? height / 2.0f : width / 2.0f;
        Object buttonProp = button.getClientProperty("substancelaf.internal.toolbarButtonCornerRadius");
        if (buttonProp instanceof Float) {
            return Math.min(maxRadius, ((Float)buttonProp).floatValue());
        }
        Object toolbarProp = toolbar.getClientProperty("substancelaf.internal.toolbarButtonCornerRadius");
        if (toolbarProp instanceof Float) {
            return Math.min(maxRadius, ((Float)toolbarProp).floatValue());
        }
        Object globalProp = UIManager.get("substancelaf.internal.toolbarButtonCornerRadius");
        if (globalProp instanceof Float) {
            return Math.min(maxRadius, ((Float)globalProp).floatValue());
        }
        return 2.0f;
    }

    public static int getEchoPerChar(JPasswordField jpf) {
        int result;
        Object obj = jpf.getClientProperty("substancelaf.internal.passwordEchoPerChar");
        if (obj instanceof Integer && (result = ((Integer)obj).intValue()) >= 1) {
            return result;
        }
        obj = UIManager.get("substancelaf.internal.passwordEchoPerChar");
        if (obj instanceof Integer && (result = ((Integer)obj).intValue()) >= 1) {
            return result;
        }
        return 1;
    }

    public static BufferedImage softClip(double scale, int width, int height, BufferedImage source, Shape clipShape) {
        BufferedImage img = SubstanceCoreUtilities.getBlankImage(scale, width, height);
        Graphics2D g2 = img.createGraphics();
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(0, 0, width, height);
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fill(clipShape);
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage((Image)source, 0, 0, null);
        g2.dispose();
        return img;
    }

    public static boolean toShowExtraWidgets(Component component) {
        for (Component c = component; c != null; c = c.getParent()) {
            JComponent jcomp;
            Object componentProp;
            if (!(c instanceof JComponent) || (componentProp = (jcomp = (JComponent)c).getClientProperty("substancelaf.internal.showExtraWidgets")) == null) continue;
            if (Boolean.TRUE.equals(componentProp)) {
                return false;
            }
            if (!Boolean.FALSE.equals(componentProp)) continue;
            return true;
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.internal.showExtraWidgets"));
    }

    public static SubstanceSlices.IconFilterStrategy getIconFilterStrategy(JComponent component, ComponentState componentState) {
        if (componentState.isDisabled()) {
            return SubstanceCoreUtilities.getDisabledIconFilterStrategy(component);
        }
        if (componentState == ComponentState.ENABLED) {
            return SubstanceCoreUtilities.getEnabledIconFilterStrategy(component);
        }
        return SubstanceCoreUtilities.getActiveIconFilterStrategy(component);
    }

    public static Icon getFilteredIcon(JComponent comp, Icon orig, ComponentState componentState, Color textColor) {
        double scale = NeonCortex.getScaleFactor((Component)comp);
        SubstanceSlices.IconFilterStrategy iconFilterStrategy = SubstanceCoreUtilities.getIconFilterStrategy(comp, componentState);
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme(comp, componentState);
        switch (iconFilterStrategy) {
            case ORIGINAL: {
                return orig;
            }
            case THEMED_FOLLOW_TEXT: {
                Color foreground = textColor != null ? textColor : colorScheme.getForegroundColor();
                return new ScaleAwareImageWrapperIcon(SubstanceImageCreator.getColorImage(comp, orig, foreground, 1.0f), scale);
            }
            case THEMED_FOLLOW_COLOR_SCHEME: {
                float brightnessFactor = colorScheme.isDark() ? 0.2f : 0.8f;
                return new ScaleAwareImageWrapperIcon(SubstanceImageCreator.getColorSchemeImage(comp, orig, colorScheme, brightnessFactor), scale);
            }
        }
        return null;
    }

    public static Icon getFilteredIcon(JTabbedPane tab, int tabIndex, Icon orig, ComponentState componentState, Color textColor) {
        double scale = NeonCortex.getScaleFactor((Component)tab);
        SubstanceSlices.IconFilterStrategy iconFilterStrategy = SubstanceCoreUtilities.getIconFilterStrategy(tab, componentState);
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme(tab, componentState);
        switch (iconFilterStrategy) {
            case ORIGINAL: {
                return orig;
            }
            case THEMED_FOLLOW_TEXT: {
                Color foreground = textColor != null ? textColor : colorScheme.getForegroundColor();
                return new ScaleAwareImageWrapperIcon(SubstanceImageCreator.getColorImage(tab, orig, foreground, 1.0f), scale);
            }
            case THEMED_FOLLOW_COLOR_SCHEME: {
                float brightnessFactor = colorScheme.isDark() ? 0.2f : 0.8f;
                return new ScaleAwareImageWrapperIcon(SubstanceImageCreator.getColorSchemeImage(tab, orig, colorScheme, brightnessFactor), scale);
            }
        }
        return null;
    }

    public static Icon getOriginalIcon(AbstractButton b, Icon defaultIcon) {
        ButtonModel model = b.getModel();
        Icon icon = b.getIcon();
        if (icon == null) {
            icon = defaultIcon;
        }
        if (icon.getClass().isAnnotationPresent(TransitionAware.class)) {
            return icon;
        }
        Icon tmpIcon = null;
        if (icon != null) {
            if (!model.isEnabled()) {
                tmpIcon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                tmpIcon = b.getPressedIcon();
            } else if (b.isRolloverEnabled() && model.isRollover()) {
                if (model.isSelected()) {
                    tmpIcon = b.getRolloverSelectedIcon();
                    if (tmpIcon == null) {
                        tmpIcon = b.getSelectedIcon();
                    }
                } else {
                    tmpIcon = b.getRolloverIcon();
                }
            } else if (model.isSelected()) {
                tmpIcon = b.getSelectedIcon();
            }
            if (tmpIcon != null) {
                icon = tmpIcon;
            }
        }
        return icon;
    }

    public static float getMenuGutterFillAlpha() {
        Object globalSetting = UIManager.get("substancelaf.internal.menuGutterFillAlpha");
        if (globalSetting instanceof Float) {
            return ((Float)globalSetting).floatValue();
        }
        return 0.75f;
    }

    public static Container getHeaderParent(Component c) {
        Container result = null;
        for (Container comp = c.getParent(); comp != null; comp = comp.getParent()) {
            if (comp instanceof JLayeredPane && result == null) {
                result = comp;
            }
            if (result != null || !(comp instanceof Window)) continue;
            result = comp;
        }
        return result;
    }

    public static void paintFocus(Graphics g, Component mainComp, Component focusedComp, TransitionAwareUI transitionAwareUI, Shape focusShape, Rectangle textRect, float maxAlphaCoef, float extraPadding) {
        float focusStrength = transitionAwareUI.getTransitionTracker().getFocusStrength(focusedComp.hasFocus());
        if (focusStrength == 0.0f) {
            return;
        }
        SubstanceSlices.FocusKind focusKind = SubstanceCoreUtilities.getFocusKind(mainComp);
        if (focusKind == SubstanceSlices.FocusKind.NONE) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float alpha = maxAlphaCoef * focusStrength;
        graphics.setComposite(WidgetUtilities.getAlphaComposite(mainComp, alpha, g));
        Color color = SubstanceColorUtilities.getFocusColor(mainComp, transitionAwareUI);
        graphics.setColor(color);
        focusKind.paintFocus(mainComp, focusedComp, transitionAwareUI, graphics, focusShape, textRect, extraPadding);
        graphics.dispose();
    }

    public static void paintFocus(Graphics g, Component mainComp, Component focusedComp, TransitionAwareUI transitionAwareUI, Shape focusShape, Rectangle textRect, Color focusColor, float maxAlphaCoef, float extraPadding) {
        float focusStrength = transitionAwareUI.getTransitionTracker().getFocusStrength(focusedComp.hasFocus());
        if (focusStrength == 0.0f) {
            return;
        }
        SubstanceSlices.FocusKind focusKind = SubstanceCoreUtilities.getFocusKind(mainComp);
        if (focusKind == SubstanceSlices.FocusKind.NONE) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float alpha = maxAlphaCoef * focusStrength;
        graphics.setComposite(WidgetUtilities.getAlphaComposite(mainComp, alpha, g));
        graphics.setColor(focusColor);
        focusKind.paintFocus(mainComp, focusedComp, transitionAwareUI, graphics, focusShape, textRect, extraPadding);
        graphics.dispose();
    }

    public static void uninstallMenu(JMenuItem menuItem) {
        SubstanceMenu sMenu;
        ButtonUI menuItemUI;
        if (menuItem instanceof JMenu) {
            JMenu menu = (JMenu)menuItem;
            for (Component comp : menu.getMenuComponents()) {
                if (!(comp instanceof JMenuItem)) continue;
                SubstanceCoreUtilities.uninstallMenu((JMenuItem)comp);
            }
        }
        if ((menuItemUI = menuItem.getUI()) instanceof SubstanceMenu && (sMenu = (SubstanceMenu)((Object)menuItemUI)).getAssociatedMenuItem() != null) {
            menuItemUI.uninstallUI(menuItem);
        }
        for (ActionListener actionListener : menuItem.getActionListeners()) {
            menuItem.removeActionListener(actionListener);
        }
        menuItem.removeAll();
    }

    public static ClassLoader getClassLoaderForResources() {
        ClassLoader cl = (ClassLoader)UIManager.get("ClassLoader");
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        return cl;
    }

    public static boolean isCoveredByLightweightPopups(Component comp) {
        int popupIndexToStartWith;
        JRootPane rootPane = SwingUtilities.getRootPane(comp);
        if (rootPane == null) {
            return false;
        }
        Component[] popups = rootPane.getLayeredPane().getComponentsInLayer(JLayeredPane.POPUP_LAYER);
        if (popups == null) {
            return false;
        }
        Rectangle compBoundsConverted = SwingUtilities.convertRectangle(comp.getParent(), comp.getBounds(), rootPane.getLayeredPane());
        for (int i = popupIndexToStartWith = SubstanceCoreUtilities.getPopupParentIndexOf(comp, popups) - 1; i >= 0; --i) {
            Component popup = popups[i];
            if (!compBoundsConverted.intersects(popup.getBounds())) continue;
            return true;
        }
        return false;
    }

    public static int getPopupParentIndexOf(Component comp, Component[] popups) {
        for (int i = 0; i < popups.length; ++i) {
            Component popup = popups[i];
            for (Component currComp = comp; currComp != null; currComp = currComp.getParent()) {
                if (currComp != popup) continue;
                return i;
            }
        }
        return popups.length;
    }

    public static SubstanceBorderPainter getBorderPainter(Component comp) {
        return SubstanceCoreUtilities.getSkin(comp).getBorderPainter();
    }

    public static SubstanceBorderPainter getHighlightBorderPainter(Component comp) {
        SubstanceBorderPainter result = SubstanceCoreUtilities.getSkin(comp).getHighlightBorderPainter();
        if (result != null) {
            return result;
        }
        return SubstanceCoreUtilities.getBorderPainter(comp);
    }

    public static String getHierarchy(Component comp) {
        StringBuffer buffer = new StringBuffer();
        SubstanceCoreUtilities.getHierarchy(comp, buffer, 0);
        while (comp instanceof Window) {
            Window w = (Window)comp;
            if ((comp = w.getOwner()) == null) continue;
            buffer.append("Owner --->\n");
            SubstanceCoreUtilities.getHierarchy(comp, buffer, 0);
        }
        return buffer.toString();
    }

    public static void getHierarchy(Component comp, StringBuffer buffer, int level) {
        for (int i = 0; i < level; ++i) {
            buffer.append("   ");
        }
        String name = comp.getName();
        if (comp instanceof Dialog) {
            name = ((Dialog)comp).getTitle();
        }
        if (comp instanceof Frame) {
            name = ((Frame)comp).getTitle();
        }
        buffer.append(comp.getClass().getName() + "[" + name + "]\n");
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                SubstanceCoreUtilities.getHierarchy(cont.getComponent(i), buffer, level + 1);
            }
        }
    }

    public static Icon getArrowIcon(AbstractButton button, int orientation) {
        ArrowButtonTransitionAwareIcon result = new ArrowButtonTransitionAwareIcon(button, orientation);
        return result;
    }

    public static Icon getArrowIcon(JComponent comp, TransitionAwareIcon.TransitionAwareUIDelegate transitionAwareUIDelegate, int orientation) {
        ArrowButtonTransitionAwareIcon result = new ArrowButtonTransitionAwareIcon(comp, transitionAwareUIDelegate, orientation);
        return result;
    }

    public static double getColorizationFactor(Component c) {
        Component invoker;
        JPopupMenu popupMenu = null;
        while (c != null) {
            JComponent jcomp;
            Object compProp;
            if (c instanceof JComponent && (compProp = (jcomp = (JComponent)c).getClientProperty("substancelaf.internal.colorizationFactor")) instanceof Double) {
                return (Double)compProp;
            }
            if (c instanceof JPopupMenu) {
                popupMenu = (JPopupMenu)c;
            }
            c = c.getParent();
        }
        if (popupMenu != null && popupMenu != (invoker = popupMenu.getInvoker())) {
            return SubstanceCoreUtilities.getColorizationFactor(popupMenu.getInvoker());
        }
        Object globalProp = UIManager.get("substancelaf.internal.colorizationFactor");
        if (globalProp instanceof Double) {
            return (Double)globalProp;
        }
        return 0.5;
    }

    public static SubstanceSkin getSkin(Component c) {
        Object skinProp;
        Container frame;
        if (!SubstanceCoreUtilities.isCurrentLookAndFeel()) {
            return null;
        }
        if (!SubstanceRootPaneUI.hasCustomSkinOnAtLeastOneRootPane()) {
            return SubstanceCortex.GlobalScope.getCurrentSkin();
        }
        SubstanceComboPopup comboPopup = (SubstanceComboPopup)SwingUtilities.getAncestorOfClass(SubstanceComboPopup.class, c);
        if (comboPopup != null) {
            return SubstanceCoreUtilities.getSkin(comboPopup.getCombobox());
        }
        JRootPane rootPane = SwingUtilities.getRootPane(c);
        if (c instanceof SubstanceInternalFrameTitlePane && (frame = c.getParent()) instanceof JInternalFrame) {
            rootPane = ((JInternalFrame)frame).getRootPane();
        }
        if (c != null && c.getParent() instanceof SubstanceInternalFrameTitlePane && (frame = c.getParent().getParent()) instanceof JInternalFrame) {
            rootPane = ((JInternalFrame)frame).getRootPane();
        }
        if (rootPane != null && (skinProp = rootPane.getClientProperty("substancelaf.internal.rootPaneSkin")) instanceof SubstanceSkin) {
            return (SubstanceSkin)skinProp;
        }
        return SubstanceCortex.GlobalScope.getCurrentSkin();
    }

    public static HashMapKey getHashKey(Object ... objects) {
        return new HashMapKey(objects);
    }

    public static ImageHashMapKey getScaleAwareHashKey(double scale, Object ... objects) {
        return new ImageHashMapKey(scale, objects);
    }

    public static void stopThreads() {
        TrackableThread.requestStopAllThreads();
    }

    public static void testComponentCreationThreadingViolation(Component comp) {
        if (!SwingUtilities.isEventDispatchThread()) {
            UiThreadingViolationException uiThreadingViolationError = new UiThreadingViolationException("Component creation must be done on Event Dispatch Thread");
            uiThreadingViolationError.printStackTrace(System.err);
            throw uiThreadingViolationError;
        }
    }

    public static void testComponentStateChangeThreadingViolation(Component comp) {
        if (!SwingUtilities.isEventDispatchThread()) {
            UiThreadingViolationException uiThreadingViolationError = new UiThreadingViolationException("Component state change must be done on Event Dispatch Thread");
            uiThreadingViolationError.printStackTrace(System.err);
            throw uiThreadingViolationError;
        }
    }

    public static void testWindowCloseThreadingViolation(Window w) {
        if (!SwingUtilities.isEventDispatchThread()) {
            UiThreadingViolationException uiThreadingViolationError = new UiThreadingViolationException("Window close must be done on Event Dispatch Thread");
            uiThreadingViolationError.printStackTrace(System.err);
            throw uiThreadingViolationError;
        }
    }

    public static void traceSubstanceApiUsage(Component comp, String message) {
        Window w = SwingUtilities.getWindowAncestor(comp);
        String wTitle = null;
        if (w instanceof Frame) {
            wTitle = ((Frame)w).getTitle();
        }
        if (w instanceof Dialog) {
            wTitle = ((Dialog)w).getTitle();
        }
        String wClassName = w != null ? w.getClass().getName() : null;
        throw new IllegalArgumentException(message + " [component " + comp.getClass().getSimpleName() + " in window " + wClassName + ":'" + wTitle + "' under " + UIManager.getLookAndFeel().getName() + "]");
    }

    public static BufferedImage getScaledIconImage(double scale, List<Image> imageList, int width, int height) {
        if (width == 0 || height == 0) {
            return null;
        }
        Image bestImage = null;
        int bestWidth = 0;
        int bestHeight = 0;
        double bestSimilarity = 3.0;
        for (Image im : imageList) {
            int ih;
            int iw;
            if (im == null) continue;
            try {
                iw = im.getWidth(null);
                ih = im.getHeight(null);
            }
            catch (Exception e) {
                continue;
            }
            if (iw <= 0 || ih <= 0) continue;
            double scaleFactor = Math.min((double)width / (double)iw, (double)height / (double)ih);
            int adjw = 0;
            int adjh = 0;
            double scaleMeasure = 1.0;
            if (scaleFactor >= 2.0) {
                scaleFactor = Math.floor(scaleFactor);
                adjw = iw * (int)scaleFactor;
                adjh = ih * (int)scaleFactor;
                scaleMeasure = 1.0 - 0.5 / scaleFactor;
            } else if (scaleFactor >= 1.0) {
                scaleFactor = 1.0;
                adjw = iw;
                adjh = ih;
                scaleMeasure = 0.0;
            } else if (scaleFactor >= 0.75) {
                scaleFactor = 0.75;
                adjw = iw * 3 / 4;
                adjh = ih * 3 / 4;
                scaleMeasure = 0.3;
            } else if (scaleFactor >= 0.6666) {
                scaleFactor = 0.6666;
                adjw = iw * 2 / 3;
                adjh = ih * 2 / 3;
                scaleMeasure = 0.33;
            } else {
                double scaleDivider = Math.ceil(1.0 / scaleFactor);
                scaleFactor = 1.0 / scaleDivider;
                adjw = (int)Math.round((double)iw / scaleDivider);
                adjh = (int)Math.round((double)ih / scaleDivider);
                scaleMeasure = 1.0 - 1.0 / scaleDivider;
            }
            double similarity = ((double)width - (double)adjw) / (double)width + ((double)height - (double)adjh) / (double)height + scaleMeasure;
            if (similarity < bestSimilarity) {
                bestSimilarity = similarity;
                bestImage = im;
                bestWidth = adjw;
                bestHeight = adjh;
            }
            if (similarity != 0.0) continue;
            break;
        }
        if (bestImage == null) {
            return null;
        }
        BufferedImage bimage = SubstanceCoreUtilities.getBlankImage(scale, width, height);
        Graphics2D g = bimage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        int x = (width - bestWidth) / 2;
        int y = (height - bestHeight) / 2;
        g.drawImage(bestImage, x, y, bestWidth, bestHeight, null);
        g.dispose();
        return bimage;
    }

    public static boolean canReplaceChildBackgroundColor(Color background) {
        return background instanceof UIResource || background instanceof SubstanceColorResource;
    }

    public static JTextComponent getTextComponentForTransitions(Component c) {
        if (!(c instanceof JComponent)) {
            return null;
        }
        JComponent jc = (JComponent)c;
        TextComponentAware tcaui = (TextComponentAware)jc.getClientProperty(TEXT_COMPONENT_AWARE);
        if (tcaui != null) {
            return tcaui.getTextComponent(jc);
        }
        if (c instanceof JTextComponent) {
            return (JTextComponent)c;
        }
        return null;
    }

    public static SwingRepaintCallback getTextComponentRepaintCallback(JTextComponent textComponent) {
        for (Container c = textComponent; c != null; c = c.getParent()) {
            TextComponentAware tcaui;
            if (!(c instanceof JComponent) || (tcaui = (TextComponentAware)((JComponent)c).getClientProperty(TEXT_COMPONENT_AWARE)) == null) continue;
            return new SwingRepaintCallback((Component)c);
        }
        return new SwingRepaintCallback((Component)textComponent);
    }

    public static boolean isOpaque(JComponent c) {
        return c.isOpaque();
    }

    public static boolean isCurrentLookAndFeel() {
        return SubstanceCortex.GlobalScope.getCurrentSkin() != null;
    }

    public static int getButtonBarGravity(Container c) {
        boolean isLeftToRight = c.getComponentOrientation().isLeftToRight();
        SubstanceSlices.HorizontalGravity buttonBarGravity = SubstanceCortex.GlobalScope.getButtonBarGravity();
        switch (buttonBarGravity) {
            case PLATFORM: {
                return LookUtils.IS_OS_MAC ? (isLeftToRight ? 4 : 2) : 0;
            }
            case LEADING: {
                return isLeftToRight ? 2 : 4;
            }
            case CENTERED: 
            case SWING_DEFAULT: {
                return 0;
            }
            case TRAILING: {
                return isLeftToRight ? 4 : 2;
            }
        }
        throw new IllegalStateException("Unknown button alignment " + buttonBarGravity);
    }

    public static JComponent getTitlePaneComponent(Window window) {
        JRootPane rootPane = SwingUtilities.getRootPane(window);
        if (rootPane != null) {
            SubstanceRootPaneUI ui = (SubstanceRootPaneUI)rootPane.getUI();
            return ui.getTitlePane();
        }
        return null;
    }

    public static void updateActiveUi() {
        for (Window window : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(window);
        }
        for (MenuElement menuElement : MenuSelectionManager.defaultManager().getSelectedPath()) {
            if (!(menuElement instanceof JPopupMenu)) continue;
            SwingUtilities.updateComponentTreeUI((JPopupMenu)menuElement);
        }
    }

    public static Point getOffsetInRootPaneCoords(Component comp) {
        JLayeredPane layeredPane;
        if (comp == null) {
            throw new IllegalArgumentException("Cannot pass null component");
        }
        JRootPane rootPane = SwingUtilities.getRootPane(comp);
        int dx = 0;
        int dy = 0;
        if (rootPane != null && (layeredPane = rootPane.getLayeredPane()) != null) {
            Insets layeredPaneInsets = layeredPane.getInsets();
            if (comp.isShowing() && layeredPane.isShowing()) {
                dx += comp.getLocationOnScreen().x - layeredPane.getLocationOnScreen().x + layeredPaneInsets.left;
                dy += comp.getLocationOnScreen().y - layeredPane.getLocationOnScreen().y + layeredPaneInsets.top;
            } else {
                Component c;
                dx = 0;
                dy = 0;
                for (c = comp; c != rootPane; c = c.getParent()) {
                    dx += c.getX();
                    dy += c.getY();
                }
                c = layeredPane;
                if (c != null && c.getParent() != null) {
                    while (c != rootPane) {
                        dx -= c.getX();
                        dy -= c.getY();
                        c = c.getParent();
                    }
                }
                dx += layeredPaneInsets.left;
                dy += layeredPaneInsets.right;
            }
        }
        return new Point(dx, dy);
    }

    public static Component getTopMostParentWithDecorationAreaType(Component comp, SubstanceSlices.DecorationAreaType type) {
        Component c;
        if (comp == null) {
            throw new IllegalArgumentException("Component scope APIs do not accept null components");
        }
        Component topMostWithSameDecorationAreaType = c = comp;
        while (c != null) {
            if (DecorationPainterUtils.getImmediateDecorationType(c) == type) {
                topMostWithSameDecorationAreaType = c;
            }
            c = c.getParent();
        }
        return topMostWithSameDecorationAreaType;
    }

    public static synchronized void registerAWTEventListener(AWTEventListener awtEventListener) {
        if (awtEventListeners.contains(awtEventListener)) {
            return;
        }
        awtEventListeners.add(awtEventListener);
    }

    public static synchronized void unregisterAWTEventListener(AWTEventListener awtEventListener) {
        awtEventListeners.remove(awtEventListener);
    }

    public static synchronized List<AWTEventListener> getAwtEventListeners() {
        return awtEventListeners;
    }

    public static Color getBackgroundFill(SubstanceSkin skin, SubstanceSlices.DecorationAreaType decorationAreaType) {
        Color overlay = skin.getOverlayColor(SubstanceSlices.ColorOverlayType.BACKGROUND_FILL, decorationAreaType, ComponentState.ENABLED);
        if (overlay != null) {
            return overlay;
        }
        return skin.getBackgroundColorScheme(decorationAreaType).getBackgroundFillColor();
    }

    public static Color getTextBackgroundFill(Component component, ComponentState componentState) {
        SubstanceSlices.DecorationAreaType decorationAreaType;
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(component);
        Color overlay = skin.getOverlayColor(SubstanceSlices.ColorOverlayType.TEXT_BACKGROUND_FILL, decorationAreaType = DecorationPainterUtils.getDecorationType(component), componentState);
        if (overlay != null) {
            return overlay;
        }
        return SubstanceColorSchemeUtilities.getColorScheme(component, componentState).getTextBackgroundFillColor();
    }

    public static Color getTextSelectionBackground(Component component, ComponentState componentState) {
        SubstanceSlices.DecorationAreaType decorationAreaType;
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(component);
        Color overlay = skin.getOverlayColor(SubstanceSlices.ColorOverlayType.SELECTION_BACKGROUND_FILL, decorationAreaType = DecorationPainterUtils.getDecorationType(component), componentState);
        if (overlay != null) {
            return overlay;
        }
        return SubstanceColorSchemeUtilities.getColorScheme(component, SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT_TEXT, componentState).getSelectionBackgroundColor();
    }

    public static Color getTextSelectionForeground(Component component, ComponentState componentState) {
        SubstanceSlices.DecorationAreaType decorationAreaType;
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(component);
        Color overlay = skin.getOverlayColor(SubstanceSlices.ColorOverlayType.SELECTION_FOREGROUND, decorationAreaType = DecorationPainterUtils.getDecorationType(component), componentState);
        if (overlay != null) {
            return overlay;
        }
        return SubstanceColorSchemeUtilities.getColorScheme(component, SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT_TEXT, componentState).getSelectionForegroundColor();
    }

    public static interface TextComponentAware<T extends JComponent> {
        public JTextComponent getTextComponent(T var1);
    }
}

