/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.MatteFillPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.api.shaper.RectangularButtonShaper;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.ImageHashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;

public class PairwiseButtonBackgroundDelegate {
    private static LazyResettableHashMap<BufferedImage> pairwiseBackgrounds = new LazyResettableHashMap("PairwiseButtonBackgroundDelegate");

    static void updatePairwiseBackground(Graphics g, AbstractButton button, int width, int height, boolean toIgnoreOpenSides) {
        if (SubstanceCoreUtilities.isButtonNeverPainted(button)) {
            return;
        }
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(button);
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)button.getUI());
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        ComponentState currState = modelStateInfo.getCurrModelState();
        SubstanceColorScheme baseFillScheme = SubstanceColorSchemeUtilities.getColorScheme(button, currState);
        SubstanceColorScheme baseBorderScheme = SubstanceColorSchemeUtilities.getColorScheme(button, SubstanceSlices.ColorSchemeAssociationKind.BORDER, currState);
        SubstanceFillPainter fillPainter = SubstanceCoreUtilities.isSpinnerButton(button) ? MatteFillPainter.INSTANCE : SubstanceImageCreator.SimplisticSoftBorderReverseFillPainter.INSTANCE;
        Set<SubstanceSlices.Side> openSides = toIgnoreOpenSides ? EnumSet.noneOf(SubstanceSlices.Side.class) : SubstanceCoreUtilities.getSides(button, "substancelaf.internal.buttonOpenSide");
        boolean needsRotation = openSides != null && (openSides.contains((Object)SubstanceSlices.Side.BOTTOM) || openSides.contains((Object)SubstanceSlices.Side.TOP));
        BufferedImage baseLayer = PairwiseButtonBackgroundDelegate.getPairwiseFullAlphaBackground(button, fillPainter, shaper, width, height, baseFillScheme, baseBorderScheme, toIgnoreOpenSides, needsRotation);
        BufferedImage fullOpacity = null;
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        if (currState.isDisabled() || activeStates.size() == 1) {
            fullOpacity = baseLayer;
        } else {
            fullOpacity = SubstanceCoreUtilities.getBlankUnscaledImage(baseLayer);
            Graphics2D g2fullOpacity = fullOpacity.createGraphics();
            g2fullOpacity.drawImage(baseLayer, 0, 0, baseLayer.getWidth(), baseLayer.getHeight(), null);
            for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                float contribution;
                ComponentState activeState = activeEntry.getKey();
                if (activeState == currState || (contribution = activeEntry.getValue().getContribution()) == 0.0f) continue;
                SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme(button, activeState);
                SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme(button, SubstanceSlices.ColorSchemeAssociationKind.BORDER, activeState);
                BufferedImage layer = PairwiseButtonBackgroundDelegate.getPairwiseFullAlphaBackground(button, fillPainter, shaper, width, height, fillScheme, borderScheme, toIgnoreOpenSides, needsRotation);
                g2fullOpacity.setComposite(AlphaComposite.SrcOver.derive(contribution));
                g2fullOpacity.drawImage(layer, 0, 0, layer.getWidth(), layer.getHeight(), null);
            }
            g2fullOpacity.dispose();
        }
        boolean isFlat = SubstanceCoreUtilities.hasFlatAppearance(button);
        boolean isSpecial = isFlat || !button.isEnabled();
        float extraAlpha = 1.0f;
        if (isSpecial) {
            if (isFlat) {
                extraAlpha = 0.0f;
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                    ComponentState activeState = activeEntry.getKey();
                    if (activeState.isDisabled() || activeState == ComponentState.ENABLED) continue;
                    extraAlpha += activeEntry.getValue().getContribution();
                }
            } else if (!button.isEnabled()) {
                extraAlpha = SubstanceColorSchemeUtilities.getAlpha(button, currState);
            }
        }
        if (extraAlpha > 0.0f) {
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setComposite(WidgetUtilities.getAlphaComposite(button, extraAlpha, g));
            NeonCortex.drawImageWithScale((Graphics)graphics, (double)NeonCortex.getScaleFactor((Component)button), (Image)fullOpacity, (int)0, (int)0);
            graphics.dispose();
        }
    }

    private static BufferedImage getPairwiseFullAlphaBackground(AbstractButton button, SubstanceFillPainter fillPainter, SubstanceButtonShaper shaper, int width, int height, SubstanceColorScheme colorScheme, SubstanceColorScheme borderScheme, boolean toIgnoreOpenSides, boolean needsRotation) {
        ImageHashMapKey key;
        BufferedImage finalBackground;
        if (SubstanceCoreUtilities.isButtonNeverPainted(button)) {
            return null;
        }
        double scale = NeonCortex.getScaleFactor((Component)button);
        Set<SubstanceSlices.Side> openSides = toIgnoreOpenSides ? EnumSet.noneOf(SubstanceSlices.Side.class) : SubstanceCoreUtilities.getSides(button, "substancelaf.internal.buttonOpenSide");
        Set<SubstanceSlices.Side> straightSides = SubstanceCoreUtilities.getSides(button, "substancelaf.internal.buttonStraightSide");
        boolean isBorderPainted = button.isBorderPainted();
        boolean isContentAreaFilled = button.isContentAreaFilled();
        float radius = 0.0f;
        if (SubstanceCoreUtilities.isSpinnerButton(button) && shaper instanceof RectangularButtonShaper) {
            radius = ((RectangularButtonShaper)((Object)shaper)).getCornerRadius(button, 0.0f);
        }
        if ((finalBackground = pairwiseBackgrounds.get(key = SubstanceCoreUtilities.getScaleAwareHashKey(scale, width, height, straightSides, openSides, colorScheme.getDisplayName(), borderScheme.getDisplayName(), button.getClass().getName(), fillPainter.getDisplayName(), shaper.getDisplayName(), isBorderPainted, isContentAreaFilled, Float.valueOf(radius)))) == null) {
            int deltaLeft = openSides != null && openSides.contains((Object)SubstanceSlices.Side.LEFT) ? 3 : 0;
            int deltaRight = openSides != null && openSides.contains((Object)SubstanceSlices.Side.RIGHT) ? 3 : 0;
            int deltaTop = openSides != null && openSides.contains((Object)SubstanceSlices.Side.TOP) ? 3 : 0;
            int deltaBottom = openSides != null && openSides.contains((Object)SubstanceSlices.Side.BOTTOM) ? 3 : 0;
            Shape contour = null;
            SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(button);
            float borderDelta = SubstanceSizeUtils.getBorderStrokeWidth(button) / 2.0f;
            finalBackground = SubstanceCoreUtilities.getBlankImage(scale, width, height);
            Graphics2D finalGraphics = (Graphics2D)finalBackground.getGraphics();
            finalGraphics.translate(-deltaLeft, -deltaTop);
            if (needsRotation) {
                contour = SubstanceOutlineUtilities.getBaseOutline(height + deltaTop + deltaBottom, width + deltaLeft + deltaRight, radius, null, borderDelta);
                int translateY = finalBackground.getHeight();
                if (SubstanceCoreUtilities.isScrollButton(button) && openSides != null && openSides.contains((Object)SubstanceSlices.Side.BOTTOM)) {
                    translateY += 4;
                }
                AffineTransform at = AffineTransform.getTranslateInstance(0.0, translateY);
                at.rotate(-1.5707963267948966);
                finalGraphics.scale(1.0, 1.0);
                finalGraphics.setTransform(at);
                finalGraphics.scale(scale, scale);
                if (isContentAreaFilled) {
                    fillPainter.paintContourBackground(finalGraphics, button, height + deltaTop + deltaBottom, width + deltaLeft + deltaRight, contour, false, colorScheme, true);
                }
                if (isBorderPainted) {
                    borderPainter.paintBorder(finalGraphics, button, height + deltaTop + deltaBottom, width + deltaLeft + deltaRight, contour, null, borderScheme);
                }
            } else {
                contour = SubstanceOutlineUtilities.getBaseOutline(width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, radius, straightSides, borderDelta);
                if (SubstanceCoreUtilities.isScrollButton(button) && openSides != null && openSides.contains((Object)SubstanceSlices.Side.LEFT)) {
                    finalGraphics.translate(1, 0);
                }
                if (isContentAreaFilled) {
                    fillPainter.paintContourBackground(finalGraphics, button, width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, contour, false, colorScheme, true);
                }
                if (isBorderPainted) {
                    borderPainter.paintBorder(finalGraphics, button, width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, contour, null, borderScheme);
                }
            }
            pairwiseBackgrounds.put(key, finalBackground);
        }
        return finalBackground;
    }
}

