/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.skin;

import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorSchemeBundle;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.ColorSchemeSingleColorQuery;
import org.pushingpixels.substance.api.colorscheme.ColorTransform;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.ClassicBorderPainter;
import org.pushingpixels.substance.api.painter.border.CompositeBorderPainter;
import org.pushingpixels.substance.api.painter.border.DelegateBorderPainter;
import org.pushingpixels.substance.api.painter.border.FractionBasedBorderPainter;
import org.pushingpixels.substance.api.painter.decoration.MatteDecorationPainter;
import org.pushingpixels.substance.api.painter.fill.FractionBasedFillPainter;
import org.pushingpixels.substance.api.painter.highlight.ClassicHighlightPainter;
import org.pushingpixels.substance.api.painter.overlay.BottomLineOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.BottomShadowOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.TopLineOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.TopShadowOverlayPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;

public class MagellanSkin
extends SubstanceSkin {
    public static final String NAME = "Magellan";
    private BottomLineOverlayPainter toolbarBottomLineOverlayPainter;
    private TopLineOverlayPainter toolbarTopLineOverlayPainter;
    private TopShadowOverlayPainter footerTopShadowOverlayPainter;

    @Override
    public String getDisplayName() {
        return NAME;
    }

    public MagellanSkin() {
        SubstanceSkin.ColorSchemes colorSchemes = SubstanceSkin.getColorSchemes(this.getClass().getClassLoader().getResourceAsStream("org/pushingpixels/substance/api/skin/magellan.colorschemes"));
        SubstanceColorScheme blueControlsActive = colorSchemes.get("Magellan Blue Controls Active");
        SubstanceColorScheme blueControlsEnabled = colorSchemes.get("Magellan Blue Controls Enabled");
        SubstanceColorSchemeBundle defaultColorSchemeBundle = new SubstanceColorSchemeBundle(blueControlsActive, blueControlsEnabled, blueControlsEnabled);
        defaultColorSchemeBundle.registerAlpha(0.5f, ComponentState.DISABLED_SELECTED, ComponentState.DISABLED_UNSELECTED);
        defaultColorSchemeBundle.registerColorScheme(blueControlsEnabled, ComponentState.DISABLED_UNSELECTED);
        defaultColorSchemeBundle.registerColorScheme(blueControlsActive, ComponentState.DISABLED_SELECTED);
        SubstanceColorScheme blueControlsActiveBorder = colorSchemes.get("Magellan Blue Controls Active Border");
        SubstanceColorScheme blueControlsEnabledBorder = colorSchemes.get("Magellan Blue Controls Enabled Border");
        defaultColorSchemeBundle.registerColorScheme(blueControlsActiveBorder, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.getActiveStates());
        defaultColorSchemeBundle.registerColorScheme(blueControlsActiveBorder, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.DISABLED_SELECTED);
        defaultColorSchemeBundle.registerColorScheme(blueControlsEnabledBorder, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED, ComponentState.DISABLED_UNSELECTED);
        defaultColorSchemeBundle.registerColorScheme(blueControlsActiveBorder, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.SELECTED);
        defaultColorSchemeBundle.registerAlpha(0.5f, ComponentState.DISABLED_SELECTED);
        defaultColorSchemeBundle.registerColorScheme(blueControlsActiveBorder, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.DISABLED_SELECTED);
        SubstanceColorScheme blueControlsPressed = colorSchemes.get("Magellan Blue Controls Pressed");
        SubstanceColorScheme blueControlsPressedBorder = colorSchemes.get("Magellan Blue Controls Pressed Border");
        defaultColorSchemeBundle.registerColorScheme(blueControlsPressed, SubstanceSlices.ColorSchemeAssociationKind.FILL, ComponentState.PRESSED_SELECTED, ComponentState.PRESSED_UNSELECTED);
        defaultColorSchemeBundle.registerColorScheme(blueControlsPressedBorder, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.PRESSED_SELECTED, ComponentState.PRESSED_UNSELECTED);
        SubstanceColorScheme greenControls = colorSchemes.get("Magellan Green Controls");
        SubstanceColorScheme greenControlsRollover = colorSchemes.get("Magellan Green Controls Rollover");
        SubstanceColorScheme blueActiveControlsPressed = colorSchemes.get("Magellan Blue Active Controls Pressed");
        SubstanceColorScheme greenControlsMark = colorSchemes.get("Magellan Green Controls Mark");
        SubstanceColorScheme activeControlsBorder = colorSchemes.get("Magellan Green Controls Border");
        defaultColorSchemeBundle.registerColorScheme(greenControlsRollover, SubstanceSlices.ColorSchemeAssociationKind.FILL, ComponentState.ROLLOVER_SELECTED, ComponentState.ROLLOVER_UNSELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        defaultColorSchemeBundle.registerColorScheme(blueActiveControlsPressed, SubstanceSlices.ColorSchemeAssociationKind.FILL, ComponentState.PRESSED_SELECTED, ComponentState.PRESSED_UNSELECTED);
        defaultColorSchemeBundle.registerColorScheme(greenControlsMark, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.ROLLOVER_SELECTED, ComponentState.ROLLOVER_UNSELECTED, ComponentState.PRESSED_UNSELECTED, ComponentState.PRESSED_SELECTED, ComponentState.SELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        defaultColorSchemeBundle.registerColorScheme(activeControlsBorder, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ROLLOVER_SELECTED, ComponentState.ROLLOVER_UNSELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        defaultColorSchemeBundle.registerColorScheme(greenControls, SubstanceSlices.ColorSchemeAssociationKind.MARK_BOX, ComponentState.SELECTED);
        defaultColorSchemeBundle.registerColorScheme(greenControlsRollover, SubstanceSlices.ColorSchemeAssociationKind.MARK_BOX, ComponentState.ROLLOVER_SELECTED, ComponentState.ROLLOVER_UNSELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        defaultColorSchemeBundle.registerColorScheme(blueActiveControlsPressed, SubstanceSlices.ColorSchemeAssociationKind.MARK_BOX, ComponentState.PRESSED_UNSELECTED, ComponentState.PRESSED_SELECTED);
        defaultColorSchemeBundle.registerColorScheme(blueControlsActive, SubstanceSlices.ColorSchemeAssociationKind.FILL, ComponentState.SELECTED);
        defaultColorSchemeBundle.registerColorScheme(greenControls, SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT_TEXT, new ComponentState[0]);
        defaultColorSchemeBundle.registerHighlightAlpha(0.75f, ComponentState.ROLLOVER_UNSELECTED);
        defaultColorSchemeBundle.registerHighlightAlpha(0.85f, ComponentState.SELECTED);
        defaultColorSchemeBundle.registerHighlightAlpha(0.95f, ComponentState.ROLLOVER_SELECTED);
        defaultColorSchemeBundle.registerHighlightAlpha(1.0f, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        defaultColorSchemeBundle.registerHighlightColorScheme(greenControls, ComponentState.ROLLOVER_UNSELECTED, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        defaultColorSchemeBundle.registerColorScheme(blueControlsActive.tint(0.2), SubstanceSlices.ColorSchemeAssociationKind.TAB, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED);
        SubstanceColorScheme lightBlueBackground = colorSchemes.get("Magellan Light Blue Background");
        this.registerDecorationAreaSchemeBundle(defaultColorSchemeBundle, lightBlueBackground, SubstanceSlices.DecorationAreaType.NONE);
        SubstanceColorScheme mediumBlueBackground = colorSchemes.get("Magellan Medium Blue Background");
        SubstanceColorScheme darkBlueBackground = colorSchemes.get("Magellan Dark Blue Background");
        this.registerAsDecorationArea(mediumBlueBackground, SubstanceSlices.DecorationAreaType.CONTROL_PANE, SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.registerAsDecorationArea(darkBlueBackground, SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.HEADER);
        SubstanceColorScheme lightBlueControlsActive = colorSchemes.get("Magellan Light Blue Controls Active");
        SubstanceColorScheme lightBlueControlsEnabled = colorSchemes.get("Magellan Light Blue Controls Enabled");
        SubstanceColorScheme lightBlueBordersEnabled = colorSchemes.get("Magellan Light Blue Borders Enabled");
        SubstanceColorSchemeBundle footerColorSchemeBundle = new SubstanceColorSchemeBundle(lightBlueControlsActive, lightBlueControlsEnabled, lightBlueControlsEnabled);
        footerColorSchemeBundle.registerAlpha(0.5f, ComponentState.DISABLED_SELECTED, ComponentState.DISABLED_UNSELECTED);
        footerColorSchemeBundle.registerColorScheme(lightBlueControlsEnabled, ComponentState.DISABLED_UNSELECTED);
        footerColorSchemeBundle.registerColorScheme(lightBlueControlsActive, ComponentState.DISABLED_SELECTED);
        footerColorSchemeBundle.registerColorScheme(lightBlueBordersEnabled, SubstanceSlices.ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
        SubstanceColorScheme lightBlueSeparator = colorSchemes.get("Magellan Light Blue Separator");
        footerColorSchemeBundle.registerColorScheme(lightBlueSeparator, SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        footerColorSchemeBundle.registerColorScheme(blueControlsEnabled, SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT_TEXT, new ComponentState[0]);
        SubstanceColorScheme ultraLightBlueBackground = colorSchemes.get("Magellan Ultralight Blue Background");
        this.registerDecorationAreaSchemeBundle(footerColorSchemeBundle, ultraLightBlueBackground, SubstanceSlices.DecorationAreaType.FOOTER);
        this.addOverlayPainter(BottomShadowOverlayPainter.getInstance(100), SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.toolbarBottomLineOverlayPainter = new BottomLineOverlayPainter(ColorSchemeSingleColorQuery.ULTRADARK);
        this.addOverlayPainter(this.toolbarBottomLineOverlayPainter, SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.toolbarTopLineOverlayPainter = new TopLineOverlayPainter(ColorSchemeSingleColorQuery.composite(ColorSchemeSingleColorQuery.FOREGROUND, ColorTransform.alpha(40)));
        this.addOverlayPainter(this.toolbarTopLineOverlayPainter, SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.footerTopShadowOverlayPainter = TopShadowOverlayPainter.getInstance(100);
        this.addOverlayPainter(this.footerTopShadowOverlayPainter, SubstanceSlices.DecorationAreaType.FOOTER);
        this.setTabFadeStart(0.18);
        this.setTabFadeEnd(0.18);
        FractionBasedBorderPainter outerBorderPainter = new FractionBasedBorderPainter("Magellan Outer", new float[]{0.0f, 0.5f, 1.0f}, new ColorSchemeSingleColorQuery[]{ColorSchemeSingleColorQuery.ULTRADARK, ColorSchemeSingleColorQuery.DARK, ColorSchemeSingleColorQuery.DARK});
        DelegateBorderPainter innerBorderPainter = new DelegateBorderPainter("Magellan Inner", new ClassicBorderPainter(), -1593835521, 0x60FFFFFF, 0x40FFFFFF, scheme -> scheme.tint(0.5));
        this.borderPainter = new CompositeBorderPainter(NAME, outerBorderPainter, innerBorderPainter);
        this.fillPainter = new FractionBasedFillPainter(NAME, new float[]{0.0f, 0.5f, 1.0f}, new ColorSchemeSingleColorQuery[]{ColorSchemeSingleColorQuery.EXTRALIGHT, ColorSchemeSingleColorQuery.LIGHT, ColorSchemeSingleColorQuery.MID});
        this.highlightPainter = new ClassicHighlightPainter();
        this.decorationPainter = new MatteDecorationPainter();
        this.buttonShaper = new ClassicButtonShaper();
    }
}

