/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter.overlay;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Line2D;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.ColorSchemeSingleColorQuery;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.overlay.SubstanceOverlayPainter;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public final class TopLineOverlayPainter
implements SubstanceOverlayPainter {
    ColorSchemeSingleColorQuery colorSchemeQuery;

    public TopLineOverlayPainter(ColorSchemeSingleColorQuery colorSchemeQuery) {
        this.colorSchemeQuery = colorSchemeQuery;
    }

    @Override
    public void paintOverlay(Graphics2D graphics, Component comp, SubstanceSlices.DecorationAreaType decorationAreaType, int width, int height, SubstanceSkin skin) {
        Component topMostWithSameDecorationAreaType = SubstanceCoreUtilities.getTopMostParentWithDecorationAreaType(comp, decorationAreaType);
        Point inTopMost = SwingUtilities.convertPoint(comp, new Point(0, 0), topMostWithSameDecorationAreaType);
        int dy = inTopMost.y;
        float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(comp);
        graphics.setStroke(new BasicStroke(borderStrokeWidth));
        SubstanceColorScheme colorScheme = skin.getBackgroundColorScheme(decorationAreaType);
        graphics.setColor(this.colorSchemeQuery.query(colorScheme));
        float topY = borderStrokeWidth - (float)dy;
        Line2D.Float line = new Line2D.Float(0.0f, topY, width, topY);
        graphics.draw(line);
    }

    @Override
    public String getDisplayName() {
        return "Top Line";
    }
}

